#ifndef SCI_CTRL_H
#define SCI_CTRL_H

/*!
  \file
  \brief SCI ̏

  \author Satofumi KAMIMURA

  $Id$
*/

#define SCI_USE_INTERRUPT        // MɊ荞݂p

enum {
  // SCI
#ifndef SCI_BUFFER_SIZE_SHIFT
  SCI_BUFFER_SIZE_SHIFT = 9,
#endif
  SCI_BUFFER_SIZE = 1 << SCI_BUFFER_SIZE_SHIFT,
};

typedef enum {
  SCI_0 = 0,
  SCI_1 = 1,
} sci_port;

extern void sci_init(sci_port port, int level);
extern int sci_write(sci_port port, const char *data, int size);
extern int sci_read(sci_port port, char *buffer, int size);
extern int sci_readable(sci_port port);
extern void sci_stop(sci_port port);
extern void sci_flush(sci_port port);

#endif /* !SCI_CTRL_H */
