/*!
  \file
  \brief SCI ̑M

  \author Satofumi KAMIMURA

  $Id$
*/

#include "sci_get.h"
#include "cpu_akiduki.h"


char sci_getchar(sci_port port) {

  char ch = '=';
  sci_read(port, &ch, 1);
  return ch;
}


int sci_gets(sci_port port, char *buffer, int max_size) {
  int i;

  --max_size;                        /* '\0' ̕ */
  for (i = 0; i < max_size; ++i) {
    char ch = sci_getchar(port);
    if ((ch == '\r') || (ch == '\n')) {
      break;
    }
    buffer[i] = ch;
  }
  buffer[i] = '\0';
  return i;
}
