/*
  linker script for SH7045F(alpha project)
  Satofumi KAMIMURA
  $Id: sh45load.x,v 1.1 2004/06/09 01:07:20 satofumi Exp $
*/

OUTPUT_FORMAT("coff-sh")
OUTPUT_ARCH(sh)
MEMORY
{
  rom(wx)   : o = 0x00000000, l = 256K
  ram(rw)   : o = 0x00400000, l = 1M
  stack(rw) : o = 0xfffff000, l = 4K
}
SECTIONS
{
  .text :
  {
    *(.text)
    *(.strings)
     _vec_ram = . ;
   LONG(ABSOLUTE(start))	/* 0 */
   LONG(ABSOLUTE(_stack))	/* 1 */
   LONG(ABSOLUTE(start))	/* 2 */
   LONG(ABSOLUTE(_stack))	/* 3 */
   LONG(DEFINED(_futou1)?ABSOLUTE(_futou1):ABSOLUTE(start))	/* 4 */
   . += 4;							/* 5 */
   LONG(DEFINED(_futou2)?ABSOLUTE(_futou2):ABSOLUTE(start))	/* 6 */
   . += 4*2;							/* 7,8 */
   LONG(DEFINED(_adderr1)?ABSOLUTE(_adderr1):ABSOLUTE(start))	/* 9 */
   LONG(DEFINED(_adderr2)?ABSOLUTE(_adderr2):ABSOLUTE(start))	/* 10 */
   LONG(DEFINED(_nmi)?ABSOLUTE(_num):ABSOLUTE(start))		/* 11 */
   LONG(DEFINED(_usr)?ABSOLUTE(_usr):ABSOLUTE(start))		/* 12 */
   . += 4*51;							/* 13-63 */
   LONG(DEFINED(_irq0)?ABSOLUTE(_irq0):ABSOLUTE(start))		/* 64 */
   LONG(DEFINED(_irq1)?ABSOLUTE(_irq1):ABSOLUTE(start))		/* 65 */
   LONG(DEFINED(_irq2)?ABSOLUTE(_irq2):ABSOLUTE(start))		/* 66 */
   LONG(DEFINED(_irq3)?ABSOLUTE(_irq3):ABSOLUTE(start))		/* 67 */
   LONG(DEFINED(_irq4)?ABSOLUTE(_irq4):ABSOLUTE(start))		/* 68 */
   LONG(DEFINED(_irq5)?ABSOLUTE(_irq5):ABSOLUTE(start))		/* 69 */
   LONG(DEFINED(_irq6)?ABSOLUTE(_irq6):ABSOLUTE(start))		/* 70 */
   LONG(DEFINED(_irq7)?ABSOLUTE(_irq7):ABSOLUTE(start))		/* 71 */
   LONG(DEFINED(_dmac0)?ABSOLUTE(_dmac0):ABSOLUTE(start))	/* 72 */
   . += 4*3;							/* 73-75 */
   LONG(DEFINED(_dmac1)?ABSOLUTE(_dmac1):ABSOLUTE(start))	/* 76 */
   . += 4*3;							/* 77-79 */
   LONG(DEFINED(_dmac2)?ABSOLUTE(_dmac2):ABSOLUTE(start))	/* 80 */
   . += 4*3;							/* 81-83 */
   LONG(DEFINED(_dmac3)?ABSOLUTE(_dmac3):ABSOLUTE(start))	/* 84 */
   . += 4*3;							/* 85-87 */
   LONG(DEFINED(_tgi0a)?ABSOLUTE(_tgi0a):ABSOLUTE(start))	/* 88 */
   LONG(DEFINED(_tgi0b)?ABSOLUTE(_tgi0b):ABSOLUTE(start))	/* 89 */
   LONG(DEFINED(_tgi0c)?ABSOLUTE(_tgi0c):ABSOLUTE(start))	/* 90 */
   LONG(DEFINED(_tgi0d)?ABSOLUTE(_tgi0d):ABSOLUTE(start))	/* 91 */
   LONG(DEFINED(_tgi0v)?ABSOLUTE(_tgi0v):ABSOLUTE(start))	/* 92 */
   . += 4*3;							/* 93-95 */
   LONG(DEFINED(_tgi1a)?ABSOLUTE(_tgi1a):ABSOLUTE(start))	/* 96 */
   LONG(DEFINED(_tgi1b)?ABSOLUTE(_tgi1b):ABSOLUTE(start))	/* 97 */
   . += 4*2;							/* 98,99 */
   LONG(DEFINED(_tgi1c)?ABSOLUTE(_tgi1v):ABSOLUTE(start))	/* 100 */
   LONG(DEFINED(_tgi1d)?ABSOLUTE(_tgi1u):ABSOLUTE(start))	/* 101 */
   . += 4*2;							/* 102,103 */
   LONG(DEFINED(_tgi2a)?ABSOLUTE(_tgi2a):ABSOLUTE(start))	/* 104 */
   LONG(DEFINED(_tgi2b)?ABSOLUTE(_tgi2b):ABSOLUTE(start))	/* 105 */
   . += 4*2;							/* 106,107 */
   LONG(DEFINED(_tgi2c)?ABSOLUTE(_tgi2v):ABSOLUTE(start))	/* 108 */
   LONG(DEFINED(_tgi2d)?ABSOLUTE(_tgi2u):ABSOLUTE(start))	/* 109 */
   . += 4*2;							/* 110,111*/
   LONG(DEFINED(_tgi3a)?ABSOLUTE(_tgi3a):ABSOLUTE(start))	/* 112 */
   LONG(DEFINED(_tgi3b)?ABSOLUTE(_tgi3b):ABSOLUTE(start))	/* 113 */
   LONG(DEFINED(_tgi3c)?ABSOLUTE(_tgi3c):ABSOLUTE(start))	/* 114 */
   LONG(DEFINED(_tgi3d)?ABSOLUTE(_tgi3d):ABSOLUTE(start))	/* 115 */
   LONG(DEFINED(_tgi3v)?ABSOLUTE(_tgi3v):ABSOLUTE(start))	/* 116 */
   . += 4*3;							/* 117-119 */
   LONG(DEFINED(_tgi4a)?ABSOLUTE(_tgi4a):ABSOLUTE(start))	/* 120 */
   LONG(DEFINED(_tgi4b)?ABSOLUTE(_tgi4b):ABSOLUTE(start))	/* 121 */
   LONG(DEFINED(_tgi4c)?ABSOLUTE(_tgi4c):ABSOLUTE(start))	/* 122 */
   LONG(DEFINED(_tgi4d)?ABSOLUTE(_tgi4d):ABSOLUTE(start))	/* 123 */
   LONG(DEFINED(_tgi4v)?ABSOLUTE(_tgi4v):ABSOLUTE(start))	/* 124 */
   . += 4*3;							/* 125-127 */
   LONG(DEFINED(_eri0)?ABSOLUTE(_eri0):ABSOLUTE(start))		/* 128 */
   LONG(DEFINED(_rxi0)?ABSOLUTE(_rxi0):ABSOLUTE(start))		/* 129 */
   LONG(DEFINED(_txi0)?ABSOLUTE(_txi0):ABSOLUTE(start))		/* 130 */
   LONG(DEFINED(_tei0)?ABSOLUTE(_tei0):ABSOLUTE(start))		/* 131 */
   LONG(DEFINED(_eri1)?ABSOLUTE(_eri1):ABSOLUTE(start))		/* 132 */
   LONG(DEFINED(_rxi1)?ABSOLUTE(_rxi1):ABSOLUTE(start))		/* 133 */
   LONG(DEFINED(_txi1)?ABSOLUTE(_txi1):ABSOLUTE(start))		/* 134 */
   LONG(DEFINED(_tei1)?ABSOLUTE(_tei1):ABSOLUTE(start))		/* 135 */
   LONG(DEFINED(_adi)?ABSOLUTE(_adi):ABSOLUTE(start))		/* 136 */
   . += 4*3;							/* 137-139 */
   LONG(DEFINED(_swdtce)?ABSOLUTE(_swdtce):ABSOLUTE(start))	/* 140 */
   . += 4*3;							/* 141-143 */
   LONG(DEFINED(_cmi0)?ABSOLUTE(_cmi0):ABSOLUTE(start))		/* 144 */
   . += 4*3;							/* 145-147 */
   LONG(DEFINED(_cmi1)?ABSOLUTE(_cmi1):ABSOLUTE(start))		/* 148 */
   . += 4*3;							/* 149-151 */
   LONG(DEFINED(_iti)?ABSOLUTE(_iti):ABSOLUTE(start))		/* 152 */
   LONG(DEFINED(_cmi)?ABSOLUTE(_cmi):ABSOLUTE(start))		/* 153 */
   . += 4*2;							/* 154,155 */
   LONG(DEFINED(_oei)?ABSOLUTE(_oei):ABSOLUTE(start))		/* 156 */

   _cp_start = (. + 0x10) & 0xfffffff0 ;
  }  > ram

  .tors :
  {
    _data_start = . ;
    ___ctors = . ;
    *(.ctors)
    ___ctors_end = . ;
    ___dtors = . ;
    *(.dtors)
    ___dtors_end = . ;
  } > ram

  .data :
  {
    *(.data)
    _edata = . ;
    _cp_end = . ;
  }  > ram

  .bss :
  {
     _bss_start = . ;
    *(.bss)
    *(COMMON)
     _end = . ;
  }  > ram

  .stack 0x00400000+1M-0x10 (NOLOAD) :
  {
     _stack = . ;
    *(.stack)
  }  > ram

  .stab 0 (NOLOAD) :
  {
    *(.stab)
  }
  .stabstr 0 (NOLOAD) :
  {
    *(.stabstr)
  }

/*
  .comment        0 (NOLOAD) : { *(.comment) }
  .debug          0 (NOLOAD) : { *(.debug) }
  .line           0 (NOLOAD) : { *(.line) }
  .debug_srcinfo  0 (NOLOAD) : { *(.debug_srcinfo) }
  .debug_sfnames  0 (NOLOAD) : { *(.debug_sfnames) }
  .debug_aranges  0 (NOLOAD) : { *(.debug_aranges) }
  .debug_pubnames 0 (NOLOAD) : { *(.debug_pubnames) }
*/
}
