/*!
  \file
  \brief PPM wb_t@C̐

  \author Satofumi KAMIMURA

  $Id$
*/

#include "CreatePpmArrayFromSurface.h"
#include <SDL_image.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

using namespace beego;


int main(int argc, char *argv[]) {

  if (argc < 2) {
    printf("usage:\n\t%s <image file>\n", argv[0]);
    exit(1);
  }

  const char* fname = argv[1];
  SDL_Surface* surface = IMG_Load(fname);
  if (surface == NULL) {
    // !!!
    fprintf(stderr, "%s\n", IMG_GetError());
    exit(1);
  }

  int width, height;
  char* ppm_data = createPpmArray(surface, &width, &height);

  char* base_name = (argc >= 3)
    ? argv[2] : strtok(const_cast<char*>(fname), ".");

  char* large_baseName = strdup(base_name);
  for (int i = 0; large_baseName[i] != '\0'; ++i) {
    large_baseName[i] = toupper(large_baseName[i]);
  }
  printf("#ifndef %s_H\n"
         "#define %s_H\n"
         "\n"
         "/* created by using createPpmHeader. */\n"
         "\n", large_baseName, large_baseName);

  printf("static const int %s_width = %d;\n"
         "static const int %s_height = %d;\n",
         base_name, width, base_name, height);

  // f[^z̏o
  int data_size = width * height * 4;
  printf("static const unsigned char %s[%d] =\n  {", base_name, data_size);
  for (int i = 0; i < data_size; ++i) {
    if (i % 15 == 0) {
      printf("\n    ");
    }
    printf("0x%02x,", static_cast<unsigned char>(ppm_data[i]));
  }
  printf("\n  };\n");

  printf("\n"
         "#endif /* !%s_H */\n", large_baseName);

  SDL_FreeSurface(surface);
  free(large_baseName);
  delete ppm_data;

  return 0;
}
