/*!
  \file
  \brief ^[Qbg̃V~[^

  \author Satofumi KAMIMURA

  lTX񋟂́uSH704x V[Ỹn[hEFA}jAvɏ]Ď

  $Id$
*/

#include "WriteTargetSimulator.h"
#include "TcpipAccept.h"
#include "ThreadCreator.h"
#include "TargetSimulatorPort.h"
#include "TcpipCtrl.h"
#include "write_rom.h"

using namespace beego;


static ConnectionInterface* DummyCom = NULL;

enum { NoTimeout = -1 };


char getch(void) {
  char ch;
  DummyCom->recv(&ch, 1, NoTimeout);
  return ch;
}


void getstr(char *buffer, int len) {
  DummyCom->recv(buffer, len, NoTimeout);
}


void flush(void) {
}


void putch(char ch) {
  DummyCom->send(&ch, 1);
}


int writeFlushRom(long addr, unsigned char *data) {
  // _~[BȂ
  return 0;
}


int setBaudrate(long baudrate) {
  // _~[BȂ
  return 0;
}


static void recvWriteProgram(TcpipCtrl* socket) {

  // {LSI ́Arbg[gI̍}Ƃ 0x00  1byte M
  char ch;
  do {
    //fprintf(stderr, "!");
    socket->recv(&ch, 1, NoTimeout);
  } while (ch != 0x00);
  socket->send(&ch, 1);

  // zXg 0x55  1byte MA0xaa  1byte M
  do {
    socket->recv(&ch, 1, NoTimeout);
  } while (ch != 0x55);
  ch = 0xaa;
  socket->send(&ch, 1);

  // M]vÕoCg̏ʁAʂGR[obN
  unsigned char size_byte[2];
  socket->recv((char *)size_byte, 2, NoTimeout);
  socket->send((char *)size_byte, 2);

  // ]ꂽvÕf[^ 1byte ɃGR[obN
  size_t recv_size = (size_byte[0] << 8) | size_byte[1];
  for (size_t i = 0; i < recv_size; ++i) {
    socket->recv(&ch, 1, NoTimeout);
    socket->send(&ch, 1);
  }

  // tbV̏A0xaa  1byte M
  // iɎsꍇA0xff 𑗐Mj
  ch = 0xaa;
  socket->send(&ch, 1);

  // ROM ɓ]ꂽvOs
  return;
}


struct TargetSimulator::pImpl {
  class ThreadArgs {
  public:
    TcpipCtrl* socket;
    TcpipAccept accept;

    ThreadArgs(void) : socket(NULL) {
    }
  };
  ThreadArgs thread_args;
  ThreadCreator thread;


  pImpl(void) : thread(simulator_thread, &thread_args) {
  }


  static int simulator_thread(void* args) {
    ThreadArgs* info = static_cast<ThreadArgs*>(args);

    // ڑ҂
    while (! info->socket) {
      info->socket = info->accept.accept(1);
      DummyCom = info->socket;
    }

    // F-ZTAT ̏f[^]̉
    recvWriteProgram(info->socket);

    // ݃vgRɑ΂鉞
    writeRom();                        // ͖߂Ȃ

    return 0;
  }
};


TargetSimulator::TargetSimulator(void) : pimpl(new pImpl) {
}


TargetSimulator::~TargetSimulator(void) {
}


void TargetSimulator::activate(void) {

  // Qڂ̌Ăяoɂ͖߂
  static bool activated = false;
  if (activated) {
    return;
  }
  activated = true;

  // ^[Qbg̏sXbh̋N
  pimpl->thread_args.accept.activate(TargetSimulatorPort);
  pimpl->thread.run(1);
}


void TargetSimulator::runMainTask(void) {
  // _~[
}
