OUTPUT_FORMAT("coff-sh")
OUTPUT_ARCH(sh)
MEMORY
{
  ramL(rw)	: o = 0xfffff000, l = 2K
  ramH(rw)	: o = 0xfffff800, l = 2K
}
SECTIONS
{
  .text :
  {
    *(.text)
    *(.strings)
     _etext = . ; 
  }  > ramL
  .tors :
  {
    ___ctors = . ;
    *(.ctors)
    ___ctors_end = . ;
    ___dtors = . ;
    *(.dtors)
    ___dtors_end = . ;
  } > ramL
  .data :
  {
    *(.data)
     _edata = . ; 
  }  > ramL
  .bss :
  {
     _bss_start = . ; 
    *(.bss)
    *(COMMON)
     _end = . ;  
  }  > ramL

  .stack  0xfffff000+2K-0x10 (NOLOAD) :
  {
     _stack = . ;
    *(.stack)
  }  > ramL

  .stab 0 (NOLOAD) :
  {
    *(.stab)
  }
  .stabstr 0 (NOLOAD) :
  {
    *(.stabstr)
  }
}
