/*!
  \file
  \brief ݃R[h]pf[^ɕϊ

  \author Satofumi KAMIMURA

  $Id$
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include "SFormatHandler.h"

using namespace beego;


/* w S-format t@CoCgzɕϊĔz錾Ƃďo */
int main(int argc, char *argv[]) {

  /* t@CJ */
  FILE *fd = NULL;
  if (argc > 1) {
    fd = fopen(argv[1], "r");
    if (fd == NULL) {
      perror("fopen");
      exit(1);
    }
  } else {
    fprintf(stderr, "usage : %s <file_name>\n", argv[0]);
    exit(1);
  }

  /* S-format oCgzɓWJ */
  char line[49];
  SFormatHandler::srec_t srec;
  int line_cnt = 0;
  int index;
  char code[4096];
  memset(code, 4096, 0);
  int last_index = 0;
  while (1) {
    /* Pso */
    if (fscanf(fd, "%s\r\n", line) <= 0) {
      ++line_cnt;
      break;
    }
    /* S-format ̃p[X */
    if (SFormatHandler::parseLine(&srec, line) < 0) {
      printf("line: %s\n", line);
      fprintf(stderr, "sformat error at %d\n", line_cnt);
      exit(1);
    }
    if (srec.type < 1 || srec.type > 3) {
      continue;
    }
    /* oCgzɏo */
    index = srec.address - 0xfffff000;
    for (int i = 0; i < srec.data_size; ++i) {
      code[index + i] = srec.byte_data[i];
      if (index + i > last_index) {
        last_index = index + i;
      }
    }
  }
  fclose(fd);

  /* b̔z錾̌`ŏo */
  char ch;
  printf("static char write_program[] =\n\"");
  for (int i = 0; i <= last_index; ++i) {
    ch = code[i];
    if (i % 16 == 0 && i != 0) {
      printf("\"\n\"");
    }
    printf("\\x%02x", (unsigned char)ch);
  }
  printf("\";\n");

  return 0;
}
