/*!
  \file
  \brief sloader p̃^[QbgV~[^

  \author Satofumi kAMIMURA

  $Id$
*/

#include "LoaderTargetSimulator.h"
#include "FZtatHandler.h"
#include "LoaderTargetPort.h"
#include "TcpipCtrl.h"
#include "TcpipAccept.h"
#include "ThreadCreator.h"
#include "write_rom.h"
#include "ConnectionLogger.h"

using namespace beego;


static ConnectionInterface* DummyCom = NULL;

enum { NoTimeout = -1 };


char getch(void) {
  char ch;
  DummyCom->recv(&ch, 1, NoTimeout);
  return ch;
}


void getstr(char *buffer, int len) {
  DummyCom->recv(buffer, len, NoTimeout);
}


void flush(void) {
}


void putch(char ch) {
  DummyCom->send(&ch, 1);
}


int writeFlushRom(long addr, unsigned char *data) {
  // _~[BȂ
  return 0;
}


int setBaudrate(long baudrate) {
  // _~[BȂ
  return 0;
}


/*!
  \brief LoaderTargetSimulator ̓NX
*/
struct LoaderTargetSimulator::pImpl {
  FZtatHandler& fztat;

  /*!
    \brief XbhǗ̓NX
  */
  class ThreadArgs {
  public:
    TcpipCtrl* socket;
    TcpipAccept accept;

    ThreadArgs(void) : socket(NULL) {
    }
  };
  ThreadArgs thread_args;
  ThreadCreator thread;

  pImpl(FZtatHandler& fztat_ref)
    : fztat(fztat_ref), thread(simulator_thread, &thread_args) {
  }

  static int simulator_thread(void* args) {
    ThreadArgs* info = static_cast<ThreadArgs*>(args);

    // ڑ҂
    while (! info->socket) {
      info->socket = info->accept.accept(1);
      DummyCom = info->socket;
    }

    // ݃vgRɑ΂鉞
    writeRom();

    getch();
    unsigned address = recvAddress();
    fprintf(stderr, "run address: %08x\n", address);

    return 0;
  }
};


LoaderTargetSimulator::LoaderTargetSimulator(FZtatHandler& fztat)
  : pimpl(new pImpl(fztat)) {
}


LoaderTargetSimulator::~LoaderTargetSimulator(void) {
}


void LoaderTargetSimulator::activate(void) {

  ConnectionInterface*& con = pimpl->fztat.getConnection();
  delete con;

  // ^[Qbg̏sXbh̋N
  pimpl->thread_args.accept.activate(LoaderTargetPort);
  pimpl->thread.run(1);

  con = new ConnectionLogger(new TcpipCtrl);
  con->connect("localhost", LoaderTargetPort);
}
