/*!
  \file
  \brief sloader Ή SH7045pvO

  \author Satofumi KAMIMURA

  $Id$
*/

#include "tiny_sci.h"
#include "write_rom.h"


int writeFlushRom(long addr, unsigned char *data) {
  int i;

  char *address = (char *)addr;
  for (i = 0; i < 32; ++i) {
    *(address + i) = data[i];
  }

  return 0;
}


static void jumpRecvAddress(void) {
  unsigned long address;

  getch();
  address = recvAddress();
  asm("        jmp @%0 ": : "r"(address));
}


void __main(void){};
int main(void) {

  // VAʐM̏
  enum {
    FirstBaudrate = 19200,
    MessageBaudrate = 115200,
  };
  initSCI(MessageBaudrate);
  putstr("reset.\r\n");
  flush();
  setBaudrate(FirstBaudrate);

  // S-Format t@C̓]
  getch();
  writeRom();

  // wAhXɕ
  jumpRecvAddress();

  return 0;
}
