/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.statistics;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.BreakIterator;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TransMemory;
import org.omegat.core.matching.FuzzyMatcher;
import org.omegat.core.matching.ISimilarityCalculator;
import org.omegat.core.matching.Tokenizer;
import org.omegat.util.Log;
import org.omegat.util.PatternConsts;
import org.omegat.util.StringUtil;
import org.omegat.util.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Statistics {
    protected static final int PERCENT_EXACT_MATCH = 101;
    protected static final int PERCENT_REPETITIONS = 102;

    public static int getMaxSimilarityPercent(SourceTextEntry sourceTextEntry, ISimilarityCalculator iSimilarityCalculator, List<SourceTextEntry> list, Map<String, Token[]> map, Set<String> set) {
        Token[] tokenArray;
        boolean bl = set.add(sourceTextEntry.getSrcText());
        if (!StringUtil.isEmpty(sourceTextEntry.getTranslation())) {
            return 101;
        }
        Token[] tokenArray2 = Statistics.tokenizeExactlyWithCache(map, sourceTextEntry.getSrcText());
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            SourceTextEntry sourceTextEntry2 = list.get(i);
            if (sourceTextEntry2 == sourceTextEntry || StringUtil.isEmpty(sourceTextEntry2.getTranslation())) continue;
            tokenArray = Statistics.tokenizeExactlyWithCache(map, sourceTextEntry2.getSrcText());
            int n2 = FuzzyMatcher.calcSimilarity(iSimilarityCalculator, tokenArray2, tokenArray);
            n = Math.max(n, n2);
        }
        List<TransMemory> list2 = Core.getProject().getTransMemory();
        for (int i = 0; i < list2.size(); ++i) {
            tokenArray = list2.get(i);
            Token[] tokenArray3 = Statistics.tokenizeExactlyWithCache(map, tokenArray.source);
            int n3 = FuzzyMatcher.calcSimilarity(iSimilarityCalculator, tokenArray2, tokenArray3);
            n = Math.max(n, n3);
        }
        if (n < 50 && !bl) {
            n = 102;
        }
        return n;
    }

    private static Token[] tokenizeExactlyWithCache(Map<String, Token[]> map, String string) {
        Token[] tokenArray = map.get(string);
        if (tokenArray == null) {
            tokenArray = Core.getTokenizer().tokenizeAllExactly(string);
            map.put(string, tokenArray);
        }
        return tokenArray;
    }

    public static int numberOfCharactersWithoutSpaces(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isSpaceChar(string.charAt(i))) continue;
            ++n;
        }
        return n;
    }

    public static int numberOfWords(String string) {
        int n = string.length();
        if (n == 0) {
            return 0;
        }
        int n2 = 0;
        BreakIterator breakIterator = Tokenizer.getWordBreaker();
        breakIterator.setText(string);
        String string2 = new String();
        int n3 = breakIterator.first();
        int n4 = breakIterator.next();
        while (n4 != -1) {
            string2 = string.substring(n3, n4);
            boolean bl = false;
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                if (!Character.isLetterOrDigit(c)) continue;
                bl = true;
                break;
            }
            if (bl && !PatternConsts.OMEGAT_TAG.matcher(string2).matches()) {
                ++n2;
            }
            n3 = n4;
            n4 = breakIterator.next();
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStat(String string, String string2) {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8");
            try {
                outputStreamWriter.write(DateFormat.getInstance().format(new Date()) + "\n");
                outputStreamWriter.write(string2);
                outputStreamWriter.flush();
            }
            finally {
                outputStreamWriter.close();
            }
        }
        catch (Exception exception) {
            Log.log(exception);
        }
    }
}

