/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2;

public class LBuffer {
    private char[] m_buf;
    private int m_size;

    public LBuffer(int n) {
        int n2 = LBuffer.PowerOfTwo(n);
        if (n2 < 4) {
            n2 = 4;
        }
        this.m_buf = new char[n2];
        this.m_size = 0;
    }

    public void append(LBuffer lBuffer) {
        if (lBuffer.length() + this.m_size > this.m_buf.length) {
            this.setSize(lBuffer.length() + this.m_size);
        }
        char[] cArray = lBuffer.getBuf();
        System.arraycopy(cArray, 0, this.m_buf, this.m_size, lBuffer.length());
        this.m_size += lBuffer.length();
    }

    public void append(String string) {
        if (string.length() + this.m_size > this.m_buf.length) {
            this.setSize(string.length() + this.m_size);
        }
        string.getChars(0, string.length(), this.m_buf, this.m_size);
        this.m_size += string.length();
    }

    public void append(char c) {
        if (this.m_size + 1 > this.m_buf.length) {
            this.setSize(this.m_size + 1);
        }
        this.m_buf[this.m_size] = c;
        ++this.m_size;
    }

    public char getZeroChar() {
        if (0 >= this.m_size) {
            return '\u0000';
        }
        return this.m_buf[0];
    }

    public boolean isEqual(LBuffer lBuffer) {
        if (lBuffer.length() != this.m_size) {
            return false;
        }
        for (int i = 0; i < this.m_size; ++i) {
            if (this.m_buf[i] == lBuffer.m_buf[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isEqualIgnoreCase(String string) {
        if (string.length() != this.m_size) {
            return false;
        }
        String string2 = new String(this.m_buf, 0, this.m_size);
        return string.compareToIgnoreCase(string2) == 0;
    }

    public String string() {
        return new String(this.m_buf, 0, this.m_size);
    }

    public void appendInt(int n) {
        this.append(Integer.toString(n));
    }

    private void setSize(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > this.m_buf.length) {
            int n2;
            for (n2 = this.m_buf.length; n > n2; n2 *= 2) {
            }
            char[] cArray = new char[n2];
            System.arraycopy(this.m_buf, 0, cArray, 0, this.m_buf.length);
            this.m_buf = cArray;
        }
        if (this.m_size > n) {
            this.m_size = n;
        }
    }

    public void reset() {
        this.m_size = 0;
    }

    private static int PowerOfTwo(int n) {
        int n2 = 0;
        int n3 = n;
        int n4 = 0;
        int n5 = 0;
        if (n > 0) {
            while (n != 0) {
                ++n4;
                if ((n & 1) != 0) {
                    ++n5;
                }
                n >>= 1;
            }
            n2 = n5 == 1 ? n3 : 1 << n4;
        }
        return n2;
    }

    private int length() {
        return this.m_size;
    }

    public int size() {
        return this.m_size;
    }

    public char[] getBuf() {
        return this.m_buf;
    }
}

