/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.text;

import java.awt.Dialog;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.Instance;
import org.omegat.filters2.text.TextOptions;
import org.omegat.filters2.text.TextOptionsDialog;
import org.omegat.util.LinebreakPreservingReader;
import org.omegat.util.Log;
import org.omegat.util.OStrings;

public class TextFilter
extends AbstractFilter {
    public String getFileFormatName() {
        return OStrings.getString("TEXTFILTER_FILTER_NAME");
    }

    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.txt"), new Instance("*.txt1", "ISO-8859-1", "ISO-8859-1"), new Instance("*.txt2", "ISO-8859-2", "ISO-8859-2"), new Instance("*.utf8", "UTF-8", "UTF-8")};
    }

    public boolean isSourceEncodingVariable() {
        return true;
    }

    public boolean isTargetEncodingVariable() {
        return true;
    }

    public void processFile(BufferedReader bufferedReader, BufferedWriter bufferedWriter) throws IOException {
        TextOptions textOptions;
        bufferedReader.mark(1);
        int n = bufferedReader.read();
        if (n != 65279) {
            bufferedReader.reset();
        }
        if ((textOptions = (TextOptions)this.getOptions()) == null) {
            textOptions = new TextOptions();
        }
        switch (textOptions.getSegmentOn()) {
            case 1: {
                this.processSegLineBreaks(bufferedReader, bufferedWriter);
                break;
            }
            case 2: {
                this.processSegEmptyLines(bufferedReader, bufferedWriter);
                break;
            }
            default: {
                this.processNonSeg(bufferedReader, bufferedWriter);
            }
        }
    }

    private void processNonSeg(BufferedReader bufferedReader, Writer writer) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[4096];
        while ((n = bufferedReader.read(cArray)) >= 0) {
            stringBuffer.append(cArray, 0, n);
        }
        writer.write(this.processEntry(stringBuffer.toString()));
    }

    private void processSegLineBreaks(BufferedReader bufferedReader, Writer writer) throws IOException {
        String string;
        LinebreakPreservingReader linebreakPreservingReader = new LinebreakPreservingReader(bufferedReader);
        String string2 = "";
        while ((string = linebreakPreservingReader.readLine()) != null) {
            if (string.trim().length() == 0) {
                string2 = string2 + string + linebreakPreservingReader.getLinebreak();
                continue;
            }
            String string3 = string;
            writer.write(string2);
            string2 = "";
            String string4 = this.processEntry(string3);
            writer.write(string4);
            string2 = string2 + linebreakPreservingReader.getLinebreak();
        }
        if (string2.length() != 0) {
            writer.write(string2);
        }
    }

    private void processSegEmptyLines(BufferedReader bufferedReader, Writer writer) throws IOException {
        String string;
        LinebreakPreservingReader linebreakPreservingReader = new LinebreakPreservingReader(bufferedReader);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        while ((string = linebreakPreservingReader.readLine()) != null) {
            if (string.length() == 0) {
                writer.write(stringBuffer.toString());
                stringBuffer.setLength(0);
                writer.write(this.processEntry(stringBuffer2.toString()));
                stringBuffer2.setLength(0);
                stringBuffer.append(linebreakPreservingReader.getLinebreak());
                continue;
            }
            if (string.trim().length() == 0 && stringBuffer2.length() == 0) {
                stringBuffer.append(string);
                stringBuffer.append(linebreakPreservingReader.getLinebreak());
                continue;
            }
            stringBuffer2.append(string);
            stringBuffer2.append(linebreakPreservingReader.getLinebreak());
        }
        if (stringBuffer.length() >= 0) {
            writer.write(stringBuffer.toString());
        }
        if (stringBuffer2.length() >= 0) {
            writer.write(this.processEntry(stringBuffer2.toString()));
        }
    }

    public Serializable changeOptions(Dialog dialog, Serializable serializable) {
        try {
            TextOptions textOptions = (TextOptions)serializable;
            TextOptionsDialog textOptionsDialog = new TextOptionsDialog(dialog, textOptions);
            textOptionsDialog.setVisible(true);
            if (1 == textOptionsDialog.getReturnStatus()) {
                return textOptionsDialog.getOptions();
            }
            return serializable;
        }
        catch (Exception exception) {
            Log.log("Text filter threw an exception:");
            Log.log(exception);
            return serializable;
        }
    }

    public boolean hasOptions() {
        return true;
    }
}

