/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml.opendoc;

import java.awt.Dialog;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.Instance;
import org.omegat.filters2.TranslationException;
import org.omegat.filters3.xml.opendoc.EditOpenDocOptionsDialog;
import org.omegat.filters3.xml.opendoc.OpenDocDialect;
import org.omegat.filters3.xml.opendoc.OpenDocOptions;
import org.omegat.filters3.xml.opendoc.OpenDocXMLFilter;
import org.omegat.util.LFileCopy;
import org.omegat.util.Log;
import org.omegat.util.OStrings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenDocFilter
extends AbstractFilter {
    private static final Set<String> TRANSLATABLE = new HashSet<String>(Arrays.asList("content.xml", "styles.xml", "meta.xml"));
    OpenDocXMLFilter xmlfilter = null;

    @Override
    public boolean isFileSupported(File file, String string) {
        try {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (!TRANSLATABLE.contains(zipEntry.getName())) continue;
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private OpenDocXMLFilter getXMLFilter() {
        if (this.xmlfilter == null) {
            this.xmlfilter = new OpenDocXMLFilter();
            this.xmlfilter.setParseCallback(this.entryProcessingCallback);
        }
        OpenDocDialect openDocDialect = (OpenDocDialect)this.xmlfilter.getDialect();
        openDocDialect.defineDialect((OpenDocOptions)this.getOptions());
        return this.xmlfilter;
    }

    private File tmp() throws IOException {
        return File.createTempFile("ot-oo-", ".xml");
    }

    @Override
    public List<File> processFile(File file, String string, File file2, String string2) throws IOException, TranslationException {
        ZipFile zipFile = new ZipFile(file);
        ZipOutputStream zipOutputStream = null;
        if (file2 != null) {
            zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            Object object;
            ZipEntry zipEntry = enumeration.nextElement();
            String string3 = zipEntry.getName();
            if (string3.lastIndexOf(47) >= 0) {
                string3 = string3.substring(string3.lastIndexOf(47) + 1);
            }
            if (TRANSLATABLE.contains(string3)) {
                object = this.tmp();
                LFileCopy.copy(zipFile.getInputStream(zipEntry), (File)object);
                File file3 = null;
                if (zipOutputStream != null) {
                    file3 = this.tmp();
                }
                try {
                    this.getXMLFilter().processFile((File)object, null, file3, null);
                }
                catch (Exception exception) {
                    throw new TranslationException(exception.getLocalizedMessage() + "\n" + OStrings.getString("OpenDoc_ERROR_IN_FILE") + file);
                }
                if (zipOutputStream != null) {
                    ZipEntry zipEntry2 = new ZipEntry(zipEntry.getName());
                    zipEntry2.setMethod(8);
                    zipOutputStream.putNextEntry(zipEntry2);
                    LFileCopy.copy(file3, (OutputStream)zipOutputStream);
                    zipOutputStream.closeEntry();
                }
                if (!((File)object).delete()) {
                    ((File)object).deleteOnExit();
                }
                if (file3 == null || file3.delete()) continue;
                file3.deleteOnExit();
                continue;
            }
            if (zipOutputStream == null) continue;
            object = new ZipEntry(zipEntry.getName());
            zipOutputStream.putNextEntry((ZipEntry)object);
            LFileCopy.copy(zipFile.getInputStream(zipEntry), (OutputStream)zipOutputStream);
            zipOutputStream.closeEntry();
        }
        if (zipOutputStream != null) {
            zipOutputStream.close();
        }
        return null;
    }

    @Override
    public String getFileFormatName() {
        return OStrings.getString("OpenDoc_FILTER_NAME");
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.sx?"), new Instance("*.st?"), new Instance("*.od?"), new Instance("*.ot?")};
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return false;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return false;
    }

    @Override
    protected void processFile(BufferedReader bufferedReader, BufferedWriter bufferedWriter) throws IOException, TranslationException {
        throw new IOException("Not Implemented!");
    }

    @Override
    public boolean hasOptions() {
        return true;
    }

    @Override
    public Serializable changeOptions(Dialog dialog, Serializable serializable) {
        try {
            OpenDocOptions openDocOptions = (OpenDocOptions)serializable;
            EditOpenDocOptionsDialog editOpenDocOptionsDialog = new EditOpenDocOptionsDialog(dialog, openDocOptions);
            editOpenDocOptionsDialog.setVisible(true);
            if (1 == editOpenDocOptionsDialog.getReturnStatus()) {
                return editOpenDocOptionsDialog.getOptions();
            }
            return serializable;
        }
        catch (Exception exception) {
            Log.logErrorRB("HTML_EXC_EDIT_OPTIONS", new Object[0]);
            Log.log(exception);
            return serializable;
        }
    }
}

