/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.common;

import java.awt.Font;
import javax.swing.JTextPane;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.StringEntry;
import org.omegat.core.events.IEntryEventListener;
import org.omegat.core.events.IFontChangedEventListener;
import org.omegat.core.events.IProjectEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EntryInfoPane<T>
extends JTextPane
implements IProjectEventListener,
IEntryEventListener {
    StringEntry currentlyProcessedEntry;

    public EntryInfoPane(boolean bl) {
        if (bl) {
            this.setFont(Core.getMainWindow().getApplicationFont());
            CoreEvents.registerFontChangedEventListener(new IFontChangedEventListener(){

                public void onFontChanged(Font font) {
                    EntryInfoPane.this.setFont(font);
                }
            });
        }
        CoreEvents.registerProjectChangeListener(this);
        CoreEvents.registerEntryEventListener(this);
    }

    @Override
    public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE pROJECT_CHANGE_TYPE) {
        switch (pROJECT_CHANGE_TYPE) {
            case CREATE: 
            case LOAD: {
                this.currentlyProcessedEntry = null;
                this.onProjectOpen();
                break;
            }
            case CLOSE: {
                this.currentlyProcessedEntry = null;
                this.onProjectClose();
            }
        }
    }

    protected void onProjectOpen() {
    }

    protected void onProjectClose() {
    }

    @Override
    public void onNewFile(String string) {
        this.currentlyProcessedEntry = null;
    }

    @Override
    public void onEntryActivated(StringEntry stringEntry) {
        this.currentlyProcessedEntry = stringEntry;
        this.startSearchThread(stringEntry);
    }

    protected abstract void startSearchThread(StringEntry var1);

    protected abstract void setFoundResult(T var1);

    protected void setError(Exception exception) {
    }
}

