/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.awt.Font;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.omegat.gui.editor.EditorController;

public class Document3
extends DefaultStyledDocument {
    protected final EditorController controller;
    Position activeTranslationBeginM1;
    Position activeTranslationEndP1;
    protected boolean trustedChangesInProgress = false;

    public Document3(EditorController editorController) {
        this.controller = editorController;
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        Style style = styleContext.getStyle("default");
        style.addAttribute("FONT_ATTRIBUTE_KEY", new Font("Arial", 0, 18));
    }

    protected int getTranslationStart() {
        return this.activeTranslationBeginM1.getOffset() + 1;
    }

    protected int getTranslationEnd() {
        return this.activeTranslationEndP1.getOffset() - 1;
    }

    public Font getFont(AttributeSet attributeSet) {
        if (StyleConstants.isBold(attributeSet)) {
            return this.controller.boldFont;
        }
        return this.controller.baseFont;
    }

    boolean isEditMode() {
        return this.activeTranslationBeginM1 != null && this.activeTranslationEndP1 != null;
    }

    void stopEditMode() {
        this.activeTranslationBeginM1 = null;
        this.activeTranslationEndP1 = null;
    }

    String extractTranslation() {
        if (!this.isEditMode()) {
            return null;
        }
        int n = this.getTranslationStart();
        int n2 = this.getTranslationEnd();
        try {
            return this.getText(n, n2 - n);
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException(badLocationException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAlignment(int n, int n2, boolean bl) {
        try {
            this.writeLock();
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, n, n2 - n, DocumentEvent.EventType.CHANGE);
            Element element = this.getDefaultRootElement();
            int n3 = element.getElementIndex(n);
            int n4 = element.getElementIndex(n2 - 1);
            for (int i = n3; i <= n4; ++i) {
                Element element2 = element.getElement(i);
                MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)element2.getAttributes();
                mutableAttributeSet.addAttribute(StyleConstants.Alignment, bl ? 2 : 0);
            }
            defaultDocumentEvent.end();
            this.fireChangedUpdate(defaultDocumentEvent);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ORIENTATION {
        LTR,
        RTL,
        DIFFER;

    }
}

