/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import javax.swing.text.AttributeSet;
import org.omegat.core.Core;
import org.omegat.gui.editor.EditorController;
import org.omegat.util.Preferences;
import org.omegat.util.gui.Styles;
import org.omegat.util.gui.UIThreadsUtil;

public class EditorSettings {
    private final EditorController parent;
    private boolean useTabForAdvance;
    private boolean markTranslated;
    private boolean markUntranslated;
    private boolean displaySegmentSources;
    private boolean autoSpellChecking;

    protected EditorSettings(EditorController editorController) {
        this.parent = editorController;
        this.useTabForAdvance = Preferences.isPreference("tab_advance");
        this.markTranslated = Preferences.isPreference("mark_translated_segments");
        this.markUntranslated = Preferences.isPreference("mark_untranslated_segments");
        this.displaySegmentSources = Preferences.isPreference("display_segment_sources");
        this.autoSpellChecking = Preferences.isPreference("allow_auto_spellchecking");
    }

    public char getAdvancerChar() {
        if (this.useTabForAdvance) {
            return '\t';
        }
        return '\n';
    }

    public AttributeSet getTranslatedAttributeSet() {
        return this.markTranslated ? Styles.TRANSLATED : Styles.PLAIN;
    }

    public AttributeSet getUntranslatedAttributeSet() {
        return this.markUntranslated ? Styles.UNTRANSLATED : Styles.PLAIN;
    }

    public boolean isUseTabForAdvance() {
        return this.useTabForAdvance;
    }

    public void setUseTabForAdvance(boolean bl) {
        this.useTabForAdvance = bl;
        Preferences.setPreference("tab_advance", bl);
    }

    public boolean isMarkTranslated() {
        return this.markTranslated;
    }

    public void setMarkTranslated(boolean bl) {
        UIThreadsUtil.mustBeSwingThread();
        this.parent.commitAndDeactivate();
        this.markTranslated = bl;
        Preferences.setPreference("mark_translated_segments", bl);
        if (Core.getProject().isProjectLoaded()) {
            this.parent.loadDocument();
            this.parent.activateEntry();
        }
    }

    public boolean isMarkUntranslated() {
        return this.markUntranslated;
    }

    public void setMarkUntranslated(boolean bl) {
        UIThreadsUtil.mustBeSwingThread();
        this.parent.commitAndDeactivate();
        this.markUntranslated = bl;
        Preferences.setPreference("mark_untranslated_segments", bl);
        if (Core.getProject().isProjectLoaded()) {
            this.parent.loadDocument();
            this.parent.activateEntry();
        }
    }

    public boolean isDisplaySegmentSources() {
        return this.displaySegmentSources;
    }

    public void setDisplaySegmentSources(boolean bl) {
        UIThreadsUtil.mustBeSwingThread();
        this.parent.commitAndDeactivate();
        this.displaySegmentSources = bl;
        Preferences.setPreference("display_segment_sources", bl);
        if (Core.getProject().isProjectLoaded()) {
            this.parent.loadDocument();
            this.parent.activateEntry();
        }
    }

    public boolean isAutoSpellChecking() {
        return this.autoSpellChecking;
    }

    public void setAutoSpellChecking(boolean bl) {
        UIThreadsUtil.mustBeSwingThread();
        if (Core.getProject().isProjectLoaded()) {
            this.parent.commitAndDeactivate();
        }
        this.autoSpellChecking = bl;
        if (Core.getProject().isProjectLoaded()) {
            this.parent.loadDocument();
            this.parent.activateEntry();
        }
    }
}

