/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.ParagraphView;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.undo.UndoManager;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.gui.editor.Document3;
import org.omegat.gui.editor.EditorController;
import org.omegat.gui.editor.EditorUtils;
import org.omegat.gui.editor.ViewLabel;
import org.omegat.util.Log;
import org.omegat.util.OConsts;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;
import org.omegat.util.gui.UIThreadsUtil;

public class EditorTextArea3
extends JEditorPane {
    protected final UndoManager undoManager = new UndoManager();
    protected final EditorController controller;
    protected String currentWord;
    protected MouseListener mouseListener = new MouseAdapter(){

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                EditorTextArea3.this.controller.goToSegmentAtLocation(EditorTextArea3.this.getCaretPosition());
            }
            if (mouseEvent.isPopupTrigger() || mouseEvent.getButton() == 3) {
                if (EditorTextArea3.this.createSpellCheckerPopUp(mouseEvent.getPoint())) {
                    return;
                }
                if (EditorTextArea3.this.createGoToSegmentPopUp(mouseEvent.getPoint())) {
                    return;
                }
            }
        }
    };
    public static ViewFactory factory3 = new ViewFactory(){

        public View create(Element element) {
            String string = element.getName();
            if (string != null) {
                if (string.equals("content")) {
                    return new ViewLabel(element);
                }
                if (string.equals("paragraph")) {
                    return new ParagraphView(element);
                }
                if (string.equals("section")) {
                    return new BoxView(element, 1);
                }
                if (string.equals("component")) {
                    return new ComponentView(element);
                }
                if (string.equals("icon")) {
                    return new IconView(element);
                }
            }
            return new ViewLabel(element);
        }
    };

    public EditorTextArea3(EditorController editorController) {
        this.controller = editorController;
        this.setEditorKit(new StyledEditorKit(){

            public ViewFactory getViewFactory() {
                return factory3;
            }
        });
        this.addMouseListener(this.mouseListener);
        this.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                try {
                    int n = Utilities.getWordStart(EditorTextArea3.this, caretEvent.getMark());
                    int n2 = Utilities.getWordEnd(EditorTextArea3.this, caretEvent.getMark());
                    String string = EditorTextArea3.this.getText(n, n2 - n);
                    if (!string.equals(EditorTextArea3.this.currentWord)) {
                        EditorTextArea3.this.currentWord = string;
                        CoreEvents.fireEditorNewWOrd(string);
                    }
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        });
    }

    public void cancelUndo() {
        this.undoManager.die();
    }

    public Document3 getOmDocument() {
        try {
            return (Document3)this.getDocument();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() != 401) {
            super.processKeyEvent(keyEvent);
            return;
        }
        boolean bl = false;
        boolean bl2 = StaticUtils.onMacOSX();
        Document3 document3 = this.getOmDocument();
        if (EditorTextArea3.isKey(keyEvent, 9, 0)) {
            if (this.controller.settings.isUseTabForAdvance()) {
                this.controller.nextEntry();
                bl = true;
            }
        } else if (EditorTextArea3.isKey(keyEvent, 9, 1)) {
            if (this.controller.settings.isUseTabForAdvance()) {
                this.controller.prevEntry();
                bl = true;
            }
        } else if (EditorTextArea3.isKey(keyEvent, 10, 0)) {
            if (!this.controller.settings.isUseTabForAdvance()) {
                this.controller.nextEntry();
                bl = true;
            } else {
                bl = true;
            }
        } else if (!bl2 && EditorTextArea3.isKey(keyEvent, 10, 2) || bl2 && EditorTextArea3.isKey(keyEvent, 10, 4)) {
            if (!this.controller.settings.isUseTabForAdvance()) {
                this.controller.prevEntry();
                bl = true;
            }
        } else if (EditorTextArea3.isKey(keyEvent, 10, 1)) {
            KeyEvent keyEvent2 = new KeyEvent(keyEvent.getComponent(), keyEvent.getID(), keyEvent.getWhen(), 0, 10, '\n');
            super.processKeyEvent(keyEvent2);
            bl = true;
        } else if (!bl2 && EditorTextArea3.isKey(keyEvent, 65, 2) || bl2 && EditorTextArea3.isKey(keyEvent, 65, 4)) {
            this.setSelectionStart(document3.getTranslationStart());
            this.setSelectionEnd(document3.getTranslationEnd());
            bl = true;
        } else if (EditorTextArea3.isKey(keyEvent, 79, 3)) {
            this.controller.toggleOrientation();
            bl = true;
        } else if (!bl2 && EditorTextArea3.isKey(keyEvent, 8, 2) || bl2 && EditorTextArea3.isKey(keyEvent, 8, 8)) {
            try {
                int n = this.getCaretPosition();
                int n2 = Utilities.getPreviousWord(this, n);
                int n3 = Math.max(n2, document3.getTranslationStart());
                this.setSelectionStart(n3);
                this.setSelectionEnd(n);
                this.replaceSelection("");
                bl = true;
            }
            catch (BadLocationException badLocationException) {}
        } else if (!bl2 && EditorTextArea3.isKey(keyEvent, 127, 2) || bl2 && EditorTextArea3.isKey(keyEvent, 127, 8)) {
            try {
                int n = this.getCaretPosition();
                int n4 = Utilities.getNextWord(this, n);
                int n5 = Math.min(n4, document3.getTranslationEnd());
                this.setSelectionStart(n);
                this.setSelectionEnd(n5);
                this.replaceSelection("");
                bl = true;
            }
            catch (BadLocationException badLocationException) {}
        } else if (!bl2 && EditorTextArea3.isKey(keyEvent, 33, 2) || bl2 && EditorTextArea3.isKey(keyEvent, 33, 4)) {
            this.setCaretPosition(0);
            bl = true;
        } else if (!bl2 && EditorTextArea3.isKey(keyEvent, 34, 2) || bl2 && EditorTextArea3.isKey(keyEvent, 34, 4)) {
            this.setCaretPosition(this.getOmDocument().getLength());
            bl = true;
        }
        if (bl) {
            keyEvent.consume();
        } else {
            if ((keyEvent.getModifiers() & 0xE) == 0 && keyEvent.getKeyCode() != 16) {
                this.checkAndFixCaret();
            }
            super.processKeyEvent(keyEvent);
        }
        this.controller.showLengthMessage();
        if (!bl && keyEvent.getKeyChar() != '\u0000') {
            switch (keyEvent.getKeyCode()) {
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    this.checkAndFixCaret();
                }
            }
        }
    }

    void checkAndFixCaret() {
        Document3 document3 = this.getOmDocument();
        if (document3 == null) {
            return;
        }
        if (!document3.isEditMode()) {
            return;
        }
        int n = this.getSelectionStart();
        int n2 = this.getSelectionEnd();
        int n3 = document3.getTranslationStart();
        int n4 = document3.getTranslationEnd();
        if (n != n2) {
            if (n < n3) {
                this.setSelectionStart(n3);
            } else if (n > n4) {
                this.setSelectionStart(n4);
            }
            if (n2 > n4) {
                this.setSelectionEnd(n4);
            } else if (n2 < n3) {
                this.setSelectionStart(n3);
            }
        } else if (n < n3) {
            this.setCaretPosition(n3);
        } else if (n > n4) {
            this.setCaretPosition(n4);
        }
    }

    private static boolean isKey(KeyEvent keyEvent, int n, int n2) {
        return keyEvent.getKeyCode() == n && keyEvent.getModifiers() == n2;
    }

    public void paste() {
        this.checkAndFixCaret();
        super.paste();
    }

    public void cut() {
        this.checkAndFixCaret();
        super.cut();
    }

    public String getSelectedText() {
        String string = super.getSelectedText();
        return string != null ? EditorUtils.removeDirectionChars(string) : null;
    }

    private boolean createGoToSegmentPopUp(Point point) {
        final int n = this.viewToModel(point);
        if (n >= this.getOmDocument().getTranslationStart() - OConsts.segmentStartStringFull.length() && n <= this.getOmDocument().getTranslationEnd() + OConsts.segmentStartStringFull.length()) {
            return false;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = jPopupMenu.add(OStrings.getString("MW_PROMPT_SEG_NR_TITLE"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditorTextArea3.this.setCaretPosition(n);
                EditorTextArea3.this.controller.goToSegmentAtLocation(EditorTextArea3.this.getCaretPosition());
            }
        });
        jPopupMenu.show(this, (int)point.getX(), (int)point.getY());
        return true;
    }

    protected boolean createSpellCheckerPopUp(Point point) {
        if (!this.controller.getSettings().isAutoSpellChecking()) {
            return false;
        }
        int n = this.viewToModel(point);
        if (n < this.getOmDocument().getTranslationStart() || n > this.getOmDocument().getTranslationEnd()) {
            return false;
        }
        try {
            final int n2 = Utilities.getWordStart(this, n);
            int n3 = Utilities.getWordEnd(this, n);
            final String string = EditorUtils.removeDirection(this.getText(n2, n3 - n2));
            final AbstractDocument abstractDocument = (AbstractDocument)this.getDocument();
            if (!Core.getSpellChecker().isCorrect(string)) {
                Object object;
                List<String> list = Core.getSpellChecker().suggest(string);
                JPopupMenu jPopupMenu = new JPopupMenu();
                for (final String string2 : list) {
                    JMenuItem jMenuItem = jPopupMenu.add(string2);
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                int n = EditorTextArea3.this.getCaretPosition();
                                abstractDocument.replace(n2, string.length(), string2, null);
                                EditorTextArea3.this.setCaretPosition(n);
                            }
                            catch (BadLocationException badLocationException) {
                                Log.log(badLocationException);
                            }
                        }
                    });
                }
                if (list.size() == 0) {
                    object = jPopupMenu.add(OStrings.getString("SC_NO_SUGGESTIONS"));
                    ((AbstractButton)object).addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                        }
                    });
                }
                jPopupMenu.add(new JSeparator());
                object = jPopupMenu.add(OStrings.getString("SC_IGNORE_ALL"));
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        EditorTextArea3.this.addIgnoreWord(string, n2, false);
                    }
                });
                object = jPopupMenu.add(OStrings.getString("SC_ADD_TO_DICTIONARY"));
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        EditorTextArea3.this.addIgnoreWord(string, n2, true);
                    }
                });
                jPopupMenu.show(this, (int)point.getX(), (int)point.getY());
            }
        }
        catch (BadLocationException badLocationException) {
            Log.log(badLocationException);
        }
        return true;
    }

    protected void addIgnoreWord(String string, int n, boolean bl) {
        UIThreadsUtil.mustBeSwingThread();
        if (bl) {
            Core.getSpellChecker().learnWord(string);
        } else {
            Core.getSpellChecker().ignoreWord(string);
        }
        this.controller.spellCheckerThread.resetCache();
        this.repaint();
    }
}

