/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.text.DecimalFormat;
import java.util.Locale;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.gui.editor.Document3;
import org.omegat.gui.editor.EditorController;
import org.omegat.gui.editor.EditorSettings;
import org.omegat.util.OConsts;
import org.omegat.util.Preferences;
import org.omegat.util.gui.Styles;
import org.omegat.util.gui.UIThreadsUtil;

public class SegmentBuilder {
    protected static final AttributeSet ATTR_SOURCE = Styles.GREEN;
    protected static final AttributeSet ATTR_SEGMENT_MARK = Styles.BOLD;
    protected static final AttributeSet ATTR_TRANS_TRANSLATED = Styles.TRANSLATED;
    protected static final AttributeSet ATTR_TRANS_UNTRANSLATED = Styles.UNTRANSLATED;
    protected static final AttributeSet ATTR_ACTIVE = new SimpleAttributeSet();
    public static final String SEGMENT_MARK_ATTRIBUTE = "SEGMENT_MARK_ATTRIBUTE";
    public static final String SEGMENT_SPELL_CHECK = "SEGMENT_SPELL_CHECK";
    private static final DecimalFormat NUMBER_FORMAT = new DecimalFormat("0000");
    final SourceTextEntry ste;
    final int segmentNumberInProject;
    private final Document3 doc;
    private final EditorController controller;
    private final EditorSettings settings;
    protected int activeTranslationBeginOffset;
    protected int activeTranslationEndOffset;
    protected Position beginPosP1;
    protected Position endPosM1;
    protected boolean spellPM;
    protected Position beginSpellCheckPM1;
    protected Position endSpellCheckPM1;
    protected int offset;

    public SegmentBuilder(EditorController editorController, Document3 document3, EditorSettings editorSettings, SourceTextEntry sourceTextEntry, int n) {
        this.controller = editorController;
        this.doc = document3;
        this.settings = editorSettings;
        this.ste = sourceTextEntry;
        this.segmentNumberInProject = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSegmentElement(boolean bl) {
        UIThreadsUtil.mustBeSwingThread();
        this.beginSpellCheckPM1 = null;
        this.endSpellCheckPM1 = null;
        this.doc.trustedChangesInProgress = true;
        try {
            try {
                int n;
                int n2;
                if (this.beginPosP1 != null && this.endPosM1 != null) {
                    n2 = this.beginPosP1.getOffset() - 1;
                    n = this.endPosM1.getOffset() + 1;
                    this.doc.remove(n2, n - n2);
                    this.offset = n2;
                } else {
                    this.offset = this.doc.getLength();
                }
                n2 = this.ste.getTranslation() != null && this.ste.getTranslation().length() > 0 ? 1 : 0;
                n = this.offset;
                if (bl) {
                    this.createActiveSegmentElement(n2 != 0);
                } else {
                    this.createInactiveSegmentElement(n2 != 0);
                }
                int n3 = this.offset;
                this.beginPosP1 = this.doc.createPosition(n + 1);
                this.endPosM1 = this.doc.createPosition(n3 - 1);
            }
            catch (BadLocationException badLocationException) {
                throw new RuntimeException(badLocationException);
            }
        }
        finally {
            this.doc.trustedChangesInProgress = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSegmentSeparator(Document3 document3) {
        document3.trustedChangesInProgress = true;
        try {
            try {
                document3.insertString(document3.getLength(), "\n", null);
            }
            catch (BadLocationException badLocationException) {
                throw new RuntimeException(badLocationException);
            }
        }
        finally {
            document3.trustedChangesInProgress = false;
        }
    }

    private void createActiveSegmentElement(boolean bl) throws BadLocationException {
        String string;
        this.addInactiveSegPart(true, this.ste.getSrcText(), ATTR_SOURCE);
        if (bl) {
            string = this.ste.getTranslation();
            if (this.settings.isAutoSpellChecking()) {
                this.doc.controller.spellCheckerThread.addForCheck(this.ste.getTranslation());
            }
        } else if (!Preferences.isPreference("wf_noSourceText")) {
            string = this.ste.getSrcText();
            if (this.settings.isAutoSpellChecking()) {
                this.doc.controller.spellCheckerThread.addForCheck(this.ste.getSrcText());
            }
        } else {
            string = "";
        }
        this.addActiveSegPart(string, ATTR_ACTIVE);
        if (this.settings.isAutoSpellChecking()) {
            this.beginSpellCheckPM1 = this.doc.createPosition(this.activeTranslationBeginOffset - 1);
            this.endSpellCheckPM1 = this.doc.createPosition(this.activeTranslationEndOffset + 1);
            this.spellPM = false;
        }
        this.doc.activeTranslationBeginM1 = this.doc.createPosition(this.activeTranslationBeginOffset - 1);
        this.doc.activeTranslationEndP1 = this.doc.createPosition(this.activeTranslationEndOffset + 1);
    }

    private void createInactiveSegmentElement(boolean bl) throws BadLocationException {
        if (this.settings.isDisplaySegmentSources()) {
            this.addInactiveSegPart(true, this.ste.getSrcText(), ATTR_SOURCE);
        }
        boolean bl2 = false;
        if (bl) {
            if (this.settings.isAutoSpellChecking()) {
                bl2 = true;
                this.doc.controller.spellCheckerThread.addForCheck(this.ste.getTranslation());
            }
            int n = this.offset;
            this.addInactiveSegPart(false, this.ste.getTranslation(), this.settings.getTranslatedAttributeSet());
            if (bl2) {
                this.beginSpellCheckPM1 = this.doc.createPosition(n + 2);
                this.endSpellCheckPM1 = this.doc.createPosition(this.offset - 2);
                this.spellPM = true;
            }
        } else if (!this.settings.isDisplaySegmentSources()) {
            this.addInactiveSegPart(true, this.ste.getSrcText(), this.settings.getUntranslatedAttributeSet());
        }
    }

    public int getStartPosition() {
        return this.beginPosP1.getOffset() - 1;
    }

    public int getEndPosition() {
        return this.endPosM1.getOffset() + 1;
    }

    private void setAttributes(int n, int n2, boolean bl) {
        boolean bl2 = false;
        switch (this.controller.currentOrientation) {
            case LTR: {
                bl2 = false;
                break;
            }
            case RTL: {
                bl2 = true;
                break;
            }
            case DIFFER: {
                bl2 = bl ? this.controller.sourceLangIsRTL : this.controller.targetLangIsRTL;
            }
        }
        this.doc.setAlignment(n, n2, bl2);
    }

    public boolean isInsideSegment(int n) {
        return this.beginPosP1.getOffset() - 1 <= n && n < this.endPosM1.getOffset() + 1;
    }

    public int getStartSpellPosition() {
        if (this.beginSpellCheckPM1 == null) {
            return 0;
        }
        int n = this.beginSpellCheckPM1.getOffset();
        n = this.spellPM ? --n : ++n;
        return n;
    }

    public int getEndSpellPosition() {
        if (this.endSpellCheckPM1 == null) {
            return 0;
        }
        int n = this.endSpellCheckPM1.getOffset();
        n = this.spellPM ? ++n : --n;
        return n;
    }

    private void addInactiveSegPart(boolean bl, String string, AttributeSet attributeSet) throws BadLocationException {
        int n = this.offset;
        boolean bl2 = bl ? this.controller.sourceLangIsRTL : this.controller.targetLangIsRTL;
        this.insert(bl2 ? "\u202b" : "\u202a", null);
        this.insert(string, attributeSet);
        this.insert("\u202c", null);
        this.insert("\n", null);
        this.setAttributes(n, this.offset, bl);
    }

    private void addActiveSegPart(String string, AttributeSet attributeSet) throws BadLocationException {
        int n = this.offset;
        boolean bl = this.controller.targetLangIsRTL;
        this.insert(this.createSegmentMarkText(true), ATTR_SEGMENT_MARK);
        this.insert(" ", null);
        this.insert(bl ? "\u202b" : "\u202a", null);
        this.activeTranslationBeginOffset = this.offset;
        this.insert(string, attributeSet);
        this.activeTranslationEndOffset = this.offset;
        this.insert("\u202c", null);
        this.insert(" ", null);
        this.insert(this.createSegmentMarkText(false), ATTR_SEGMENT_MARK);
        this.insert("\n", null);
        this.setAttributes(n, this.offset, false);
    }

    private void insert(String string, AttributeSet attributeSet) throws BadLocationException {
        this.doc.insertString(this.offset, string, attributeSet);
        this.offset += string.length();
    }

    private String createSegmentMarkText(boolean bl) {
        String string = bl ? OConsts.segmentStartString : OConsts.segmentEndString;
        String string2 = Locale.getDefault().getLanguage().toLowerCase();
        boolean bl2 = "some_RTL_language_code".equals(string2);
        if ((string = string.trim().replace(' ', '\u00a0')).indexOf("0000") >= 0) {
            string = string.replace("0000", NUMBER_FORMAT.format(this.segmentNumberInProject));
        }
        string = (bl2 ? (char)'\u202b' : '\u202a') + string + '\u202c';
        return string;
    }
}

