/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.omegat.core.Core;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.gui.glossary.GlossaryTextArea;
import org.omegat.util.DirectoryMonitor;
import org.omegat.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlossaryManager
implements DirectoryMonitor.Callback {
    private final String EXT_DEF_ENC = ".tab";
    private final String EXT_UTF8_ENC = ".utf8";
    protected DirectoryMonitor monitor;
    private final GlossaryTextArea pane;
    private final Map<String, List<GlossaryEntry>> glossaries = new TreeMap<String, List<GlossaryEntry>>();

    public GlossaryManager(GlossaryTextArea glossaryTextArea) {
        this.pane = glossaryTextArea;
    }

    public void start() {
        File file = new File(Core.getProject().getProjectProperties().getGlossaryRoot());
        this.monitor = new DirectoryMonitor(file, this);
        this.monitor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.monitor.fin();
        GlossaryManager glossaryManager = this;
        synchronized (glossaryManager) {
            this.glossaries.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileChanged(File file) {
        Object object = this;
        synchronized (object) {
            this.glossaries.remove(file.getName());
        }
        if (file.exists() && (((String)(object = file.getName().toLowerCase())).endsWith(".tab") || ((String)object).endsWith(".utf8"))) {
            Log.logRB("CT_LOADING_GLOSSARY", file.getName());
            try {
                List<GlossaryEntry> list = this.loadGlossaryFile(file);
                GlossaryManager glossaryManager = this;
                synchronized (glossaryManager) {
                    this.glossaries.put(file.getName(), list);
                }
            }
            catch (Exception exception) {
                Log.logRB("CT_ERROR_ACCESS_GLOSSARY_DIR", new Object[0]);
                Log.log(exception);
            }
        }
        this.pane.refresh();
    }

    private List<GlossaryEntry> loadGlossaryFile(File file) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        Closeable closeable;
        ArrayList<GlossaryEntry> arrayList = new ArrayList<GlossaryEntry>();
        String string = file.getName().toLowerCase();
        InputStreamReader inputStreamReader = null;
        if (string.endsWith(".tab")) {
            inputStreamReader = new InputStreamReader(new FileInputStream(file));
        } else if (string.endsWith(".utf8")) {
            closeable = new FileInputStream(file);
            inputStreamReader = new InputStreamReader((InputStream)closeable, "UTF-8");
        }
        closeable = new BufferedReader(inputStreamReader);
        ((BufferedReader)closeable).mark(1);
        int n = ((BufferedReader)closeable).read();
        if (n != 65279) {
            ((BufferedReader)closeable).reset();
        }
        String string2 = ((BufferedReader)closeable).readLine();
        while (string2 != null) {
            String[] stringArray;
            if (!string2.startsWith("#") && (stringArray = string2.split("\t")).length >= 2 && stringArray[0].length() != 0) {
                String string3 = "";
                if (stringArray.length >= 3) {
                    string3 = stringArray[2];
                }
                arrayList.add(new GlossaryEntry(stringArray[0], stringArray[1], string3));
            }
            string2 = ((BufferedReader)closeable).readLine();
        }
        ((BufferedReader)closeable).close();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GlossaryEntry> getGlossaryEntries() {
        ArrayList<GlossaryEntry> arrayList = new ArrayList<GlossaryEntry>();
        GlossaryManager glossaryManager = this;
        synchronized (glossaryManager) {
            for (List<GlossaryEntry> list : this.glossaries.values()) {
                arrayList.addAll(list);
            }
        }
        return arrayList;
    }
}

