/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Comparator;
import org.omegat.util.StaticUtils;

public class FileUtil {
    private static final int MAX_BACKUPS = 10;

    public static void removeOldBackups(final File file) {
        try {
            File[] fileArray = file.getParentFile().listFiles(new FileFilter(){

                public boolean accept(File file2) {
                    return !file2.isDirectory() && file2.getName().startsWith(file.getName()) && file2.getName().endsWith(".bak");
                }
            });
            if (fileArray != null && fileArray.length > 10) {
                Arrays.sort(fileArray, new Comparator<File>(){

                    @Override
                    public int compare(File file, File file2) {
                        return file2.getName().compareTo(file.getName());
                    }
                });
                for (int i = 10; i < fileArray.length; ++i) {
                    fileArray[i].delete();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeScriptFile(String string, String string2) {
        BufferedWriter bufferedWriter = null;
        try {
            string2 = StaticUtils.getScriptDir() + string2;
            string = string.replaceAll("\n", System.getProperty("line.separator"));
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string2), "UTF-8"));
            bufferedWriter.write(string);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

