/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.logging;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.logging.ErrorManager;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import org.omegat.util.StaticUtils;

public class OmegaTFileHandler
extends StreamHandler {
    private File lockFile;
    private FileOutputStream lockStream;
    private final long maxSize;
    private final int count;

    public OmegaTFileHandler() throws IOException {
        String string;
        LogManager logManager = LogManager.getLogManager();
        String string2 = this.getClass().getName();
        String string3 = logManager.getProperty(string2 + ".level");
        if (string3 != null) {
            this.setLevel(Level.parse(string3.trim()));
        }
        this.maxSize = (string = logManager.getProperty(string2 + ".size")) != null ? Long.parseLong(string) : 0x100000L;
        String string4 = logManager.getProperty(string2 + ".count");
        this.count = string4 != null ? Integer.parseInt(string4) : 10;
        this.openFiles(new File(StaticUtils.getConfigDir(), "logs"));
    }

    private void openFiles(File file) throws IOException {
        file.mkdirs();
        for (int i = 0; i < 100; ++i) {
            String string = "OmegaT" + (i > 0 ? "-" + i : "");
            this.lockFile = new File(file, string + ".log.lck");
            this.lockStream = new FileOutputStream(this.lockFile);
            if (this.lockStream.getChannel().tryLock() == null) continue;
            this.rotate(file, string);
            this.setOutputStream(new FileOutputStream(new File(file, string + ".log"), true));
            break;
        }
        this.setErrorManager(new ErrorManager());
    }

    public synchronized void close() throws SecurityException {
        try {
            this.lockStream.close();
            this.lockFile.delete();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void rotate(File file, final String string) {
        File file2 = new File(file, string + ".log");
        if (!file2.exists() || file2.length() < this.maxSize) {
            return;
        }
        String string2 = new SimpleDateFormat("yyyyMMdd.HHmm").format(new Date());
        File file3 = new File(file, string + '.' + string2 + ".log");
        file2.renameTo(file3);
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().startsWith(string + '.') && file.getName().endsWith(".log");
            }
        });
        if (fileArray != null) {
            Arrays.sort(fileArray, new Comparator<File>(){

                @Override
                public int compare(File file, File file2) {
                    return file2.getName().compareToIgnoreCase(file.getName());
                }
            });
            for (int i = this.count; i < fileArray.length; ++i) {
                fileArray[i].delete();
            }
        }
    }

    public synchronized void publish(LogRecord logRecord) {
        if (this.isLoggable(logRecord)) {
            super.publish(logRecord);
            this.flush();
        }
    }
}

