/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;

public class OmegaTLogFormatter
extends Formatter {
    protected static String lineMark;
    protected static String lineSeparator;
    private String logMask;
    private boolean isMaskContainsMark;
    private boolean isMaskContainsThreadName;
    private boolean isMaskContainsLevel;
    private boolean isMaskContainsText;
    private boolean isMaskContainsKey;
    private boolean isMaskContainsLoggerName;
    private boolean isMaskContainsTime;
    private String defaultTimeFormat = "HH:mm:ss";
    private ThreadLocal<SimpleDateFormat> timeFormatter = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat(OmegaTLogFormatter.this.defaultTimeFormat);
        }
    };

    public OmegaTLogFormatter() {
        String string;
        LogManager logManager = LogManager.getLogManager();
        String string2 = this.getClass().getName();
        this.logMask = logManager.getProperty(string2 + ".mask");
        if (this.logMask == null) {
            this.logMask = "$mark: $level: $text $key";
        }
        if ((string = logManager.getProperty(string2 + ".timeFormat")) != null) {
            this.defaultTimeFormat = string;
        }
        this.isMaskContainsKey = this.logMask.contains("$key");
        this.isMaskContainsLevel = this.logMask.contains("$level");
        this.isMaskContainsMark = this.logMask.contains("$mark");
        this.isMaskContainsTime = this.logMask.contains("$time");
        this.isMaskContainsText = this.logMask.contains("$text");
        this.isMaskContainsThreadName = this.logMask.contains("$threadName");
        this.isMaskContainsLoggerName = this.logMask.contains("$loggerName");
    }

    public String format(LogRecord logRecord) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = logRecord.getResourceBundle() != null ? logRecord.getResourceBundle().getString(logRecord.getMessage()) : logRecord.getMessage();
        String string2 = logRecord.getParameters() == null ? string : StaticUtils.format(string, logRecord.getParameters());
        String[] stringArray = string2.split("\r|\n");
        for (String string3 : stringArray) {
            this.appendFormattedLine(stringBuilder, logRecord, string3, false);
        }
        if (logRecord.getThrown() != null) {
            StringWriter stringWriter = new StringWriter();
            logRecord.getThrown().printStackTrace(new PrintWriter(stringWriter));
            for (String string4 : stringWriter.toString().split("\r|\n")) {
                this.appendFormattedLine(stringBuilder, logRecord, string4, true);
            }
        }
        return stringBuilder.toString();
    }

    protected void appendFormattedLine(StringBuilder stringBuilder, LogRecord logRecord, String string, boolean bl) {
        if (string.length() == 0) {
            return;
        }
        String string2 = this.logMask;
        if (this.isMaskContainsMark) {
            string2 = string2.replace("$mark", lineMark);
        }
        if (this.isMaskContainsTime) {
            string2 = string2.replace("$time", this.timeFormatter.get().format(new Date()));
        }
        if (this.isMaskContainsLoggerName) {
            string2 = string2.replace("$loggerName", logRecord.getLoggerName());
        }
        if (this.isMaskContainsThreadName) {
            string2 = string2.replace("$threadName", Thread.currentThread().getName());
        }
        if (this.isMaskContainsLevel) {
            string2 = string2.replace("$level", this.getLocalizedLevel(logRecord.getLevel()));
        }
        if (this.isMaskContainsText) {
            string2 = string2.replace("$text", string);
        }
        if (this.isMaskContainsKey) {
            string2 = logRecord.getResourceBundle() != null && !bl ? string2.replace("$key", "(" + logRecord.getMessage() + ")") : string2.replace("$key", "");
        }
        stringBuilder.append(string2).append(lineSeparator);
    }

    protected String getLocalizedLevel(Level level) {
        String string = Level.INFO.getName().equals(level.getName()) ? OStrings.getString("LOG_LEVEL_INFO") : (Level.SEVERE.getName().equals(level.getName()) ? OStrings.getString("LOG_LEVEL_SEVERE") : (Level.WARNING.getName().equals(level.getName()) ? OStrings.getString("LOG_LEVEL_WARNING") : level.getName()));
        return string.trim();
    }

    static {
        lineSeparator = System.getProperty("line.separator");
        Random random = new Random();
        random.setSeed(System.currentTimeMillis());
        int n = Math.abs(random.nextInt());
        String string = String.valueOf(n);
        if (string.length() > 5) {
            string = string.substring(0, 5);
        } else if (string.length() < 5) {
            for (int i = 5; i > string.length(); ++i) {
                string = "0" + string;
            }
        }
        lineMark = string;
    }
}

