/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core;

import java.util.Map;
import org.omegat.core.data.IProject;
import org.omegat.core.data.NotLoadedProject;
import org.omegat.core.matching.ITokenizer;
import org.omegat.core.matching.Tokenizer;
import org.omegat.core.segmentation.SRX;
import org.omegat.core.spellchecker.ISpellChecker;
import org.omegat.core.spellchecker.SpellChecker;
import org.omegat.core.threads.IAutoSave;
import org.omegat.core.threads.SaveThread;
import org.omegat.gui.dictionaries.DictionariesTextArea;
import org.omegat.gui.editor.EditorController;
import org.omegat.gui.editor.IEditor;
import org.omegat.gui.exttrans.GoogleTranslateTextArea;
import org.omegat.gui.glossary.GlossaryTextArea;
import org.omegat.gui.main.ConsoleWindow;
import org.omegat.gui.main.IMainWindow;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.matches.IMatcher;
import org.omegat.gui.matches.MatchesTextArea;
import org.omegat.gui.tagvalidation.ITagValidation;
import org.omegat.gui.tagvalidation.TagValidationTool;
import org.omegat.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Core {
    private static IProject currentProject;
    private static IMainWindow mainWindow;
    private static IEditor editor;
    private static ITagValidation tagValidation;
    private static IMatcher matcher;
    private static ITokenizer tokenizer;
    private static ISpellChecker spellChecker;
    private static IAutoSave saveThread;
    private static GlossaryTextArea glossary;
    private static GoogleTranslateTextArea googleTranslatePane;
    private static DictionariesTextArea dictionaries;

    public static IProject getProject() {
        return currentProject;
    }

    public static void setProject(IProject iProject) {
        currentProject = iProject;
    }

    public static IMainWindow getMainWindow() {
        return mainWindow;
    }

    public static IEditor getEditor() {
        return editor;
    }

    public static ITagValidation getTagValidation() {
        return tagValidation;
    }

    public static IMatcher getMatcher() {
        return matcher;
    }

    public static ITokenizer getTokenizer() {
        return tokenizer;
    }

    public static ISpellChecker getSpellChecker() {
        return spellChecker;
    }

    public static GoogleTranslateTextArea getGoogleTranslatePane() {
        return googleTranslatePane;
    }

    public static IAutoSave getAutoSave() {
        return saveThread;
    }

    public static void initializeGUI(Map<String, String> map) throws Exception {
        currentProject = new NotLoadedProject();
        MainWindow mainWindow = new MainWindow();
        Core.mainWindow = mainWindow;
        editor = new EditorController(mainWindow);
        tagValidation = new TagValidationTool(mainWindow);
        matcher = new MatchesTextArea(mainWindow);
        glossary = new GlossaryTextArea();
        googleTranslatePane = new GoogleTranslateTextArea();
        dictionaries = new DictionariesTextArea();
        tokenizer = Core.createComponent(ITokenizer.class, new Tokenizer(), map);
        spellChecker = new SpellChecker();
        SaveThread saveThread = new SaveThread();
        Core.saveThread = saveThread;
        saveThread.start();
        SRX.getSRX();
    }

    public static void initializeConsole(Map<String, String> map) throws Exception {
        currentProject = new NotLoadedProject();
        mainWindow = new ConsoleWindow();
        tokenizer = Core.createComponent(ITokenizer.class, new Tokenizer(), map);
        SRX.getSRX();
    }

    protected static <T> T createComponent(Class<T> clazz, T t, Map<String, String> map) {
        try {
            String string = map.get(clazz.getSimpleName());
            if (string != null) {
                return (T)Class.forName(string).newInstance();
            }
        }
        catch (Exception exception) {
            Log.log(exception);
        }
        return t;
    }

    protected static void setMainWindow(IMainWindow iMainWindow) {
        mainWindow = iMainWindow;
    }

    protected static void setCurrentProject(IProject iProject) {
        currentProject = iProject;
    }
}

