/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.NotLoadedProject;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.RealProject;
import org.omegat.core.events.IProjectEventListener;

public class ProjectFactory {
    public static void createNotLoadedProject() {
        Core.setProject(new NotLoadedProject());
    }

    public static void createProject(ProjectProperties projectProperties) {
        Core.setProject(new RealProject(projectProperties, true));
        Core.getAutoSave().enable();
        CoreEvents.fireProjectChange(IProjectEventListener.PROJECT_CHANGE_TYPE.CREATE);
    }

    public static void loadProject(ProjectProperties projectProperties) {
        Core.getAutoSave().disable();
        Core.setProject(new RealProject(projectProperties, false));
        Core.getAutoSave().enable();
        CoreEvents.fireProjectChange(IProjectEventListener.PROJECT_CHANGE_TYPE.LOAD);
    }

    public static void closeProject() {
        Core.getAutoSave().disable();
        Core.getProject().closeProject();
        Core.setProject(new NotLoadedProject());
        CoreEvents.fireProjectChange(IProjectEventListener.PROJECT_CHANGE_TYPE.CLOSE);
    }
}

