/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import java.io.File;
import org.omegat.util.Language;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;

public class ProjectProperties {
    private String projectName;
    private String projectRoot;
    private String sourceRoot;
    private String targetRoot;
    private String glossaryRoot;
    private String tmRoot;
    private String dictRoot;
    private Language sourceLanguage;
    private Language targetLanguage;
    private boolean sentenceSegmentingOn;

    public ProjectProperties(File file) {
        this.setProjectName(file.getName());
        this.setProjectRoot(file.getAbsolutePath() + File.separator);
        this.setSourceRoot(this.projectRoot + "source" + File.separator);
        this.setTargetRoot(this.projectRoot + "target" + File.separator);
        this.setGlossaryRoot(this.projectRoot + "glossary" + File.separator);
        this.setTMRoot(this.projectRoot + "tm" + File.separator);
        this.setDictRoot(this.projectRoot + "dictionary" + File.separator);
        this.setSentenceSegmentingEnabled(true);
        String string = Preferences.getPreference("source_lang");
        if (!StringUtil.isEmpty(string)) {
            this.setSourceLanguage(string);
        } else {
            this.setSourceLanguage("EN-US");
        }
        String string2 = Preferences.getPreference("target_lang");
        if (!StringUtil.isEmpty(string2)) {
            this.setTargetLanguage(string2);
        } else {
            this.setTargetLanguage("EN-GB");
        }
    }

    public String getTargetRoot() {
        return this.targetRoot;
    }

    public void setTargetRoot(String string) {
        this.targetRoot = string;
    }

    public String getGlossaryRoot() {
        return this.glossaryRoot;
    }

    public void setGlossaryRoot(String string) {
        this.glossaryRoot = string;
    }

    public String getTMRoot() {
        return this.tmRoot;
    }

    public void setTMRoot(String string) {
        this.tmRoot = string;
    }

    public String getDictRoot() {
        return this.dictRoot;
    }

    public void setDictRoot(String string) {
        this.dictRoot = string;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String string) {
        this.projectName = string;
    }

    public String getProjectRoot() {
        return this.projectRoot;
    }

    public void setProjectRoot(String string) {
        this.projectRoot = string;
    }

    public String getProjectInternal() {
        return this.projectRoot + "omegat" + File.separator;
    }

    public String getSourceRoot() {
        return this.sourceRoot;
    }

    public void setSourceRoot(String string) {
        this.sourceRoot = string;
    }

    public Language getSourceLanguage() {
        return this.sourceLanguage;
    }

    public void setSourceLanguage(Language language) {
        this.sourceLanguage = language;
    }

    public void setSourceLanguage(String string) {
        this.sourceLanguage = new Language(string);
    }

    public Language getTargetLanguage() {
        return this.targetLanguage;
    }

    public void setTargetLanguage(Language language) {
        this.targetLanguage = language;
    }

    public void setTargetLanguage(String string) {
        this.targetLanguage = new Language(string);
    }

    public boolean isSentenceSegmentingEnabled() {
        return this.sentenceSegmentingOn;
    }

    public void setSentenceSegmentingEnabled(boolean bl) {
        this.sentenceSegmentingOn = bl;
    }

    public boolean verifyProject() {
        File file = new File(this.getSourceRoot());
        File file2 = new File(this.getTargetRoot());
        File file3 = new File(this.getGlossaryRoot());
        File file4 = new File(this.getTMRoot());
        File file5 = new File(this.getDictRoot());
        if (!file5.exists() && this.getDictRoot().equals(this.projectRoot + "dictionary" + File.separator)) {
            file5.mkdirs();
        }
        return file.exists() && file2.exists() && file3.exists() && file4.exists();
    }

    private static boolean verifyLangCode(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isLetter(string.charAt(i))) continue;
            return false;
        }
        return new Language(string).getDisplayName().length() > 0;
    }

    public static boolean verifySingleLangCode(String string) {
        if (string.length() == 2 || string.length() == 3) {
            return ProjectProperties.verifyLangCode(string);
        }
        if (string.length() == 5 || string.length() == 6) {
            int n = 0;
            if (string.length() == 6) {
                n = 1;
            }
            return ProjectProperties.verifyLangCode(string.substring(0, 2 + n)) && (string.charAt(2 + n) == '-' || string.charAt(2 + n) == '_') && ProjectProperties.verifyLangCode(string.substring(3 + n, 5 + n));
        }
        return false;
    }
}

