/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.IProject;
import org.omegat.core.data.LegacyTM;
import org.omegat.core.data.ParseEntry;
import org.omegat.core.data.ProjectFileData;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.StringEntry;
import org.omegat.core.data.TransMemory;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.statistics.CalcStandardStatistics;
import org.omegat.core.statistics.Statistics;
import org.omegat.core.statistics.StatisticsInfo;
import org.omegat.filters2.IParseCallback;
import org.omegat.filters2.TranslationException;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.util.FileUtil;
import org.omegat.util.LFileCopy;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.ProjectFileStorage;
import org.omegat.util.RuntimePreferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.TMXReader;
import org.omegat.util.TMXWriter;
import org.omegat.util.gui.UIThreadsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RealProject
implements IProject {
    private static final Logger LOGGER = Logger.getLogger(RealProject.class.getName());
    private ProjectProperties m_config;
    private boolean m_modifiedFlag;
    private Map<String, StringEntry> m_strEntryHash = new HashMap<String, StringEntry>(4096);
    private List<StringEntry> m_strEntryList = new ArrayList<StringEntry>();
    private List<SourceTextEntry> m_srcTextEntryArray = new ArrayList<SourceTextEntry>(4096);
    private List<LegacyTM> m_legacyTMs;
    private List<TransMemory> m_tmList = new ArrayList<TransMemory>();
    private List<TransMemory> m_orphanedList;
    private List<IProject.FileInfo> projectFilesList;
    private int numberofTranslatedSegments;

    public RealProject(ProjectProperties projectProperties, boolean bl) {
        this.m_legacyTMs = new ArrayList<LegacyTM>();
        this.m_orphanedList = new ArrayList<TransMemory>();
        if (bl) {
            this.createProject(projectProperties);
        }
        this.loadProject(projectProperties);
        this.m_srcTextEntryArray = Collections.unmodifiableList(this.m_srcTextEntryArray);
        this.m_legacyTMs = Collections.unmodifiableList(this.m_legacyTMs);
        this.m_tmList = Collections.unmodifiableList(this.m_tmList);
        this.m_orphanedList = Collections.unmodifiableList(this.m_orphanedList);
        this.m_strEntryList = Collections.unmodifiableList(this.m_strEntryList);
        this.m_strEntryHash = Collections.unmodifiableMap(this.m_strEntryHash);
    }

    @Override
    public void saveProjectProperties() throws IOException {
        ProjectFileStorage.writeProjectFile(this.m_config);
        Preferences.setPreference("source_lang", this.m_config.getSourceLanguage().toString());
        Preferences.setPreference("target_lang", this.m_config.getTargetLanguage().toString());
    }

    private void loadProject(ProjectProperties projectProperties) {
        LOGGER.info(OStrings.getString("LOG_DATAENGINE_LOAD_START"));
        UIThreadsUtil.mustNotBeSwingThread();
        try {
            Preferences.setPreference("current_folder", new File(projectProperties.getProjectRoot()).getParentFile().getAbsolutePath());
            Preferences.save();
            this.m_config = projectProperties;
            Core.getMainWindow().showStatusMessageRB("CT_LOADING_PROJECT", new Object[0]);
            this.loadSourceFiles();
            this.loadTranslations();
            try {
                this.loadTM();
            }
            catch (IOException iOException) {
                Log.logErrorRB(iOException, "TF_TM_LOAD_ERROR", new Object[0]);
                Core.getMainWindow().displayErrorRB(iOException, "TF_TM_LOAD_ERROR", new Object[0]);
            }
            String string = CalcStandardStatistics.buildProjectStats(this.m_strEntryList, this.m_srcTextEntryArray, this.m_config, this.numberofTranslatedSegments);
            String string2 = this.getProjectProperties().getProjectInternal() + "project_stats.txt";
            Statistics.writeStat(string2, string);
            Core.getMainWindow().showStatusMessageRB(null, new Object[0]);
            this.m_modifiedFlag = false;
        }
        catch (Exception exception) {
            Log.logErrorRB(exception, "TF_LOAD_ERROR", new Object[0]);
            Core.getMainWindow().displayErrorRB(exception, "TF_LOAD_ERROR", new Object[0]);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.m_strEntryHash.clear();
            this.m_strEntryList.clear();
            this.m_srcTextEntryArray.clear();
            this.m_legacyTMs.clear();
            this.m_tmList.clear();
            this.m_orphanedList.clear();
            System.gc();
            Log.logErrorRB("OUT_OF_MEMORY", new Object[0]);
            Log.log(outOfMemoryError);
            Core.getMainWindow().showErrorDialogRB(OStrings.getString("OUT_OF_MEMORY"), OStrings.getString("TF_ERROR"));
            System.exit(0);
        }
        LOGGER.info(OStrings.getString("LOG_DATAENGINE_LOAD_END"));
    }

    @Override
    public boolean isProjectLoaded() {
        return true;
    }

    @Override
    public StatisticsInfo getStatistics() {
        StatisticsInfo statisticsInfo = new StatisticsInfo();
        statisticsInfo.numberOfUniqueSegments = this.m_strEntryList.size();
        statisticsInfo.numberofTranslatedSegments = this.numberofTranslatedSegments;
        statisticsInfo.numberOfSegmentsTotal = this.m_srcTextEntryArray.size();
        return statisticsInfo;
    }

    @Override
    public void closeProject() {
        LOGGER.info(OStrings.getString("LOG_DATAENGINE_CLOSE"));
    }

    @Override
    public void compileProject() throws IOException, TranslationException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        LOGGER.info(OStrings.getString("LOG_DATAENGINE_COMPILE_START"));
        UIThreadsUtil.mustNotBeSwingThread();
        try {
            object6 = RuntimePreferences.getPseudoTranslateTMXFile();
            object5 = RuntimePreferences.getPseudoTranslateType();
            object4 = this.m_config.getProjectRoot() + this.m_config.getProjectName() + "-omegat" + ".tmx";
            TMXWriter.buildTMXFile((String)object4, false, false, false, this.m_config, this.m_strEntryList, this.m_orphanedList, false, (RuntimePreferences.PSEUDO_TRANSLATE_TYPE)((Object)object5));
            object4 = this.m_config.getProjectRoot() + this.m_config.getProjectName() + "-level1" + ".tmx";
            TMXWriter.buildTMXFile((String)object4, true, false, false, this.m_config, this.m_strEntryList, this.m_orphanedList, false, (RuntimePreferences.PSEUDO_TRANSLATE_TYPE)((Object)object5));
            object4 = this.m_config.getProjectRoot() + this.m_config.getProjectName() + "-level2" + ".tmx";
            TMXWriter.buildTMXFile((String)object4, false, false, true, this.m_config, this.m_strEntryList, this.m_orphanedList, false, (RuntimePreferences.PSEUDO_TRANSLATE_TYPE)((Object)object5));
            if (object6 != null && ((String)object6).length() > 0) {
                object4 = !((String)object6).endsWith(".tmx") ? (String)object6 + "." + ".tmx" : object6;
                TMXWriter.buildTMXFile((String)object4, false, false, true, this.m_config, this.m_strEntryList, this.m_orphanedList, true, (RuntimePreferences.PSEUDO_TRANSLATE_TYPE)((Object)object5));
            }
        }
        catch (IOException iOException) {
            Log.logErrorRB("CT_ERROR_CREATING_TMX", new Object[0]);
            Log.log(iOException);
            throw new IOException(OStrings.getString("CT_ERROR_CREATING_TMX") + "\n" + iOException.getMessage());
        }
        object6 = new ArrayList(256);
        object5 = this.m_config.getSourceRoot();
        object4 = this.m_config.getTargetRoot();
        StaticUtils.buildDirList((List<String>)object6, new File((String)object5));
        Object object7 = object6.iterator();
        while (object7.hasNext()) {
            object3 = (String)object7.next();
            object2 = (String)object4 + ((String)object3).substring(((String)object5).length());
            object = new File((String)object2);
            if (((File)object).exists() || ((File)object).mkdir()) continue;
            throw new IOException(OStrings.getString("CT_ERROR_CREATING_TARGET_DIR") + (String)object2);
        }
        object7 = FilterMaster.getInstance();
        object6.clear();
        StaticUtils.buildFileList((List<String>)object6, new File((String)object5), true);
        object3 = new HashSet();
        object2 = new TranslateFilesCallback();
        object = object6.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            File file = new File(string);
            if (object3.contains(file)) continue;
            String string2 = string.substring(((String)object5).length());
            Core.getMainWindow().showStatusMessageRB("CT_COMPILE_FILE_MX", string2);
            ((FilterMaster)object7).translateFile((String)object5, string2, (String)object4, (Set<File>)object3, (IParseCallback)object2);
        }
        Core.getMainWindow().showStatusMessageRB("CT_COMPILE_DONE_MX", new Object[0]);
        CoreEvents.fireProjectChange(IProjectEventListener.PROJECT_CHANGE_TYPE.COMPILE);
        LOGGER.info(OStrings.getString("LOG_DATAENGINE_COMPILE_END"));
    }

    @Override
    public void saveProject() {
        if (this.isProjectModified()) {
            this.forceSave(false);
        } else {
            LOGGER.info(OStrings.getString("LOG_DATAENGINE_SAVE_NONEED"));
        }
    }

    private void forceSave(boolean bl) {
        Object object;
        Object object2;
        String string;
        block6: {
            LOGGER.info(OStrings.getString("LOG_DATAENGINE_SAVE_START"));
            UIThreadsUtil.mustNotBeSwingThread();
            Core.getAutoSave().disable();
            Preferences.save();
            string = this.m_config.getProjectInternal() + "project_save.tmx";
            if (bl) {
                string = string + ".recover";
            } else {
                object2 = new File(string + ".backup");
                object = new File(string);
                if (((File)object).exists()) {
                    ((File)object).renameTo((File)object2);
                }
            }
            try {
                this.saveProjectProperties();
                TMXWriter.buildTMXFile(string, false, true, false, this.m_config, this.m_strEntryList, this.m_orphanedList, false, RuntimePreferences.PSEUDO_TRANSLATE_TYPE.EQUAL);
                this.m_modifiedFlag = false;
            }
            catch (IOException iOException) {
                Log.logErrorRB(iOException, "CT_ERROR_SAVING_PROJ", new Object[0]);
                Core.getMainWindow().displayErrorRB(iOException, "CT_ERROR_SAVING_PROJ", new Object[0]);
                if (bl) break block6;
                string = this.m_config.getProjectInternal() + "project_save.tmx";
                object = new File(string + ".backup");
                File file = new File(string);
                if (!((File)object).exists()) break block6;
                ((File)object).renameTo(file);
            }
        }
        if (!this.m_modifiedFlag && !bl && ((File)(object2 = new File((string = this.m_config.getProjectInternal() + "project_save.tmx") + ".backup"))).exists()) {
            ((File)object2).delete();
        }
        object2 = CalcStandardStatistics.buildProjectStats(this.m_strEntryList, this.m_srcTextEntryArray, this.m_config, this.numberofTranslatedSegments);
        object = this.getProjectProperties().getProjectInternal() + "project_stats.txt";
        Statistics.writeStat((String)object, (String)object2);
        CoreEvents.fireProjectChange(IProjectEventListener.PROJECT_CHANGE_TYPE.SAVE);
        Core.getAutoSave().enable();
        LOGGER.info(OStrings.getString("LOG_DATAENGINE_SAVE_END"));
    }

    private void createProject(ProjectProperties projectProperties) {
        LOGGER.info(OStrings.getString("LOG_DATAENGINE_CREATE_START"));
        UIThreadsUtil.mustNotBeSwingThread();
        this.m_config = projectProperties;
        try {
            this.createDirectory(this.m_config.getProjectRoot(), null);
            this.createDirectory(this.m_config.getProjectInternal(), null);
            this.createDirectory(this.m_config.getSourceRoot(), "src");
            this.createDirectory(this.m_config.getGlossaryRoot(), "glos");
            this.createDirectory(this.m_config.getTMRoot(), "tm");
            this.createDirectory(this.m_config.getDictRoot(), "dictionary");
            this.createDirectory(this.m_config.getTargetRoot(), "target");
            this.saveProjectProperties();
        }
        catch (IOException iOException) {
            Log.logErrorRB(iOException, "CT_ERROR_CREATING_PROJECT", new Object[0]);
            Core.getMainWindow().displayErrorRB(iOException, "CT_ERROR_CREATING_PROJECT", new Object[0]);
        }
        LOGGER.info(OStrings.getString("LOG_DATAENGINE_CREATE_END"));
    }

    private void createDirectory(String string, String string2) throws IOException {
        File file = new File(string);
        if (!file.isDirectory() && !file.mkdirs()) {
            StringBuilder stringBuilder = new StringBuilder(OStrings.getString("CT_ERROR_CREATE"));
            if (string2 != null) {
                stringBuilder.append("\n(.../").append(string2).append("/)");
            }
            throw new IOException(stringBuilder.toString());
        }
    }

    private void loadTranslations() {
        File file = new File(this.m_config.getProjectInternal() + "project_save.tmx");
        try {
            if (!file.exists()) {
                Log.logErrorRB("CT_ERROR_CANNOT_FIND_TMX", file.getAbsolutePath());
                return;
            }
        }
        catch (SecurityException securityException) {
            Log.logErrorRB(securityException, "CT_ERROR_ACCESS_PROJECT_FILE", new Object[0]);
            Core.getMainWindow().displayErrorRB(securityException, "CT_ERROR_ACCESS_PROJECT_FILE", new Object[0]);
            return;
        }
        try {
            Core.getMainWindow().showStatusMessageRB("CT_LOAD_TMX", new Object[0]);
            this.loadTMXFile(file.getAbsolutePath(), "UTF-8", true);
        }
        catch (IOException iOException) {
            Log.logErrorRB(iOException, "CT_ERROR_LOADING_PROJECT_FILE", new Object[0]);
            Core.getMainWindow().displayErrorRB(iOException, "CT_ERROR_LOADING_PROJECT_FILE", new Object[0]);
        }
    }

    private void loadSourceFiles() throws IOException, InterruptedIOException, TranslationException {
        FilterMaster filterMaster = FilterMaster.getInstance();
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(this.m_config.getSourceRoot());
        StaticUtils.buildFileList(arrayList, file, true);
        HashSet<File> hashSet = new HashSet<File>();
        ArrayList<IProject.FileInfo> arrayList2 = new ArrayList<IProject.FileInfo>();
        int n = 0;
        for (String string : arrayList) {
            File file2 = new File(string);
            if (hashSet.contains(file2)) continue;
            String string2 = string.substring(this.m_config.getSourceRoot().length());
            Core.getMainWindow().showStatusMessageRB("CT_LOAD_FILE_MX", string2);
            LoadFilesCallback loadFilesCallback = new LoadFilesCallback();
            ProjectFileData projectFileData = new ProjectFileData();
            projectFileData.name = string;
            projectFileData.firstEntry = this.m_srcTextEntryArray.size();
            loadFilesCallback.setCurrentFile(projectFileData);
            boolean bl = filterMaster.loadFile(string, hashSet, loadFilesCallback);
            projectFileData.lastEntry = this.m_srcTextEntryArray.size() - 1;
            if (!bl || projectFileData.lastEntry < projectFileData.firstEntry) continue;
            IProject.FileInfo fileInfo = new IProject.FileInfo();
            fileInfo.filePath = string2;
            fileInfo.firstEntryIndex = this.m_srcTextEntryArray.size();
            fileInfo.firstEntryIndexInGlobalList = n;
            fileInfo.size = this.m_srcTextEntryArray.size() - n;
            arrayList2.add(fileInfo);
            n = this.m_srcTextEntryArray.size();
        }
        this.projectFilesList = Collections.unmodifiableList(arrayList2);
        Core.getMainWindow().showStatusMessageRB("CT_LOAD_SRC_COMPLETE", new Object[0]);
    }

    private void loadTM() throws IOException {
        String[] stringArray;
        File file = new File(this.m_config.getTMRoot());
        for (String string : stringArray = file.list()) {
            String string2 = string;
            int n = string2.lastIndexOf(46);
            if (n < 0) {
                n = string2.length();
            }
            String string3 = string2.substring(n);
            string2 = this.m_config.getTMRoot();
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            string2 = string2 + string;
            if (string3.equalsIgnoreCase(".tmx")) {
                this.loadTMXFile(string2, "UTF-8", false);
                continue;
            }
            if (!string3.equalsIgnoreCase(".wf")) continue;
            this.loadTMXFile(string2, "ISO-8859-1", false);
        }
    }

    private void loadTMXFile(String string, String string2, boolean bl) throws IOException {
        Object object;
        TMXReader tMXReader = new TMXReader(string2, this.m_config.getSourceLanguage(), this.m_config.getTargetLanguage(), this.m_config.isSentenceSegmentingEnabled());
        LFileCopy.copy(string, string + ".tmp");
        tMXReader.loadFile(string + ".tmp", bl);
        new File(string + ".tmp").delete();
        int n = tMXReader.numSegments();
        ArrayList<StringEntry> arrayList = new ArrayList<StringEntry>(n);
        ArrayList<StringEntry> arrayList2 = null;
        if (bl) {
            object = new File(string);
            long l = ((File)object).lastModified();
            if (l == 0L) {
                l = new Date().getTime();
            }
            LFileCopy.copy(string, string + "." + RealProject.millisToDateTime(l) + ".bak");
            FileUtil.removeOldBackups((File)object);
        }
        if (bl) {
            arrayList2 = new ArrayList<StringEntry>();
            object = new LegacyTM(OStrings.getString("CT_ORPHAN_STRINGS"), arrayList2);
            this.m_legacyTMs.add((LegacyTM)object);
        } else {
            object = new LegacyTM(new File(string).getName(), arrayList);
            this.m_legacyTMs.add((LegacyTM)object);
        }
        for (int i = 0; i < n; ++i) {
            StringEntry stringEntry;
            String string3 = tMXReader.getSourceSegment(i);
            String string4 = tMXReader.getTargetSegment(i);
            if (bl) {
                stringEntry = this.m_strEntryHash.get(string3);
                if (stringEntry == null) {
                    TransMemory transMemory = new TransMemory(string3, string4, string);
                    this.m_orphanedList.add(transMemory);
                    this.m_tmList.add(transMemory);
                    stringEntry = new StringEntry(string3);
                    stringEntry.setTranslation(string4);
                    arrayList2.add(stringEntry);
                    continue;
                }
                this.numberofTranslatedSegments += stringEntry.setTranslation(string4);
                continue;
            }
            this.m_tmList.add(new TransMemory(string3, string4, string));
            stringEntry = new StringEntry(string3);
            stringEntry.setTranslation(string4);
            arrayList.add(stringEntry);
        }
    }

    private static String millisToDateTime(long l) {
        return new SimpleDateFormat("yyyyMMddHHmm").format(new Date());
    }

    @Override
    public List<SourceTextEntry> getAllEntries() {
        return this.m_srcTextEntryArray;
    }

    @Override
    public List<TransMemory> getTransMemory() {
        return this.m_tmList;
    }

    @Override
    public ProjectProperties getProjectProperties() {
        return this.m_config;
    }

    @Override
    public boolean isProjectModified() {
        return this.m_modifiedFlag;
    }

    @Override
    public List<StringEntry> getUniqueEntries() {
        return Collections.unmodifiableList(new ArrayList<StringEntry>(this.m_strEntryList));
    }

    @Override
    public void setTranslation(SourceTextEntry sourceTextEntry, String string) {
        this.numberofTranslatedSegments += sourceTextEntry.setTranslation(string);
        this.m_modifiedFlag = true;
    }

    @Override
    public List<LegacyTM> getMemory() {
        return this.m_legacyTMs;
    }

    @Override
    public List<IProject.FileInfo> getProjectFiles() {
        return this.projectFilesList;
    }

    private class TranslateFilesCallback
    extends ParseEntry {
        public TranslateFilesCallback() {
            super(RealProject.this.m_config);
        }

        protected String processSingleEntry(String string) {
            StringEntry stringEntry = (StringEntry)RealProject.this.m_strEntryHash.get(string);
            if (stringEntry == null) {
                return string;
            }
            String string2 = stringEntry.getTranslation();
            if (string2 == null || string2.length() == 0) {
                string2 = string;
            }
            return string2;
        }

        public void addLegacyTMXEntry(String string, String string2) {
        }
    }

    private class LoadFilesCallback
    extends ParseEntry {
        private ProjectFileData m_curFile;
        private LegacyTM legacyFileTM;

        public LoadFilesCallback() {
            super(RealProject.this.m_config);
        }

        protected void setCurrentFile(ProjectFileData projectFileData) {
            this.m_curFile = projectFileData;
            this.legacyFileTM = null;
        }

        protected String processSingleEntry(String string) {
            StringEntry stringEntry = (StringEntry)RealProject.this.m_strEntryHash.get(string);
            this.addEntry(string);
            if (stringEntry == null) {
                return string;
            }
            String string2 = stringEntry.getTranslation();
            if (string2 == null || string2.length() == 0) {
                string2 = string;
            }
            return string2;
        }

        private void addEntry(String string) {
            if (string.length() == 0 || string.trim().length() == 0) {
                return;
            }
            StringEntry stringEntry = (StringEntry)RealProject.this.m_strEntryHash.get(string);
            if (stringEntry == null) {
                stringEntry = new StringEntry(string);
                RealProject.this.m_strEntryList.add(stringEntry);
                RealProject.this.m_strEntryHash.put(string, stringEntry);
            }
            SourceTextEntry sourceTextEntry = new SourceTextEntry(stringEntry, this.m_curFile, RealProject.this.m_srcTextEntryArray.size());
            RealProject.this.m_srcTextEntryArray.add(sourceTextEntry);
        }

        protected void addSegment(String string, int n, String string2, String string3, String string4) {
            if (string2.length() == 0 || string2.trim().length() == 0) {
                return;
            }
            StringEntry stringEntry = (StringEntry)RealProject.this.m_strEntryHash.get(string2);
            if (stringEntry == null) {
                stringEntry = new StringEntry(string2);
                stringEntry.setTranslation(string3);
                RealProject.this.m_strEntryList.add(stringEntry);
                RealProject.this.m_strEntryHash.put(string2, stringEntry);
            }
            SourceTextEntry sourceTextEntry = new SourceTextEntry(stringEntry, this.m_curFile, RealProject.this.m_srcTextEntryArray.size());
            RealProject.this.m_srcTextEntryArray.add(sourceTextEntry);
        }

        public String getTranslation(String string, String string2) {
            StringEntry stringEntry = (StringEntry)RealProject.this.m_strEntryHash.get(string2);
            if (stringEntry == null) {
                return string2;
            }
            String string3 = stringEntry.getTranslation();
            if (string3 == null || string3.length() == 0) {
                string3 = string2;
            }
            return string3;
        }

        public void addLegacyTMXEntry(String string, String string2) {
            Object object;
            if (this.legacyFileTM == null) {
                object = StaticUtils.makeFilenameRelative(this.m_curFile.name, RealProject.this.m_config.getSourceRoot());
                this.legacyFileTM = new LegacyTM((String)object, new ArrayList<StringEntry>());
                RealProject.this.getMemory().add(this.legacyFileTM);
            }
            object = new StringEntry(string);
            ((StringEntry)object).setTranslation(string2);
            this.legacyFileTM.getStrings().add((StringEntry)object);
        }
    }
}

