/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.spellchecker;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.dts.spell.dictionary.OpenOfficeSpellDictionary;
import org.dts.spell.dictionary.SpellDictionary;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.spellchecker.Hunspell;
import org.omegat.core.spellchecker.ISpellChecker;
import org.omegat.util.Log;
import org.omegat.util.Platform;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellChecker
implements ISpellChecker {
    private static final Logger LOGGER = Logger.getLogger(SpellChecker.class.getName());
    private Hunspell hunspell;
    private Hunspell hunspellSave;
    private org.dts.spell.SpellChecker jmyspell;
    private List<String> ignoreList = new ArrayList<String>();
    private List<String> learnedList = new ArrayList<String>();
    private Pointer pHunspell = null;
    private String encoding;
    private String ignoreFileName;
    private String learnedFileName;
    private boolean addNotSupportedLogged = false;
    private boolean addToHunspell = true;

    public SpellChecker() {
        String string = Platform.isWebStart() ? Native.getWebStartLibraryPath((String)"hunspell") + File.separator + SpellChecker.mapLibraryName("hunspell") : StaticUtils.installDir() + File.separator + "native" + File.separator + SpellChecker.mapLibraryName("hunspell");
        try {
            this.hunspell = (Hunspell)Native.loadLibrary((String)string, Hunspell.class);
            Log.log("Hunspell loaded successfully from " + string);
        }
        catch (Exception exception) {
            Log.log("Error loading hunspell: " + exception.getMessage());
        }
        catch (Error error) {
            Log.log("Error loading hunspell: " + error.getMessage());
        }
        CoreEvents.registerProjectChangeListener(new IProjectEventListener(){

            public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE pROJECT_CHANGE_TYPE) {
                switch (pROJECT_CHANGE_TYPE) {
                    case LOAD: 
                    case CREATE: {
                        SpellChecker.this.initialize();
                        break;
                    }
                    case CLOSE: {
                        SpellChecker.this.destroy();
                    }
                }
            }
        });
    }

    @Override
    public void initialize() {
        String string = Core.getProject().getProjectProperties().getTargetLanguage().getLocaleCode();
        String string2 = Preferences.getPreference("spellcheker_dir");
        if (string2 != null) {
            Object object;
            String string3 = string2 + File.separator + string + ".aff";
            String string4 = string2 + File.separator + string + ".dic";
            File file = new File(string4);
            if (!file.exists()) {
                if (this.hunspell != null) {
                    this.hunspellSave = this.hunspell;
                    this.hunspell = null;
                }
                return;
            }
            if (this.hunspell == null && this.hunspellSave != null) {
                this.hunspell = this.hunspellSave;
            }
            if (this.hunspell != null) {
                this.pHunspell = this.hunspell.Hunspell_create(string3, string4);
                this.encoding = this.hunspell.Hunspell_get_dic_encoding(this.pHunspell);
                LOGGER.finer("Initialize SpellChecker by Hunspell for language '" + string + "' dictionary " + string4);
            } else {
                try {
                    object = new OpenOfficeSpellDictionary(new File(string4), new File(string3), false);
                    this.jmyspell = new org.dts.spell.SpellChecker((SpellDictionary)object);
                    this.jmyspell.setCaseSensitive(false);
                }
                catch (Exception exception) {
                    Log.log("Error loading jmyspell: " + exception.getMessage());
                    return;
                }
                LOGGER.finer("Initialize SpellChecker by JMySpell for language '" + string + "' dictionary " + string4);
            }
            object = Core.getProject().getProjectProperties().getProjectInternal();
            this.ignoreFileName = (String)object + "ignored_words.txt";
            this.ignoreList = new ArrayList<String>();
            this.fillWordList(this.ignoreFileName, this.ignoreList);
            this.learnedFileName = (String)object + "learned_words.txt";
            this.learnedList = new ArrayList<String>();
            this.fillWordList(this.learnedFileName, this.learnedList);
            if (this.hunspell != null) {
                try {
                    for (int i = 0; i < this.learnedList.size(); ++i) {
                        this.addWord(this.pHunspell, this.prepareString(this.learnedList.get(i)));
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Log.log("Unsupported encoding " + this.encoding);
                }
            }
        }
    }

    @Override
    public void destroy() {
        if (this.pHunspell != null) {
            this.hunspell.Hunspell_destroy(this.pHunspell);
            this.saveWordLists();
            this.pHunspell = null;
        }
        if (this.jmyspell != null) {
            this.jmyspell = null;
        }
    }

    @Override
    public void saveWordLists() {
        this.dumpWordList(this.ignoreList, this.ignoreFileName);
        this.dumpWordList(this.learnedList, this.learnedFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillWordList(String string, List<String> list) {
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
            while ((string2 = bufferedReader.readLine()) != null) {
                list.add(string2);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpWordList(List<String> list, String string) {
        if (string == null) {
            return;
        }
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8"));
            for (String string2 : list) {
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    @Override
    public boolean isCorrect(String string) {
        if (this.learnedList.contains(string) || this.ignoreList.contains(string)) {
            return true;
        }
        if (this.pHunspell != null) {
            try {
                if (0 != this.hunspell.Hunspell_spell(this.pHunspell, this.prepareString(string))) {
                    return true;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.log("Unsupported encoding " + this.encoding);
            }
            return false;
        }
        if (this.jmyspell != null) {
            return this.jmyspell.isCorrect((CharSequence)string);
        }
        return true;
    }

    @Override
    public List<String> suggest(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isCorrect(string)) {
            return arrayList;
        }
        if (this.pHunspell != null) {
            PointerByReference pointerByReference = new PointerByReference();
            int n = 0;
            try {
                n = this.hunspell.Hunspell_suggest(this.pHunspell, pointerByReference, this.prepareString(string));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.log("Unsupported encoding " + this.encoding);
            }
            Pointer[] pointerArray = null;
            Pointer pointer = pointerByReference.getValue();
            if (pointer != null) {
                try {
                    pointerArray = pointer.getPointerArray(0L, n);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            if (pointerArray != null) {
                Charset charset = Charset.forName(this.encoding);
                CharsetDecoder charsetDecoder = charset.newDecoder();
                for (int i = 0; i < n; ++i) {
                    try {
                        byte by;
                        byte[] byArray = new byte[100];
                        for (int j = 0; j < 100 && (by = pointerArray[i].getByte((long)j)) != 0; ++j) {
                            byArray[j] = by;
                        }
                        CharBuffer charBuffer = charsetDecoder.decode(ByteBuffer.wrap(byArray));
                        arrayList.add(charBuffer.toString().trim());
                        continue;
                    }
                    catch (CharacterCodingException characterCodingException) {
                        Log.log("Unsupported encoding " + this.encoding);
                    }
                }
            }
        } else if (this.jmyspell != null) {
            arrayList.addAll(this.jmyspell.getDictionary().getSuggestions(string, 20));
        }
        return arrayList;
    }

    @Override
    public void ignoreWord(String string) {
        if (!this.ignoreList.contains(string)) {
            this.ignoreList.add(string);
        }
    }

    @Override
    public void learnWord(String string) {
        if (!this.learnedList.contains(string)) {
            this.learnedList.add(string);
            if (this.pHunspell != null) {
                try {
                    this.addWord(this.pHunspell, this.prepareString(string));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Log.log("Unsupported encoding " + this.encoding);
                }
            }
        }
    }

    protected byte[] prepareString(String string) throws UnsupportedEncodingException {
        return (string + "\u0000").getBytes(this.encoding);
    }

    private static String mapLibraryName(String string) {
        if (Platform.isMac()) {
            if (string.matches("lib.*\\.(dylib|jnilib)$")) {
                return string;
            }
            String string2 = System.mapLibraryName(string);
            if (string2.endsWith(".jnilib")) {
                return string2.substring(0, string2.lastIndexOf(".jnilib")) + ".dylib";
            }
            return string2;
        }
        if (Platform.isLinux()) {
            if (string.matches("lib.*\\.so\\.[0-9]+$")) {
                return string;
            }
            string = string + "-" + System.getProperty("os.arch");
        }
        return System.mapLibraryName(string);
    }

    private void addWord(Pointer pointer, byte[] byArray) {
        if (!this.addToHunspell) {
            return;
        }
        try {
            this.hunspell.Hunspell_add(pointer, byArray);
        }
        catch (Error error) {
            if (!this.addNotSupportedLogged) {
                Log.log("Hunspell_add not supported");
                this.addNotSupportedLogged = true;
            }
            try {
                this.hunspell.Hunspell_put_word(pointer, byArray);
            }
            catch (Error error2) {
                Log.log("Hunspell_put_word not supported");
                this.addToHunspell = false;
            }
        }
    }
}

