/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.statistics;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.omegat.core.Core;
import org.omegat.core.data.IProject;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.StringEntry;
import org.omegat.core.statistics.StatCount;
import org.omegat.core.statistics.Statistics;
import org.omegat.core.threads.LongProcessThread;
import org.omegat.gui.stat.StatisticsWindow;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;
import org.omegat.util.gui.TextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalcStandardStatistics
extends LongProcessThread {
    private static final String[] htHeaders = new String[]{"", OStrings.getString("CT_STATS_Segments"), OStrings.getString("CT_STATS_Words"), OStrings.getString("CT_STATS_Characters_NOSP"), OStrings.getString("CT_STATS_Characters")};
    private static final String[] htRows = new String[]{OStrings.getString("CT_STATS_Total"), OStrings.getString("CT_STATS_Remaining"), OStrings.getString("CT_STATS_Unique"), OStrings.getString("CT_STATS_Unique_Remaining")};
    private static final boolean[] htAlign = new boolean[]{false, true, true, true, true};
    private static final String[] ftHeaders = new String[]{OStrings.getString("CT_STATS_FILE_Name"), OStrings.getString("CT_STATS_FILE_Total_Words"), OStrings.getString("CT_STATS_FILE_Remaining_Words"), OStrings.getString("CT_STATS_FILE_Total_Characters_NOSP"), OStrings.getString("CT_STATS_FILE_Remaining_Characters_NOSP"), OStrings.getString("CT_STATS_FILE_Total_Characters"), OStrings.getString("CT_STATS_FILE_Remaining_Characters")};
    private static final boolean[] ftAlign = new boolean[]{false, true, true, true, true, true, true, true};
    private StatisticsWindow callback;

    public CalcStandardStatistics(StatisticsWindow statisticsWindow) {
        this.callback = statisticsWindow;
    }

    @Override
    public void run() {
        Object object;
        IProject iProject = Core.getProject();
        String string = CalcStandardStatistics.buildProjectStats(iProject.getUniqueEntries(), iProject.getAllEntries(), iProject.getProjectProperties(), iProject.getStatistics().numberofTranslatedSegments);
        this.callback.displayData(string);
        String string2 = iProject.getProjectProperties().getProjectInternal();
        try {
            object = new File(string2 + "word_counts");
            if (((File)object).exists()) {
                ((File)object).delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = string2 + "project_stats.txt";
        Statistics.writeStat((String)object, string);
    }

    public static String buildProjectStats(List<StringEntry> list, List<SourceTextEntry> list2, ProjectProperties projectProperties, int n) {
        int n2;
        String string;
        StatCount statCount = new StatCount();
        StatCount statCount2 = new StatCount();
        StatCount statCount3 = new StatCount();
        StatCount statCount4 = new StatCount();
        statCount.segments = list2.size();
        for (StringEntry object2 : list) {
            String string2 = object2.getSrcText();
            int n3 = object2.getParentList().size();
            int n4 = Statistics.numberOfWords(string2);
            statCount3.words += n4;
            statCount.words += n4 * n3;
            string = StaticUtils.stripTags(string2);
            int n5 = Statistics.numberOfCharactersWithoutSpaces(string);
            statCount3.charsWithoutSpaces += n5;
            statCount.charsWithoutSpaces += n5 * n3;
            n2 = string.length();
            statCount3.charsWithSpaces += n2;
            statCount.charsWithSpaces += n2 * n3;
            if (object2.isTranslated()) continue;
            statCount4.words += n4;
            statCount4.charsWithoutSpaces += n5;
            statCount4.charsWithSpaces += n2;
            statCount2.segments += n3;
        }
        statCount4.segments = list.size() - n;
        TreeMap treeMap = new TreeMap();
        for (SourceTextEntry sourceTextEntry : list2) {
            String string3 = sourceTextEntry.getSrcFile().name;
            FileData fileData = (FileData)treeMap.get(string3 = StaticUtils.makeFilenameRelative(string3, projectProperties.getSourceRoot()));
            if (fileData == null) {
                fileData = new FileData();
                treeMap.put(string3, fileData);
            }
            String string4 = sourceTextEntry.getSrcText();
            string = StaticUtils.stripTags(string4);
            n2 = Statistics.numberOfWords(string4);
            fileData.total.words += n2;
            int n6 = Statistics.numberOfCharactersWithoutSpaces(string);
            fileData.total.charsWithoutSpaces += n6;
            int n7 = string.length();
            fileData.total.charsWithSpaces += n7;
            if (!sourceTextEntry.isTranslated()) {
                statCount2.words += n2;
                fileData.remaining.words += n2;
                statCount2.charsWithoutSpaces += n6;
                fileData.remaining.charsWithoutSpaces += n6;
                statCount2.charsWithSpaces += n7;
                fileData.remaining.charsWithSpaces += n7;
            }
            treeMap.put(string3, fileData);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(OStrings.getString("CT_STATS_Project_Statistics") + "\n\n");
        String[][] stringArray = CalcStandardStatistics.calcHeaderTable(new StatCount[]{statCount, statCount2, statCount3, statCount4});
        stringBuilder.append(TextUtil.showTextTable(htHeaders, stringArray, htAlign));
        stringBuilder.append("\n\n");
        stringBuilder.append(OStrings.getString("CT_STATS_FILE_Statistics") + "\n\n");
        String[][] stringArray2 = CalcStandardStatistics.calcFilesTable(treeMap);
        stringBuilder.append(TextUtil.showTextTable(ftHeaders, stringArray2, ftAlign));
        return stringBuilder.toString();
    }

    protected static String[][] calcHeaderTable(StatCount[] statCountArray) {
        String[][] stringArray = new String[statCountArray.length][5];
        for (int i = 0; i < statCountArray.length; ++i) {
            stringArray[i][0] = htRows[i];
            stringArray[i][1] = Integer.toString(statCountArray[i].segments);
            stringArray[i][2] = Integer.toString(statCountArray[i].words);
            stringArray[i][3] = Integer.toString(statCountArray[i].charsWithoutSpaces);
            stringArray[i][4] = Integer.toString(statCountArray[i].charsWithSpaces);
        }
        return stringArray;
    }

    protected static String[][] calcFilesTable(Map<String, FileData> map) {
        String[][] stringArray = new String[map.size()][7];
        int n = 0;
        for (String string : map.keySet()) {
            FileData fileData = map.get(string);
            stringArray[n][0] = string;
            stringArray[n][1] = Integer.toString(fileData.total.words);
            stringArray[n][2] = Integer.toString(fileData.remaining.words);
            stringArray[n][3] = Integer.toString(fileData.total.charsWithoutSpaces);
            stringArray[n][4] = Integer.toString(fileData.remaining.charsWithoutSpaces);
            stringArray[n][5] = Integer.toString(fileData.total.charsWithSpaces);
            stringArray[n][6] = Integer.toString(fileData.remaining.charsWithSpaces);
            ++n;
        }
        return stringArray;
    }

    public static class FileData {
        public StatCount total = new StatCount();
        public StatCount remaining = new StatCount();
    }
}

