/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.omegat.filters3.Attributes;
import org.omegat.filters3.xml.XMLDialect;
import org.omegat.util.MultiMap;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultXMLDialect
implements XMLDialect {
    private Set<String> paragraphTags = new HashSet<String>();
    private Set<String> preformatTags = new HashSet<String>();
    private Set<String> intactTags = new HashSet<String>();
    private MultiMap<String, String> translatableTagAttributes = new MultiMap();
    private Set<String> translatableAttributes = new HashSet<String>();
    private Set<String> outOfTurnTags = new HashSet<String>();
    Map<Integer, Pattern> constraints = new HashMap<Integer, Pattern>();
    Map<String, String> shortcuts = new HashMap<String, String>();

    public void defineParagraphTag(String string) {
        this.paragraphTags.add(string);
    }

    public void defineParagraphTags(String[] stringArray) {
        for (String string : stringArray) {
            this.defineParagraphTag(string);
        }
    }

    public void definePreformatTag(String string) {
        this.preformatTags.add(string);
    }

    public void definePreformatTags(String[] stringArray) {
        for (String string : stringArray) {
            this.definePreformatTag(string);
        }
    }

    public void defineIntactTag(String string) {
        this.intactTags.add(string);
    }

    public void defineIntactTags(String[] stringArray) {
        for (String string : stringArray) {
            this.defineIntactTag(string);
        }
    }

    public void defineTranslatableTagAttribute(String string, String string2) {
        this.translatableTagAttributes.put(string, string2);
    }

    public void defineTranslatableTagAttributes(String string, String[] stringArray) {
        for (String string2 : stringArray) {
            this.defineTranslatableTagAttribute(string, string2);
        }
    }

    public void defineTranslatableTagsAttribute(String[] stringArray, String string) {
        for (String string2 : stringArray) {
            this.defineTranslatableTagAttribute(string2, string);
        }
    }

    public void defineTranslatableAttribute(String string) {
        this.translatableAttributes.add(string);
    }

    public void defineTranslatableAttributes(String[] stringArray) {
        for (String string : stringArray) {
            this.defineTranslatableAttribute(string);
        }
    }

    public void defineOutOfTurnTag(String string) {
        this.outOfTurnTags.add(string);
    }

    public void defineOutOfTurnTags(String[] stringArray) {
        for (String string : stringArray) {
            this.defineOutOfTurnTag(string);
        }
    }

    public void defineConstraint(Integer n, Pattern pattern) {
        this.constraints.put(n, pattern);
    }

    public void defineShortcut(String string, String string2) {
        this.shortcuts.put(string, string2);
    }

    public void defineShortcuts(String[] stringArray) {
        for (int i = 0; i < stringArray.length / 2; ++i) {
            this.defineShortcut(stringArray[2 * i], stringArray[2 * i + 1]);
        }
    }

    @Override
    public Set<String> getParagraphTags() {
        return this.paragraphTags;
    }

    @Override
    public Set<String> getPreformatTags() {
        return this.preformatTags;
    }

    @Override
    public Set<String> getIntactTags() {
        return this.intactTags;
    }

    @Override
    public MultiMap<String, String> getTranslatableTagAttributes() {
        return this.translatableTagAttributes;
    }

    @Override
    public Boolean validateTranslatableTagAttribute(String string, String string2, Attributes attributes) {
        return true;
    }

    @Override
    public Boolean validateIntactTag(String string, Attributes attributes) {
        return false;
    }

    @Override
    public Boolean validateParagraphTag(String string, Attributes attributes) {
        return false;
    }

    @Override
    public Boolean validatePreformatTag(String string, Attributes attributes) {
        return false;
    }

    @Override
    public Set<String> getTranslatableAttributes() {
        return this.translatableAttributes;
    }

    @Override
    public Set<String> getOutOfTurnTags() {
        return this.outOfTurnTags;
    }

    @Override
    public Map<Integer, Pattern> getConstraints() {
        return this.constraints;
    }

    @Override
    public InputSource resolveEntity(String string, String string2) {
        return null;
    }

    @Override
    public Map<String, String> getShortcuts() {
        return this.shortcuts;
    }
}

