/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dictionaries;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.StringEntry;
import org.omegat.core.dictionaries.DictionariesManager;
import org.omegat.core.dictionaries.DictionaryEntry;
import org.omegat.core.events.IEditorEventListener;
import org.omegat.core.matching.ITokenizer;
import org.omegat.gui.common.EntryInfoPane;
import org.omegat.gui.common.EntryInfoSearchThread;
import org.omegat.gui.main.DockableScrollPane;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;
import org.omegat.util.Token;
import org.omegat.util.gui.UIThreadsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionariesTextArea
extends EntryInfoPane<List<DictionaryEntry>> {
    protected final DictionariesManager manager = new DictionariesManager(this);
    protected final List<String> displayedWords = new ArrayList<String>();
    protected final MouseAdapter mouseCallback = new MouseAdapter(){

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() || mouseEvent.getButton() == 3) {
                UIThreadsUtil.mustBeSwingThread();
                JPopupMenu jPopupMenu = new JPopupMenu();
                int n = DictionariesTextArea.this.viewToModel(mouseEvent.getPoint());
                HTMLDocument hTMLDocument = (HTMLDocument)DictionariesTextArea.this.getDocument();
                for (int i = 0; i < DictionariesTextArea.this.displayedWords.size(); ++i) {
                    Element element = hTMLDocument.getElement(Integer.toString(i));
                    if (element == null || element.getStartOffset() > n || element.getEndOffset() < n) continue;
                    final String string = DictionariesTextArea.this.displayedWords.get(i);
                    String string2 = StaticUtils.format(OStrings.getString("DICTIONARY_HIDE"), string);
                    JMenuItem jMenuItem = jPopupMenu.add(string2);
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            DictionariesTextArea.this.manager.addIgnoreWord(string);
                        }
                    });
                }
                jPopupMenu.show(DictionariesTextArea.this, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    };

    public DictionariesTextArea() {
        super(true);
        this.setContentType("text/html");
        ((HTMLDocument)this.getDocument()).setPreservesUnknownTags(false);
        String string = OStrings.getString("GUI_MATCHWINDOW_SUBWINDOWTITLE_Dictionary");
        Core.getMainWindow().addDockable(new DockableScrollPane("DICTIONARY", string, this, true));
        this.addMouseListener(this.mouseCallback);
        CoreEvents.registerEditorEventListener(new IEditorEventListener(){

            public void onNewWord(String string) {
                DictionariesTextArea.this.callDictionary(string);
            }
        });
    }

    @Override
    protected void onProjectOpen() {
        this.clear();
        this.manager.start(Core.getProject().getProjectProperties().getDictRoot());
    }

    @Override
    protected void onProjectClose() {
        this.clear();
        this.manager.stop();
    }

    protected void clear() {
        UIThreadsUtil.mustBeSwingThread();
        this.setText("");
    }

    protected void callDictionary(String string) {
        Element element;
        UIThreadsUtil.mustBeSwingThread();
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
        int n = this.displayedWords.indexOf(string.toLowerCase());
        if (n >= 0 && (element = hTMLDocument.getElement(Integer.toString(n))) != null) {
            try {
                Rectangle rectangle = this.getUI().modelToView(this, element.getStartOffset());
                if (rectangle != null) {
                    rectangle.height *= 2;
                    this.scrollRectToVisible(rectangle);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void startSearchThread(StringEntry stringEntry) {
        new DictionaryEntriesSearchThread(stringEntry).start();
    }

    public void refresh() {
        SourceTextEntry sourceTextEntry = Core.getEditor().getCurrentEntry();
        if (sourceTextEntry != null) {
            this.startSearchThread(sourceTextEntry.getStrEntry());
        }
    }

    @Override
    protected void setFoundResult(List<DictionaryEntry> list) {
        UIThreadsUtil.mustBeSwingThread();
        this.displayedWords.clear();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = 0;
        for (DictionaryEntry dictionaryEntry : list) {
            if (bl) {
                stringBuilder.append("<br><hr>");
            } else {
                bl = true;
            }
            stringBuilder.append("<b><span id=\"" + n + "\">");
            stringBuilder.append(dictionaryEntry.getWord());
            stringBuilder.append("</span></b>");
            stringBuilder.append(" - ").append(dictionaryEntry.getArticle());
            this.displayedWords.add(dictionaryEntry.getWord().toLowerCase());
            ++n;
        }
        this.setText(stringBuilder.toString());
        this.setCaretPosition(0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DictionaryEntriesSearchThread
    extends EntryInfoSearchThread<List<DictionaryEntry>> {
        protected final String src;

        public DictionaryEntriesSearchThread(StringEntry stringEntry) {
            super(DictionariesTextArea.this, stringEntry);
            this.src = stringEntry.getSrcText();
        }

        @Override
        protected List<DictionaryEntry> search() {
            Token[] tokenArray = Core.getTokenizer().tokenizeWords(this.src, ITokenizer.StemmingMode.NONE);
            TreeSet<String> treeSet = new TreeSet<String>();
            for (Token token : tokenArray) {
                if (this.isEntryChanged()) {
                    return null;
                }
                String string = this.src.substring(token.getOffset(), token.getOffset() + token.getLength());
                treeSet.add(string);
            }
            List<DictionaryEntry> list = DictionariesTextArea.this.manager.findWords(treeSet);
            Collections.sort(list, new Comparator<DictionaryEntry>(){

                @Override
                public int compare(DictionaryEntry dictionaryEntry, DictionaryEntry dictionaryEntry2) {
                    return dictionaryEntry.getWord().compareTo(dictionaryEntry2.getWord());
                }
            });
            return list;
        }
    }
}

