/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Utilities;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.IProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.StringEntry;
import org.omegat.core.events.IEntryEventListener;
import org.omegat.core.events.IFontChangedEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.statistics.StatisticsInfo;
import org.omegat.gui.editor.Document3;
import org.omegat.gui.editor.DocumentFilter3;
import org.omegat.gui.editor.EditorSettings;
import org.omegat.gui.editor.EditorTextArea3;
import org.omegat.gui.editor.EditorUtils;
import org.omegat.gui.editor.IEditor;
import org.omegat.gui.editor.SegmentBuilder;
import org.omegat.gui.editor.SegmentHistory;
import org.omegat.gui.editor.SpellCheckerThread;
import org.omegat.gui.help.HelpFrame;
import org.omegat.gui.main.DockableScrollPane;
import org.omegat.gui.main.MainWindow;
import org.omegat.util.FileUtil;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;
import org.omegat.util.Token;
import org.omegat.util.gui.UIThreadsUtil;

public class EditorController
implements IEditor {
    private static final Logger LOGGER = Logger.getLogger(EditorController.class.getName());
    private final DockableScrollPane pane;
    protected final EditorTextArea3 editor;
    private String introPaneTitle;
    private String emptyProjectPaneTitle;
    private JTextPane introPane;
    private JTextPane emptyProjectPane;
    protected final MainWindow mw;
    protected SegmentBuilder[] m_docSegList;
    protected int displayedFileIndex;
    protected int previousDisplayedFileIndex;
    protected int displayedEntryIndex;
    private SegmentHistory history = new SegmentHistory();
    protected final EditorSettings settings;
    protected final SpellCheckerThread spellCheckerThread;
    protected Font baseFont;
    protected Font boldFont;
    Document3.ORIENTATION currentOrientation;
    protected boolean sourceLangIsRTL;
    protected boolean targetLangIsRTL;

    public EditorController(MainWindow mainWindow) {
        this.mw = mainWindow;
        this.editor = new EditorTextArea3(this);
        this.setFont(Core.getMainWindow().getApplicationFont());
        this.pane = new DockableScrollPane("EDITOR", " ", this.editor, false);
        this.pane.setComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        this.pane.setHorizontalScrollBarPolicy(31);
        this.pane.setMinimumSize(new Dimension(100, 100));
        Core.getMainWindow().addDockable(this.pane);
        this.settings = new EditorSettings(this);
        this.spellCheckerThread = new SpellCheckerThread();
        this.spellCheckerThread.start();
        CoreEvents.registerProjectChangeListener(new IProjectEventListener(){

            public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE pROJECT_CHANGE_TYPE) {
                SHOW_TYPE sHOW_TYPE;
                EditorController.this.spellCheckerThread.resetCache();
                switch (pROJECT_CHANGE_TYPE) {
                    case CREATE: 
                    case LOAD: {
                        EditorController.this.history.clear();
                        sHOW_TYPE = !Core.getProject().getAllEntries().isEmpty() ? SHOW_TYPE.FIRST_ENTRY : SHOW_TYPE.EMPTY_PROJECT;
                        EditorController.this.setInitialOrientation();
                        break;
                    }
                    case CLOSE: {
                        EditorController.this.history.clear();
                        sHOW_TYPE = SHOW_TYPE.INTRO;
                        break;
                    }
                    default: {
                        sHOW_TYPE = SHOW_TYPE.NO_CHANGE;
                    }
                }
                if (sHOW_TYPE != SHOW_TYPE.NO_CHANGE) {
                    EditorController.this.updateState(sHOW_TYPE);
                }
            }
        });
        CoreEvents.registerEntryEventListener(new IEntryEventListener(){

            public void onNewFile(String string) {
                EditorController.this.spellCheckerThread.resetCache();
                EditorController.this.updateState(SHOW_TYPE.NO_CHANGE);
            }

            public void onEntryActivated(StringEntry stringEntry) {
            }
        });
        this.createAdditionalPanes();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EditorController.this.updateState(SHOW_TYPE.INTRO);
                EditorController.this.pane.requestFocus();
            }
        });
        CoreEvents.registerFontChangedEventListener(new IFontChangedEventListener(){

            public void onFontChanged(Font font) {
                EditorController.this.setFont(font);
                EditorController.this.editor.revalidate();
                EditorController.this.editor.repaint();
                EditorController.this.emptyProjectPane.setFont(EditorController.this.baseFont);
            }
        });
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread thread, Throwable throwable) {
                LOGGER.log(Level.SEVERE, "Uncatched exception in thread [" + thread.getName() + "]", throwable);
            }
        });
    }

    private void updateState(SHOW_TYPE sHOW_TYPE) {
        UIThreadsUtil.mustBeSwingThread();
        JEditorPane jEditorPane = null;
        String string = null;
        switch (sHOW_TYPE) {
            case INTRO: {
                jEditorPane = this.introPane;
                string = this.introPaneTitle;
                break;
            }
            case EMPTY_PROJECT: {
                jEditorPane = this.emptyProjectPane;
                string = this.emptyProjectPaneTitle;
                break;
            }
            case FIRST_ENTRY: {
                this.displayedFileIndex = 0;
                this.displayedEntryIndex = 0;
                string = StaticUtils.format(OStrings.getString("GUI_SUBWINDOWTITLE_Editor"), this.getCurrentFile());
                jEditorPane = this.editor;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        EditorController.this.loadDocument();
                        EditorController.this.activateEntry();
                    }
                });
                break;
            }
            case NO_CHANGE: {
                string = StaticUtils.format(OStrings.getString("GUI_SUBWINDOWTITLE_Editor"), this.getCurrentFile());
                jEditorPane = this.editor;
            }
        }
        this.pane.setName(string);
        if (this.pane.getViewport().getView() != jEditorPane) {
            this.pane.setViewportView(jEditorPane);
        }
    }

    private void setFont(Font font) {
        this.baseFont = font;
        this.boldFont = new Font(font.getFontName(), 1, font.getSize());
        this.editor.setFont(font);
    }

    private void setInitialOrientation() {
        String string = Core.getProject().getProjectProperties().getSourceLanguage().getLanguageCode();
        String string2 = Core.getProject().getProjectProperties().getTargetLanguage().getLanguageCode();
        this.sourceLangIsRTL = EditorUtils.isRTL(string);
        this.targetLangIsRTL = EditorUtils.isRTL(string2);
        this.currentOrientation = this.sourceLangIsRTL != this.targetLangIsRTL ? Document3.ORIENTATION.DIFFER : (this.sourceLangIsRTL ? Document3.ORIENTATION.RTL : Document3.ORIENTATION.LTR);
        this.applyOrientationToEditor();
    }

    private void applyOrientationToEditor() {
        ComponentOrientation componentOrientation = null;
        switch (this.currentOrientation) {
            case LTR: {
                componentOrientation = ComponentOrientation.LEFT_TO_RIGHT;
                break;
            }
            case RTL: {
                componentOrientation = ComponentOrientation.RIGHT_TO_LEFT;
                break;
            }
            case DIFFER: {
                componentOrientation = this.targetLangIsRTL ? ComponentOrientation.RIGHT_TO_LEFT : ComponentOrientation.LEFT_TO_RIGHT;
            }
        }
        this.editor.setComponentOrientation(componentOrientation);
    }

    protected void toggleOrientation() {
        Document3.ORIENTATION oRIENTATION = this.currentOrientation;
        switch (this.currentOrientation) {
            case LTR: {
                oRIENTATION = Document3.ORIENTATION.RTL;
                break;
            }
            case RTL: {
                if (this.sourceLangIsRTL != this.targetLangIsRTL) {
                    oRIENTATION = Document3.ORIENTATION.DIFFER;
                    break;
                }
                oRIENTATION = Document3.ORIENTATION.LTR;
                break;
            }
            case DIFFER: {
                oRIENTATION = Document3.ORIENTATION.LTR;
            }
        }
        LOGGER.info("Switch document orientation from " + (Object)((Object)this.currentOrientation) + " to " + (Object)((Object)oRIENTATION));
        this.currentOrientation = oRIENTATION;
        this.applyOrientationToEditor();
        int n = this.displayedEntryIndex;
        this.loadDocument();
        this.displayedEntryIndex = n;
        this.activateEntry();
    }

    public void requestFocus() {
        this.pane.getViewport().getView().requestFocusInWindow();
    }

    public SourceTextEntry getCurrentEntry() {
        if (this.m_docSegList == null || this.displayedEntryIndex < 0 || this.m_docSegList.length < this.displayedEntryIndex) {
            return null;
        }
        return this.m_docSegList[this.displayedEntryIndex].ste;
    }

    public String getCurrentFile() {
        if (Core.getProject().getProjectFiles().isEmpty()) {
            return null;
        }
        if (this.displayedFileIndex < Core.getProject().getProjectFiles().size()) {
            return Core.getProject().getProjectFiles().get((int)this.displayedFileIndex).filePath;
        }
        return null;
    }

    protected void loadDocument() {
        UIThreadsUtil.mustBeSwingThread();
        IProject.FileInfo fileInfo = Core.getProject().getProjectFiles().get(this.displayedFileIndex);
        Document3 document3 = new Document3(this);
        List<SourceTextEntry> list = Core.getProject().getAllEntries();
        this.m_docSegList = new SegmentBuilder[fileInfo.size];
        for (int i = 0; i < this.m_docSegList.length; ++i) {
            SourceTextEntry sourceTextEntry = list.get(fileInfo.firstEntryIndexInGlobalList + i);
            this.m_docSegList[i] = new SegmentBuilder(this, document3, this.settings, sourceTextEntry, this.getEntryNumber(i));
            this.m_docSegList[i].createSegmentElement(false);
            SegmentBuilder.addSegmentSeparator(document3);
        }
        document3.setDocumentFilter(new DocumentFilter3());
        Locale locale = Core.getProject().getProjectProperties().getTargetLanguage().getLocale();
        this.editor.setLocale(locale);
        this.editor.setDocument(document3);
        document3.addUndoableEditListener(this.editor.undoManager);
        document3.addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                EditorController.this.showLengthMessage();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                EditorController.this.showLengthMessage();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                EditorController.this.showLengthMessage();
            }
        });
        this.editor.repaint();
    }

    public void activateEntry() {
        UIThreadsUtil.mustBeSwingThread();
        if (this.pane.getViewport().getView() != this.editor) {
            return;
        }
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        this.m_docSegList[this.displayedEntryIndex].createSegmentElement(true);
        this.editor.cancelUndo();
        this.history.insertNew(this.m_docSegList[this.displayedEntryIndex].segmentNumberInProject);
        this.mw.menu.gotoHistoryBackMenuItem.setEnabled(this.history.hasPrev());
        this.mw.menu.gotoHistoryForwardMenuItem.setEnabled(this.history.hasNext());
        this.showStat();
        this.showLengthMessage();
        SourceTextEntry sourceTextEntry = this.m_docSegList[this.displayedEntryIndex].ste;
        if (Preferences.isPreference("wf_exportCurrentSegment")) {
            this.exportCurrentSegment(sourceTextEntry);
        }
        this.scrollForDisplayNearestSegments(this.editor.getOmDocument().getTranslationStart());
        if (this.previousDisplayedFileIndex != this.displayedFileIndex) {
            this.previousDisplayedFileIndex = this.displayedFileIndex;
            CoreEvents.fireEntryNewFile(Core.getProject().getProjectFiles().get((int)this.displayedFileIndex).filePath);
        }
        this.editor.repaint();
        CoreEvents.fireEntryActivated(sourceTextEntry.getStrEntry());
    }

    void showLengthMessage() {
        Document3 document3 = this.editor.getOmDocument();
        String string = document3.extractTranslation();
        if (string != null) {
            SourceTextEntry sourceTextEntry = this.m_docSegList[this.displayedEntryIndex].ste;
            String string2 = " " + sourceTextEntry.getSrcText().length() + "/" + string.length() + " ";
            Core.getMainWindow().showLengthMessage(string2);
        }
    }

    private void scrollForDisplayNearestSegments(final int n) {
        int n2;
        int n3;
        SegmentBuilder segmentBuilder;
        try {
            segmentBuilder = this.m_docSegList[this.displayedEntryIndex - 3];
            n3 = segmentBuilder.getStartPosition();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            n3 = 0;
        }
        try {
            segmentBuilder = this.m_docSegList[this.displayedEntryIndex + 4];
            n2 = segmentBuilder.getStartPosition() - 1;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            n2 = this.editor.getOmDocument().getLength();
        }
        final int n4 = n3;
        final int n5 = n2;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    EditorController.this.editor.setCaretPosition(n5);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            try {
                                EditorController.this.editor.setCaretPosition(n4);
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        EditorController.this.editor.setCaretPosition(n);
                                    }
                                });
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                        }
                    });
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        });
    }

    private void exportCurrentSegment(SourceTextEntry sourceTextEntry) {
        String string = sourceTextEntry.getSrcText();
        String string2 = sourceTextEntry.getTranslation();
        FileUtil.writeScriptFile(string, "source.txt");
        FileUtil.writeScriptFile(string2, "target.txt");
    }

    private void showStat() {
        IProject iProject = Core.getProject();
        IProject.FileInfo fileInfo = iProject.getProjectFiles().get(this.displayedFileIndex);
        int n = 0;
        for (int i = 0; i < fileInfo.size; ++i) {
            if (!iProject.getAllEntries().get(i + fileInfo.firstEntryIndexInGlobalList).isTranslated()) continue;
            ++n;
        }
        StatisticsInfo statisticsInfo = iProject.getStatistics();
        String string = " " + Integer.toString(n) + "/" + Integer.toString(fileInfo.size) + " (" + Integer.toString(statisticsInfo.numberofTranslatedSegments) + "/" + Integer.toString(statisticsInfo.numberOfUniqueSegments) + ", " + Integer.toString(statisticsInfo.numberOfSegmentsTotal) + ") ";
        Core.getMainWindow().showProgressMessage(string);
    }

    protected void goToSegmentAtLocation(int n) {
        int n2 = this.m_docSegList.length - 1;
        for (int i = 0; i < this.m_docSegList.length; ++i) {
            if (n >= this.m_docSegList[i].getStartPosition()) continue;
            n2 = i - 1;
            break;
        }
        if (this.displayedEntryIndex != n2) {
            this.commitAndDeactivate();
            this.displayedEntryIndex = n2;
            this.activateEntry();
        }
    }

    public void commitAndDeactivate() {
        UIThreadsUtil.mustBeSwingThread();
        Document3 document3 = this.editor.getOmDocument();
        if (document3 == null) {
            return;
        }
        String string = document3.extractTranslation();
        document3.stopEditMode();
        if (string != null) {
            SourceTextEntry sourceTextEntry = this.m_docSegList[this.displayedEntryIndex].ste;
            String string2 = sourceTextEntry.getTranslation();
            if (string.equals(sourceTextEntry.getSrcText()) && !Preferences.isPreference("wf_allowTransEqualToSrc")) {
                Core.getProject().setTranslation(sourceTextEntry, "");
            } else {
                Core.getProject().setTranslation(sourceTextEntry, string);
            }
            this.m_docSegList[this.displayedEntryIndex].createSegmentElement(false);
            if (!sourceTextEntry.getTranslation().equals(string2)) {
                for (int i = 0; i < this.m_docSegList.length; ++i) {
                    if (i == this.displayedEntryIndex || !this.m_docSegList[i].ste.getSrcText().equals(sourceTextEntry.getSrcText())) continue;
                    this.m_docSegList[i].createSegmentElement(false);
                }
            }
        }
        this.editor.cancelUndo();
    }

    public void commitAndLeave() {
        this.commitAndDeactivate();
        this.activateEntry();
    }

    public void nextEntry() {
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        this.commitAndDeactivate();
        ++this.displayedEntryIndex;
        if (this.displayedEntryIndex >= this.m_docSegList.length) {
            ++this.displayedFileIndex;
            this.displayedEntryIndex = 0;
            if (this.displayedFileIndex >= Core.getProject().getProjectFiles().size()) {
                this.displayedFileIndex = 0;
            }
            this.loadDocument();
        }
        this.activateEntry();
    }

    public void prevEntry() {
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        this.commitAndDeactivate();
        --this.displayedEntryIndex;
        if (this.displayedEntryIndex < 0) {
            --this.displayedFileIndex;
            if (this.displayedFileIndex < 0) {
                this.displayedFileIndex = Core.getProject().getProjectFiles().size() - 1;
            }
            this.displayedEntryIndex = Core.getProject().getProjectFiles().get((int)this.displayedFileIndex).size - 1;
            this.loadDocument();
        }
        this.activateEntry();
    }

    public void nextUntranslatedEntry() {
        int n;
        SourceTextEntry sourceTextEntry;
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        this.commitAndDeactivate();
        int n2 = this.displayedEntryIndex;
        int n3 = this.displayedFileIndex;
        do {
            ++this.displayedEntryIndex;
            if (this.displayedEntryIndex >= Core.getProject().getProjectFiles().get((int)this.displayedFileIndex).size) {
                ++this.displayedFileIndex;
                this.displayedEntryIndex = 0;
                if (this.displayedFileIndex >= Core.getProject().getProjectFiles().size()) {
                    this.displayedFileIndex = 0;
                }
            }
            if (this.displayedFileIndex == n3 && this.displayedEntryIndex == n2) break;
            n = Core.getProject().getProjectFiles().get((int)this.displayedFileIndex).firstEntryIndexInGlobalList + this.displayedEntryIndex;
        } while ((sourceTextEntry = Core.getProject().getAllEntries().get(n)).getTranslation() != null && sourceTextEntry.getTranslation().length() != 0);
        if (this.displayedFileIndex != n3) {
            this.loadDocument();
        }
        this.activateEntry();
    }

    public int getCurrentEntryNumber() {
        return this.getEntryNumber(this.displayedEntryIndex);
    }

    protected int getEntryNumber(int n) {
        if (Core.getProject().getProjectFiles().isEmpty()) {
            return -1;
        }
        int n2 = Core.getProject().getProjectFiles().get((int)this.displayedFileIndex).firstEntryIndexInGlobalList + n + 1;
        return n2;
    }

    public void gotoEntry(int n) {
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        if (this.m_docSegList == null) {
            return;
        }
        this.commitAndDeactivate();
        if (n == 0) {
            this.displayedFileIndex = 0;
            this.displayedEntryIndex = 0;
            this.loadDocument();
        } else {
            IProject iProject = Core.getProject();
            for (int i = 0; i < iProject.getProjectFiles().size(); ++i) {
                IProject.FileInfo fileInfo = iProject.getProjectFiles().get(i);
                if (fileInfo.firstEntryIndexInGlobalList > n - 1 || fileInfo.firstEntryIndexInGlobalList + fileInfo.size <= n - 1) continue;
                this.displayedEntryIndex = n - 1 - fileInfo.firstEntryIndexInGlobalList;
                if (i == this.displayedFileIndex) break;
                this.displayedFileIndex = i;
                this.loadDocument();
                break;
            }
        }
        this.activateEntry();
    }

    public void changeCase(IEditor.CHANGE_CASE_TO cHANGE_CASE_TO) {
        UIThreadsUtil.mustBeSwingThread();
        int n = this.editor.getSelectionStart();
        int n2 = this.editor.getSelectionEnd();
        int n3 = this.editor.getCaretPosition();
        int n4 = this.editor.getOmDocument().getTranslationStart();
        int n5 = this.editor.getOmDocument().getTranslationEnd();
        if (n2 < n4 || n > n5) {
            return;
        }
        if (n < n4 && n2 <= n5) {
            n = n4;
        }
        if (n2 > n5 && n >= n4) {
            n2 = n5;
        }
        try {
            int n6;
            if (n == n2) {
                n = Utilities.getWordStart(this.editor, n);
                n2 = Utilities.getWordEnd(this.editor, n2);
            }
            this.editor.setSelectionStart(n);
            this.editor.setSelectionEnd(n2);
            String string = this.editor.getText(n, n2 - n);
            Token[] tokenArray = Core.getTokenizer().tokenizeWordsForSpelling(string);
            StringBuffer stringBuffer = new StringBuffer(string);
            if (cHANGE_CASE_TO == IEditor.CHANGE_CASE_TO.CYCLE) {
                n6 = 0;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                for (Token token : tokenArray) {
                    String string2 = token.getTextFromString(string);
                    if (StringUtil.isLowerCase(string2)) {
                        ++n6;
                        continue;
                    }
                    if (StringUtil.isTitleCase(string2)) {
                        ++n8;
                        continue;
                    }
                    if (StringUtil.isUpperCase(string2)) {
                        ++n7;
                        continue;
                    }
                    ++n9;
                }
                if (n6 == 0 && n8 == 0 && n7 == 0 && n9 == 0) {
                    return;
                }
                if (n6 != 0 && n8 == 0 && n7 == 0) {
                    cHANGE_CASE_TO = IEditor.CHANGE_CASE_TO.TITLE;
                }
                if (n6 == 0 && n8 != 0 && n7 == 0) {
                    cHANGE_CASE_TO = IEditor.CHANGE_CASE_TO.UPPER;
                }
                if (n6 == 0 && n8 == 0 && n7 != 0) {
                    cHANGE_CASE_TO = IEditor.CHANGE_CASE_TO.LOWER;
                }
                if (n9 != 0) {
                    cHANGE_CASE_TO = IEditor.CHANGE_CASE_TO.UPPER;
                }
            }
            n6 = 0;
            for (Token token : tokenArray) {
                String string3 = this.doChangeCase(token.getTextFromString(string), cHANGE_CASE_TO);
                stringBuffer.replace(token.getOffset() + n6, token.getLength() + token.getOffset() + n6, string3);
                n6 += string3.length() - token.getLength();
            }
            this.editor.replaceSelection(stringBuffer.toString());
            this.editor.setCaretPosition(n3);
            this.editor.setSelectionStart(n);
            this.editor.setSelectionEnd(n2);
        }
        catch (BadLocationException badLocationException) {
            Log.log("bad location exception when changing case");
            Log.log(badLocationException);
        }
    }

    private String doChangeCase(String string, IEditor.CHANGE_CASE_TO cHANGE_CASE_TO) {
        Locale locale = Core.getProject().getProjectProperties().getTargetLanguage().getLocale();
        switch (cHANGE_CASE_TO) {
            case LOWER: {
                return string.toLowerCase(locale);
            }
            case UPPER: {
                return string.toUpperCase(locale);
            }
            case TITLE: {
                return Character.toTitleCase(string.charAt(0)) + string.substring(1).toLowerCase(locale);
            }
        }
        return string.toUpperCase(locale);
    }

    public void replaceEditText(String string) {
        UIThreadsUtil.mustBeSwingThread();
        int n = this.editor.getOmDocument().getTranslationStart();
        int n2 = this.editor.getOmDocument().getTranslationEnd();
        this.editor.select(n, n2);
        this.editor.replaceSelection(string);
    }

    public void insertText(String string) {
        UIThreadsUtil.mustBeSwingThread();
        this.editor.checkAndFixCaret();
        this.editor.replaceSelection(string);
    }

    public void gotoHistoryBack() {
        UIThreadsUtil.mustBeSwingThread();
        int n = this.history.back();
        if (n != -1) {
            this.gotoEntry(n);
        }
    }

    public void gotoHistoryForward() {
        UIThreadsUtil.mustBeSwingThread();
        int n = this.history.forward();
        if (n != -1) {
            this.gotoEntry(n);
        }
    }

    public EditorSettings getSettings() {
        return this.settings;
    }

    public void undo() {
        UIThreadsUtil.mustBeSwingThread();
        try {
            if (this.editor.undoManager.canUndo()) {
                this.editor.undoManager.undo();
            }
        }
        catch (CannotUndoException cannotUndoException) {
            Log.log(cannotUndoException);
        }
    }

    public void redo() {
        UIThreadsUtil.mustBeSwingThread();
        try {
            if (this.editor.undoManager.canRedo()) {
                this.editor.undoManager.redo();
            }
        }
        catch (CannotRedoException cannotRedoException) {
            Log.log(cannotRedoException);
        }
    }

    public String getSelectedText() {
        UIThreadsUtil.mustBeSwingThread();
        return this.editor.getSelectedText();
    }

    private void createAdditionalPanes() {
        this.introPaneTitle = OStrings.getString("DOCKING_INSTANT_START_TITLE");
        try {
            String string = this.detectInstantStartLanguage();
            this.introPane = new JTextPane();
            this.introPane.setComponentOrientation(EditorUtils.isRTL(string) ? ComponentOrientation.RIGHT_TO_LEFT : ComponentOrientation.LEFT_TO_RIGHT);
            this.introPane.setEditable(false);
            this.introPane.setPage(HelpFrame.getHelpFileURL(string, "instantStartGuideNoTOC.html"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.emptyProjectPaneTitle = OStrings.getString("TF_INTRO_EMPTYPROJECT_FILENAME");
        this.emptyProjectPane = new JTextPane();
        this.emptyProjectPane.setEditable(false);
        this.emptyProjectPane.setText(OStrings.getString("TF_INTRO_EMPTYPROJECT"));
        this.emptyProjectPane.setFont(Core.getMainWindow().getApplicationFont());
    }

    private String detectInstantStartLanguage() {
        String string = Locale.getDefault().getLanguage().toLowerCase();
        String string2 = Locale.getDefault().getCountry().toUpperCase();
        if (HelpFrame.getHelpFileURL(string + "_" + string2, "instantStartGuideNoTOC.html") != null) {
            return string + "_" + string2;
        }
        if (HelpFrame.getHelpFileURL(string, "instantStartGuideNoTOC.html") != null) {
            return string;
        }
        return "en";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SHOW_TYPE {
        INTRO,
        EMPTY_PROJECT,
        FIRST_ENTRY,
        NO_CHANGE;

    }
}

