/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.omegat.core.Core;
import org.omegat.util.Log;

public class SpellCheckerThread
extends Thread {
    private final Queue<String> forCheck = new LinkedList<String>();
    private final Set<String> correctWords = new HashSet<String>();
    private final Set<String> incorrectWords = new HashSet<String>();
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();

    public synchronized void addForCheck(String string) {
        this.forCheck.add(string);
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCache() {
        this.w.lock();
        try {
            this.incorrectWords.clear();
            this.correctWords.clear();
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIncorrect(String string) {
        this.r.lock();
        try {
            if (this.incorrectWords.contains(string)) {
                boolean bl = true;
                return bl;
            }
            if (this.correctWords.contains(string)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.r.unlock();
        }
        return !this.checkWordSpelling(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        Thread.currentThread().setPriority(1);
        Thread.currentThread().setName(this.getClass().getSimpleName());
        try {
            block7: while (true) {
                var2_3 = this;
                // MONITORENTER : this
                var1_1 = this.forCheck.poll();
                if (var1_1 == null) {
                    this.wait();
                }
                // MONITOREXIT : var2_3
                if (var1_1 == null) continue;
                var2_3 = Core.getTokenizer().tokenizeWordsForSpelling(var1_1);
                var3_4 = var2_3.length;
                var4_5 = 0;
                while (true) {
                    block11: {
                        block10: {
                            if (var4_5 < var3_4) ** break;
                            continue block7;
                            var5_6 = var2_3[var4_5];
                            var6_7 = var1_1.substring(var5_6.getOffset(), var5_6.getOffset() + var5_6.getLength());
                            this.r.lock();
                            try {
                                if (!this.correctWords.contains(var6_7) && !this.incorrectWords.contains(var6_7)) break block10;
                                break block11;
                            }
                            finally {
                                this.r.unlock();
                            }
                        }
                        super.checkWordSpelling(var6_7);
                    }
                    ++var4_5;
                }
                break;
            }
        }
        catch (InterruptedException var1_2) {
            Log.log(var1_2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkWordSpelling(String string) {
        this.w.lock();
        try {
            if (this.incorrectWords.contains(string)) {
                boolean bl = false;
                return bl;
            }
            if (this.correctWords.contains(string)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = Core.getSpellChecker().isCorrect(string);
            if (bl) {
                this.correctWords.add(string);
            } else {
                this.incorrectWords.add(string);
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            this.w.unlock();
        }
    }
}

