/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.filelist;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.IProject;
import org.omegat.core.data.StringEntry;
import org.omegat.core.events.IEntryEventListener;
import org.omegat.core.events.IFontChangedEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.statistics.StatisticsInfo;
import org.omegat.gui.main.MainWindow;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.gui.UIThreadsUtil;
import org.openide.awt.Mnemonics;

public class ProjectFrame
extends JFrame {
    private static final Color COLOR_STANDARD_FG = Color.BLACK;
    private static final Color COLOR_STANDARD_BG = Color.WHITE;
    private static final Color COLOR_CURRENT_FG = Color.BLACK;
    private static final Color COLOR_CURRENT_BG = new Color(13164018);
    private static final Color COLOR_SELECTION_FG = Color.WHITE;
    private static final Color COLOR_SELECTION_BG = new Color(3110874);
    private static final int LINE_SPACING = 6;
    private JTable tableFiles;
    private JTable tableTotal;
    private JScrollPane scrollFiles;
    private AbstractTableModel modelFiles;
    private AbstractTableModel modelTotal;
    private List<IProject.FileInfo> files;
    private JTextArea statLabel;
    private JButton m_addNewFileButton;
    private JButton m_wikiImportButton;
    private JButton m_closeButton;
    private MainWindow m_parent;
    private Font dialogFont;

    public ProjectFrame(MainWindow mainWindow) {
        this.m_parent = mainWindow;
        this.createTableFiles();
        this.dialogFont = this.tableFiles.getFont();
        this.createTableTotal();
        this.initWindowLayout();
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.scrollFiles = new JScrollPane(this.tableFiles, 20, 31);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.scrollFiles, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.tableTotal, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setContentPane(jPanel);
        this.m_addNewFileButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.m_addNewFileButton, (String)OStrings.getString("TF_MENU_FILE_IMPORT"));
        this.m_addNewFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectFrame.this.doImportSourceFiles();
            }
        });
        this.m_wikiImportButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.m_wikiImportButton, (String)OStrings.getString("TF_MENU_WIKI_IMPORT"));
        this.m_wikiImportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectFrame.this.doWikiImport();
            }
        });
        this.m_closeButton = new JButton();
        this.m_closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectFrame.this.doCancel();
            }
        });
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectFrame.this.doCancel();
            }
        };
        this.getRootPane().getInputMap(2).put(keyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", abstractAction);
        Mnemonics.setLocalizedText((AbstractButton)this.m_closeButton, (String)OStrings.getString("BUTTON_CLOSE"));
        this.setTitle(OStrings.getString("PF_WINDOW_TITLE"));
        this.statLabel = new JTextArea();
        this.statLabel.setFont(this.getFont());
        this.statLabel.setEditable(false);
        this.statLabel.setLineWrap(true);
        this.statLabel.setBackground(this.getBackground());
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        jPanel.add((Component)this.statLabel, gridBagConstraints);
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this.m_addNewFileButton);
        box.add(this.m_wikiImportButton);
        box.add(this.m_closeButton);
        box.add(Box.createHorizontalGlue());
        box.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        gridBagConstraints.gridy = 6;
        jPanel.add((Component)box, gridBagConstraints);
        CoreEvents.registerProjectChangeListener(new IProjectEventListener(){

            public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE pROJECT_CHANGE_TYPE) {
                switch (pROJECT_CHANGE_TYPE) {
                    case CLOSE: {
                        ProjectFrame.this.setVisible(false);
                        break;
                    }
                    case LOAD: 
                    case CREATE: {
                        ProjectFrame.this.buildDisplay();
                        ProjectFrame.this.setVisible(true);
                        ProjectFrame.this.tableFiles.requestFocus();
                        ProjectFrame.this.buildTotalTableLayout();
                    }
                }
            }
        });
        CoreEvents.registerEntryEventListener(new IEntryEventListener(){

            public void onNewFile(String string) {
                ProjectFrame.this.tableFiles.repaint();
                ProjectFrame.this.tableTotal.repaint();
                ProjectFrame.this.modelTotal.fireTableDataChanged();
            }

            public void onEntryActivated(StringEntry stringEntry) {
                UIThreadsUtil.mustBeSwingThread();
                ProjectFrame.this.modelTotal.fireTableDataChanged();
            }
        });
        CoreEvents.registerFontChangedEventListener(new IFontChangedEventListener(){

            public void onFontChanged(Font font) {
                if (!Preferences.isPreference("project_files_use_font")) {
                    font = ProjectFrame.this.dialogFont;
                }
                ProjectFrame.this.tableFiles.setFont(font);
                ProjectFrame.this.tableTotal.setFont(new Font(font.getName(), 1, font.getSize()));
                ProjectFrame.this.tableFiles.setRowHeight(font.getSize() + 6);
                ProjectFrame.this.tableTotal.setRowHeight(font.getSize() + 6);
            }
        });
        this.tableFiles.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ProjectFrame.this.gotoFile(ProjectFrame.this.tableFiles.rowAtPoint(mouseEvent.getPoint()));
            }
        });
        this.tableFiles.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    ProjectFrame.this.gotoFile(ProjectFrame.this.tableFiles.getSelectedRow());
                    keyEvent.consume();
                }
            }
        });
    }

    private void initWindowLayout() {
        try {
            String string = Preferences.getPreference("project_files_window_x");
            String string2 = Preferences.getPreference("project_files_window_y");
            int n = Integer.parseInt(string);
            int n2 = Integer.parseInt(string2);
            this.setLocation(n, n2);
            String string3 = Preferences.getPreference("project_files_window_width");
            String string4 = Preferences.getPreference("project_files_window_height");
            int n3 = Integer.parseInt(string3);
            int n4 = Integer.parseInt(string4);
            this.setSize(n3, n4);
        }
        catch (NumberFormatException numberFormatException) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setBounds((dimension.width - 600) / 2, (dimension.height - 400) / 2, 600, 400);
        }
    }

    private void saveWindowLayout() {
        Preferences.setPreference("project_files_window_width", this.getWidth());
        Preferences.setPreference("project_files_window_height", this.getHeight());
        Preferences.setPreference("project_files_window_x", this.getX());
        Preferences.setPreference("project_files_window_y", this.getY());
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        int n = windowEvent.getID();
        if (n == 201 || n == 202) {
            this.saveWindowLayout();
        }
        super.processWindowEvent(windowEvent);
    }

    private void doCancel() {
        this.setVisible(false);
    }

    public void buildDisplay() {
        String string;
        UIThreadsUtil.mustBeSwingThread();
        String string2 = Core.getProject().getProjectProperties().getProjectInternal() + "project_stats.txt";
        File file = new File(string2);
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file.getAbsolutePath();
        }
        String string3 = MessageFormat.format(OStrings.getString("PF_STAT_PATH"), string);
        this.statLabel.setText(string3);
        this.files = Core.getProject().getProjectFiles();
        this.modelFiles.fireTableDataChanged();
        String string4 = Core.getEditor().getCurrentFile();
        List<IProject.FileInfo> list = this.files;
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get((int)i).filePath.equals(string4)) continue;
            this.tableFiles.getSelectionModel().setSelectionInterval(i, i);
            this.tableFiles.scrollRectToVisible(this.tableFiles.getCellRect(i, 0, true));
            break;
        }
        this.uiUpdateImportButtonStatus();
    }

    private void buildTotalTableLayout() {
        this.scrollFiles.setBorder(BorderFactory.createEmptyBorder());
        Border border = this.scrollFiles.getBorder();
        Insets insets = border.getBorderInsets(this.tableFiles);
        int n = this.scrollFiles.getVerticalScrollBar().isVisible() ? this.scrollFiles.getVerticalScrollBar().getWidth() : 0;
        GridBagLayout gridBagLayout = (GridBagLayout)this.getContentPane().getLayout();
        GridBagConstraints gridBagConstraints = gridBagLayout.getConstraints(this.tableTotal);
        gridBagConstraints.insets = new Insets(0, insets.left, 0, n);
        gridBagLayout.setConstraints(this.tableTotal, gridBagConstraints);
    }

    private void createTableFiles() {
        this.tableFiles = new JTable();
        this.tableFiles.setForeground(COLOR_STANDARD_FG);
        this.tableFiles.setBackground(COLOR_STANDARD_BG);
        this.tableFiles.setSelectionForeground(COLOR_SELECTION_FG);
        this.tableFiles.setSelectionBackground(COLOR_SELECTION_BG);
        this.modelFiles = new AbstractTableModel(){

            public Object getValueAt(int n, int n2) {
                IProject.FileInfo fileInfo;
                try {
                    fileInfo = (IProject.FileInfo)ProjectFrame.this.files.get(n);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    return null;
                }
                switch (n2) {
                    case 0: {
                        return fileInfo.filePath;
                    }
                    case 1: {
                        return fileInfo.size;
                    }
                }
                return null;
            }

            public int getColumnCount() {
                return 2;
            }

            public int getRowCount() {
                return ProjectFrame.this.files.size();
            }
        };
        this.tableFiles.setModel(this.modelFiles);
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        TableColumn tableColumn = new TableColumn(0, 300);
        tableColumn.setHeaderValue(OStrings.getString("PF_FILENAME"));
        tableColumn.setCellRenderer(new CustomRenderer(2, null, true));
        TableColumn tableColumn2 = new TableColumn(1, 50);
        tableColumn2.setHeaderValue(OStrings.getString("PF_NUM_SEGMENTS"));
        tableColumn2.setCellRenderer(new CustomRenderer(4, ",##0", true));
        defaultTableColumnModel.addColumn(tableColumn);
        defaultTableColumnModel.addColumn(tableColumn2);
        this.tableFiles.setColumnModel(defaultTableColumnModel);
        this.tableFiles.setSelectionMode(1);
    }

    private void createTableTotal() {
        this.tableTotal = new JTable();
        this.tableTotal.setForeground(COLOR_STANDARD_FG);
        this.tableTotal.setBackground(COLOR_STANDARD_BG);
        this.tableTotal.setSelectionForeground(COLOR_SELECTION_FG);
        this.tableTotal.setSelectionBackground(COLOR_SELECTION_BG);
        this.modelTotal = new AbstractTableModel(){

            public Object getValueAt(int n, int n2) {
                if (n2 == 0) {
                    switch (n) {
                        case 0: {
                            return OStrings.getString("GUI_PROJECT_TOTAL_SEGMENTS");
                        }
                        case 1: {
                            return OStrings.getString("GUI_PROJECT_UNIQUE_SEGMENTS");
                        }
                        case 2: {
                            return OStrings.getString("GUI_PROJECT_TRANSLATED");
                        }
                    }
                } else {
                    StatisticsInfo statisticsInfo = Core.getProject().getStatistics();
                    switch (n) {
                        case 0: {
                            return statisticsInfo.numberOfSegmentsTotal;
                        }
                        case 1: {
                            return statisticsInfo.numberOfUniqueSegments;
                        }
                        case 2: {
                            return statisticsInfo.numberofTranslatedSegments;
                        }
                    }
                }
                return null;
            }

            public int getColumnCount() {
                return 2;
            }

            public int getRowCount() {
                return 3;
            }
        };
        this.tableTotal.setModel(this.modelTotal);
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        TableColumn tableColumn = new TableColumn(0, 300);
        tableColumn.setCellRenderer(new CustomRenderer(2, null, false));
        TableColumn tableColumn2 = new TableColumn(1, 50);
        tableColumn2.setCellRenderer(new CustomRenderer(4, ",##0", false));
        defaultTableColumnModel.addColumn(tableColumn);
        defaultTableColumnModel.addColumn(tableColumn2);
        this.tableTotal.setColumnModel(defaultTableColumnModel);
        this.tableTotal.setBorder(BorderFactory.createEmptyBorder(50, 5, 10, 5));
        this.tableFiles.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnMarginChanged(ChangeEvent changeEvent) {
                ProjectFrame.this.changeTotalColumns();
            }

            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
                ProjectFrame.this.tableTotal.getColumnModel().moveColumn(tableColumnModelEvent.getFromIndex(), tableColumnModelEvent.getToIndex());
                ProjectFrame.this.changeTotalColumns();
            }

            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }
        });
        this.tableFiles.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                ProjectFrame.this.changeTotalColumns();
            }
        });
    }

    private void changeTotalColumns() {
        for (int i = 0; i < this.tableFiles.getColumnCount(); ++i) {
            TableColumn tableColumn = this.tableFiles.getColumnModel().getColumn(i);
            TableColumn tableColumn2 = this.tableTotal.getColumnModel().getColumn(i);
            tableColumn2.setMaxWidth(tableColumn.getWidth());
            tableColumn2.setMinWidth(tableColumn.getWidth());
            tableColumn2.setPreferredWidth(tableColumn.getWidth());
        }
    }

    private void doImportSourceFiles() {
        this.m_parent.doImportSourceFiles();
    }

    private void doWikiImport() {
        this.m_parent.doWikiImport();
    }

    public void uiUpdateImportButtonStatus() {
        this.m_addNewFileButton.setEnabled(Core.getProject().isProjectLoaded());
        this.m_wikiImportButton.setEnabled(Core.getProject().isProjectLoaded());
    }

    private void gotoFile(int n) {
        IProject.FileInfo fileInfo;
        try {
            fileInfo = this.files.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return;
        }
        int n2 = fileInfo.firstEntryIndex - fileInfo.size + 1;
        Core.getEditor().gotoEntry(n2);
        Core.getEditor().requestFocus();
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (Preferences.isPreference("project_files_use_font")) {
            String string = Preferences.getPreference("source_font");
            int n = Integer.valueOf(Preferences.getPreference("source_font_size"));
            this.tableFiles.setFont(new Font(string, 0, n));
            this.tableTotal.setFont(new Font(string, 1, n));
            this.tableFiles.setRowHeight(n + 6);
            this.tableTotal.setRowHeight(n + 6);
        }
    }

    private class CustomRenderer
    extends DefaultTableCellRenderer {
        protected DecimalFormat pattern;
        private boolean showCurrentFile;

        public CustomRenderer(int n, String string, boolean bl) {
            this.setHorizontalAlignment(n);
            this.showCurrentFile = bl;
            if (string != null) {
                this.pattern = new DecimalFormat(string);
            }
        }

        protected void setValue(Object object) {
            if (this.pattern != null) {
                super.setValue(this.pattern.format((Number)object));
            } else {
                super.setValue(object);
            }
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (this.showCurrentFile) {
                IProject.FileInfo fileInfo;
                try {
                    fileInfo = (IProject.FileInfo)ProjectFrame.this.files.get(n);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    fileInfo = null;
                }
                if (bl) {
                    super.setForeground(jTable.getSelectionForeground());
                    super.setBackground(jTable.getSelectionBackground());
                } else {
                    super.setForeground(jTable.getForeground());
                    super.setBackground(jTable.getBackground());
                }
                if (fileInfo != null && fileInfo.filePath.equals(Core.getEditor().getCurrentFile())) {
                    component.setForeground(COLOR_CURRENT_FG);
                    component.setBackground(COLOR_CURRENT_BG);
                }
            }
            return component;
        }
    }
}

