/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.filters2;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.filters2.master.OneFilter;
import org.omegat.gui.filters2.FilterEditor;
import org.omegat.util.OStrings;
import org.openide.awt.Mnemonics;

public class FiltersCustomizer
extends JDialog
implements ListSelectionListener {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JTextArea description;
    private JButton editButton;
    private JScrollPane filtersScrollPane;
    private JTable filtersTable;
    private JLabel jLabel1;
    private JButton okButton;
    private JButton optionsButton;
    private JButton toDefaultsButton;
    private int returnStatus = 0;

    public FiltersCustomizer(Frame frame) {
        super(frame, true);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                FiltersCustomizer.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(keyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", abstractAction);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        this.filtersTable.setModel(FilterMaster.getInstance().getFilters());
        this.filtersTable.getSelectionModel().addListSelectionListener(this);
        Dimension dimension = this.filtersTable.getPreferredSize();
        dimension.height += 70;
        this.filtersScrollPane.setPreferredSize(dimension);
        this.pack();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension3 = this.getSize();
        this.setLocation((dimension2.width - dimension3.width) / 2, (dimension2.height - dimension3.height) / 2);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (listSelectionModel.isSelectionEmpty()) {
            this.editButton.setEnabled(false);
            this.optionsButton.setEnabled(false);
        } else {
            this.editButton.setEnabled(true);
            this.optionsButton.setEnabled(FilterMaster.getInstance().getFilters().getFilter(this.filtersTable.getSelectedRow()).hasOptions());
        }
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.toDefaultsButton = new JButton();
        this.jLabel1 = new JLabel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.filtersScrollPane = new JScrollPane();
        this.filtersTable = new JTable();
        this.description = new JTextArea();
        this.editButton = new JButton();
        this.optionsButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle(OStrings.getString("FILTERSCUSTOMIZER_TITLE"));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                FiltersCustomizer.this.closeDialog(windowEvent);
            }
        });
        this.buttonPanel.setLayout(new FlowLayout(2));
        Mnemonics.setLocalizedText((AbstractButton)this.toDefaultsButton, (String)OStrings.getString("BUTTON_TO_DEFAULTS"));
        this.toDefaultsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FiltersCustomizer.this.toDefaultsButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.toDefaultsButton);
        this.jLabel1.setPreferredSize(new Dimension(20, 0));
        this.buttonPanel.add(this.jLabel1);
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FiltersCustomizer.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.okButton);
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FiltersCustomizer.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.filtersScrollPane.setViewportView(this.filtersTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.filtersScrollPane, gridBagConstraints);
        this.description.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.description.setEditable(false);
        this.description.setFont(new JLabel().getFont());
        this.description.setLineWrap(true);
        this.description.setText(OStrings.getString("FILTERSCUSTOMIZER_DESCRIPTION"));
        this.description.setWrapStyleWord(true);
        this.description.setBorder(new EmptyBorder(new Insets(3, 3, 3, 3)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.description, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.editButton, (String)OStrings.getString("BUTTON_EDIT"));
        this.editButton.setToolTipText(OStrings.getString("FILTERSCUSTOMIZER_BUTTON_EDIT_HINT"));
        this.editButton.setEnabled(false);
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FiltersCustomizer.this.editButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.editButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.optionsButton, (String)OStrings.getString("FILTERSCUSTOMIZER_BUTTON_OPTIONS"));
        this.optionsButton.setEnabled(false);
        this.optionsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FiltersCustomizer.this.optionsButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.optionsButton, gridBagConstraints);
        this.pack();
    }

    private void optionsButtonActionPerformed(ActionEvent actionEvent) {
        OneFilter oneFilter = FilterMaster.getInstance().getFilters().getFilter(this.filtersTable.getSelectedRow());
        oneFilter.changeOptions(this);
    }

    private void toDefaultsButtonActionPerformed(ActionEvent actionEvent) {
        FilterMaster.getInstance().revertFiltersConfigToDefaults();
        this.filtersTable.setModel(FilterMaster.getInstance().getFilters());
    }

    private void editButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.filtersTable.getSelectedRow();
        FilterEditor filterEditor = new FilterEditor((Dialog)this, FilterMaster.getInstance().getFilters(), n);
        filterEditor.setVisible(true);
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose(0);
    }

    private void doClose(int n) {
        this.returnStatus = n;
        this.setVisible(false);
        this.dispose();
    }
}

