/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.main;

import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.omegat.core.Core;
import org.omegat.core.data.ProjectFactory;
import org.omegat.core.data.ProjectProperties;
import org.omegat.gui.dialogs.NewProjectFileChooser;
import org.omegat.gui.dialogs.ProjectPropertiesDialog;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.ProjectFileStorage;
import org.omegat.util.gui.OpenProjectFileChooser;
import org.omegat.util.gui.SwingWorker;
import org.omegat.util.gui.UIThreadsUtil;

public class ProjectUICommands {
    public static void projectCreate() {
        UIThreadsUtil.mustBeSwingThread();
        if (Core.getProject().isProjectLoaded()) {
            return;
        }
        NewProjectFileChooser newProjectFileChooser = new NewProjectFileChooser();
        int n = newProjectFileChooser.showSaveDialog(Core.getMainWindow().getApplicationFrame());
        if (n != 0) {
            return;
        }
        File file = newProjectFileChooser.getSelectedFile();
        file.mkdirs();
        ProjectPropertiesDialog projectPropertiesDialog = new ProjectPropertiesDialog(new ProjectProperties(file), file.getAbsolutePath(), 1);
        projectPropertiesDialog.setVisible(true);
        projectPropertiesDialog.dispose();
        final ProjectProperties projectProperties = projectPropertiesDialog.getResult();
        if (projectProperties == null) {
            file.delete();
            return;
        }
        String string = projectProperties.getProjectRoot();
        if (string != null && string.length() > 0) {
            new SwingWorker<Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    ProjectFactory.createProject(projectProperties);
                    Core.getProject().saveProjectProperties();
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        this.get();
                    }
                    catch (Exception exception) {
                        Log.logErrorRB(exception, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                        Core.getMainWindow().displayErrorRB(exception, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                    }
                }
            }.execute();
        }
    }

    public static void projectOpen() {
        ProjectProperties projectProperties;
        UIThreadsUtil.mustBeSwingThread();
        if (Core.getProject().isProjectLoaded()) {
            return;
        }
        OpenProjectFileChooser openProjectFileChooser = new OpenProjectFileChooser();
        if (0 != openProjectFileChooser.showOpenDialog(Core.getMainWindow().getApplicationFrame())) {
            return;
        }
        File file = openProjectFileChooser.getSelectedFile();
        try {
            projectProperties = ProjectFileStorage.loadProjectProperties(file);
        }
        catch (Exception exception) {
            Log.logErrorRB(exception, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
            Core.getMainWindow().displayErrorRB(exception, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
            return;
        }
        boolean bl = false;
        while (!projectProperties.verifyProject()) {
            bl = true;
            ProjectPropertiesDialog projectPropertiesDialog = new ProjectPropertiesDialog(projectProperties, new File(file, "omegat.project").getAbsolutePath(), 2);
            projectPropertiesDialog.setVisible(true);
            projectProperties = projectPropertiesDialog.getResult();
            projectPropertiesDialog.dispose();
            if (projectProperties != null) continue;
            return;
        }
        final boolean bl2 = bl;
        final ProjectProperties projectProperties2 = projectProperties;
        new SwingWorker<Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                ProjectFactory.loadProject(projectProperties2);
                if (bl2) {
                    Core.getProject().saveProjectProperties();
                }
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (Exception exception) {
                    Log.logErrorRB(exception, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                    Core.getMainWindow().displayErrorRB(exception, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                }
            }
        }.execute();
    }

    public static void projectReload() {
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Core.getEditor().commitAndDeactivate();
        final ProjectProperties projectProperties = Core.getProject().getProjectProperties();
        new SwingWorker<Object>(){
            int previousCurEntryNum = Core.getEditor().getCurrentEntryNumber();

            @Override
            protected Object doInBackground() throws Exception {
                Core.getProject().saveProject();
                ProjectFactory.closeProject();
                ProjectFactory.loadProject(projectProperties);
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Core.getEditor().gotoEntry(previousCurEntryNum);
                        }
                    });
                }
                catch (Exception exception) {
                    Log.logErrorRB(exception, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                    Core.getMainWindow().displayErrorRB(exception, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                }
            }
        }.execute();
    }

    public static void projectSave() {
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Core.getEditor().commitAndLeave();
        new SwingWorker<Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                Core.getMainWindow().showStatusMessageRB("MW_STATUS_SAVING", new Object[0]);
                Core.getProject().saveProject();
                Core.getMainWindow().showStatusMessageRB("MW_STATUS_SAVED", new Object[0]);
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (Exception exception) {
                    Log.logErrorRB(exception, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                    Core.getMainWindow().displayErrorRB(exception, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                }
            }
        }.execute();
    }

    public static void projectClose() {
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Core.getEditor().commitAndLeave();
        new SwingWorker<Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                Core.getMainWindow().showStatusMessageRB("MW_STATUS_SAVING", new Object[0]);
                Preferences.save();
                Core.getProject().saveProject();
                Core.getMainWindow().showStatusMessageRB("MW_STATUS_SAVED", new Object[0]);
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                    ProjectFactory.closeProject();
                }
                catch (Exception exception) {
                    Log.logErrorRB(exception, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                    Core.getMainWindow().displayErrorRB(exception, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                }
            }
        }.execute();
    }

    public static void projectEditProperties() {
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Core.getEditor().commitAndLeave();
        ProjectPropertiesDialog projectPropertiesDialog = new ProjectPropertiesDialog(Core.getProject().getProjectProperties(), Core.getProject().getProjectProperties().getProjectName(), 3);
        projectPropertiesDialog.setVisible(true);
        final ProjectProperties projectProperties = projectPropertiesDialog.getResult();
        projectPropertiesDialog.dispose();
        if (projectProperties == null) {
            return;
        }
        int n = JOptionPane.showConfirmDialog(Core.getMainWindow().getApplicationFrame(), OStrings.getString("MW_REOPEN_QUESTION"), OStrings.getString("MW_REOPEN_TITLE"), 0);
        if (n != 0) {
            return;
        }
        new SwingWorker<Object>(){
            int previousCurEntryNum = Core.getEditor().getCurrentEntryNumber() + 1;

            @Override
            protected Object doInBackground() throws Exception {
                Core.getProject().saveProject();
                ProjectFactory.closeProject();
                ProjectFactory.loadProject(projectProperties);
                Core.getProject().saveProjectProperties();
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                    Core.getEditor().gotoEntry(this.previousCurEntryNum);
                }
                catch (Exception exception) {
                    Log.logErrorRB(exception, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                    Core.getMainWindow().displayErrorRB(exception, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                }
            }
        }.execute();
    }

    public static void projectCompile() {
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Core.getEditor().commitAndLeave();
        new SwingWorker<Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                Core.getProject().saveProject();
                Core.getProject().compileProject();
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (Exception exception) {
                    Log.logErrorRB(exception, "TF_COMPILE_ERROR", new Object[0]);
                    Core.getMainWindow().displayErrorRB(exception, "TF_COMPILE_ERROR", new Object[0]);
                }
            }
        }.execute();
    }
}

