/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.matches;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.omegat.core.Core;
import org.omegat.core.data.LegacyTM;
import org.omegat.core.data.StringEntry;
import org.omegat.core.matching.FuzzyMatcher;
import org.omegat.core.matching.ISimilarityCalculator;
import org.omegat.core.matching.ITokenizer;
import org.omegat.core.matching.LevenshteinDistance;
import org.omegat.core.matching.NearString;
import org.omegat.gui.matches.MatchesTextArea;
import org.omegat.util.StringUtil;
import org.omegat.util.Token;

public class FindMatchesThread
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(FindMatchesThread.class.getName());
    private final MatchesTextArea matcherController;
    private final StringEntry processedEntry;
    private List<NearString> result = new ArrayList<NearString>(6);
    private ISimilarityCalculator distance = new LevenshteinDistance();
    private Token[] strTokensStem;
    private Token[] strTokensNoStem;
    private Token[] strTokensAll;

    public FindMatchesThread(MatchesTextArea matchesTextArea, StringEntry stringEntry) {
        this.matcherController = matchesTextArea;
        this.processedEntry = stringEntry;
    }

    public void run() {
        List<StringEntry> list = Core.getProject().getUniqueEntries();
        List<LegacyTM> list2 = Core.getProject().getMemory();
        if (list == null || list2 == null) {
            this.clear();
            return;
        }
        long l = 0L;
        if (LOGGER.isLoggable(Level.FINER)) {
            l = System.currentTimeMillis();
        }
        this.strTokensStem = Core.getTokenizer().tokenizeWords(this.processedEntry.getSrcText(), ITokenizer.StemmingMode.MATCHING);
        if (this.strTokensStem.length == 0) {
            this.clear();
            return;
        }
        this.strTokensNoStem = Core.getTokenizer().tokenizeWords(this.processedEntry.getSrcText(), ITokenizer.StemmingMode.NONE);
        this.strTokensAll = Core.getTokenizer().tokenizeAllExactly(this.processedEntry.getSrcText());
        for (StringEntry object : list) {
            if (this.matcherController.processedEntry != this.processedEntry) {
                return;
            }
            if (StringUtil.isEmpty(object.getTranslation()) || object == this.processedEntry) continue;
            this.processEntry(object, null);
        }
        for (LegacyTM legacyTM : list2) {
            for (StringEntry stringEntry : legacyTM.getStrings()) {
                if (this.matcherController.processedEntry != this.processedEntry) {
                    return;
                }
                if (StringUtil.isEmpty(stringEntry.getTranslation())) continue;
                this.processEntry(stringEntry, legacyTM.getName());
            }
        }
        for (NearString nearString : this.result) {
            Object object = FuzzyMatcher.buildSimilarityData(this.strTokensAll, Core.getTokenizer().tokenizeAllExactly(nearString.str.getSrcText()));
            nearString.attr = (byte[])object;
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            long l2 = System.currentTimeMillis();
            LOGGER.finer("Time for find matches: " + (l2 - l));
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (((FindMatchesThread)FindMatchesThread.this).matcherController.processedEntry == FindMatchesThread.this.processedEntry) {
                    FindMatchesThread.this.matcherController.setMatches(FindMatchesThread.this.result);
                }
            }
        });
    }

    private void clear() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (((FindMatchesThread)FindMatchesThread.this).matcherController.processedEntry == FindMatchesThread.this.processedEntry) {
                    FindMatchesThread.this.matcherController.clear();
                }
            }
        });
    }

    protected void processEntry(StringEntry stringEntry, String string) {
        Token[] tokenArray = Core.getTokenizer().tokenizeWords(stringEntry.getSrcText(), ITokenizer.StemmingMode.MATCHING);
        if (tokenArray.length == 0) {
            return;
        }
        int n = FuzzyMatcher.calcSimilarity(this.distance, this.strTokensStem, tokenArray);
        if (n < 30) {
            return;
        }
        Token[] tokenArray2 = Core.getTokenizer().tokenizeWords(stringEntry.getSrcText(), ITokenizer.StemmingMode.NONE);
        int n2 = FuzzyMatcher.calcSimilarity(this.distance, this.strTokensNoStem, tokenArray2);
        if (this.haveChanceToAdd(n, n2)) {
            Token[] tokenArray3 = Core.getTokenizer().tokenizeAllExactly(stringEntry.getSrcText());
            int n3 = FuzzyMatcher.calcSimilarity(this.distance, this.strTokensAll, tokenArray3);
            this.addNearString(stringEntry, n, n2, n3, null, string);
        }
    }

    protected boolean haveChanceToAdd(int n, int n2) {
        if (this.result.size() < 5) {
            return true;
        }
        NearString nearString = this.result.get(this.result.size() - 1);
        if (nearString.score < n) {
            return true;
        }
        if (nearString.score > n) {
            return false;
        }
        return nearString.scoreNoStem <= n2;
    }

    protected void addNearString(StringEntry stringEntry, int n, int n2, int n3, byte[] byArray, String string) {
        int n4 = 0;
        for (int i = 0; i < this.result.size(); ++i) {
            NearString nearString = this.result.get(i);
            if (nearString.score < n || nearString.score == n && (nearString.scoreNoStem < n2 || nearString.scoreNoStem == n2 && nearString.adjustedScore < n3)) break;
            n4 = i + 1;
        }
        this.result.add(n4, new NearString(stringEntry, n, n2, n3, byArray, string));
        if (this.result.size() > 5) {
            this.result.remove(this.result.size() - 1);
        }
    }
}

