/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.stat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.omegat.core.Core;
import org.omegat.core.statistics.CalcMatchStatistics;
import org.omegat.core.statistics.CalcStandardStatistics;
import org.omegat.core.threads.LongProcessThread;
import org.omegat.util.OStrings;
import org.omegat.util.gui.DockingUI;

public class StatisticsWindow
extends JDialog {
    private JProgressBar progressBar = new JProgressBar();
    private JTextArea output = new JTextArea();
    private LongProcessThread thread;

    public StatisticsWindow(STAT_TYPE sTAT_TYPE) {
        super((Frame)Core.getMainWindow().getApplicationFrame(), true);
        switch (sTAT_TYPE) {
            case STANDARD: {
                this.setTitle(OStrings.getString("CT_STATSSTANDARD_WindowHeader"));
                this.thread = new CalcStandardStatistics(this);
                break;
            }
            case MATCHES: {
                this.setTitle(OStrings.getString("CT_STATSMATCH_WindowHeader"));
                this.thread = new CalcMatchStatistics(this);
            }
        }
        this.thread.setPriority(1);
        this.thread.start();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add(jPanel);
        this.progressBar.setStringPainted(true);
        jPanel.add((Component)this.progressBar, "South");
        this.output.setEditable(false);
        this.output.setFont(new Font("Monospaced", 0, Core.getMainWindow().getApplicationFont().getSize()));
        jPanel.add((Component)new JScrollPane(this.output), "Center");
        this.setDefaultCloseOperation(2);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatisticsWindow.this.thread.fin();
                StatisticsWindow.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(keyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", abstractAction);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                StatisticsWindow.this.thread.fin();
            }
        });
        this.setSize(400, 300);
        DockingUI.displayCentered(this);
    }

    public void showProgress(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StatisticsWindow.this.progressBar.setValue(n);
                StatisticsWindow.this.progressBar.setString(n + "%");
            }
        });
    }

    public void displayData(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StatisticsWindow.this.progressBar.setValue(100);
                StatisticsWindow.this.progressBar.setString("");
                StatisticsWindow.this.progressBar.setVisible(false);
                StatisticsWindow.this.output.setText(string);
                StatisticsWindow.this.output.setCaretPosition(0);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum STAT_TYPE {
        STANDARD,
        MATCHES;

    }
}

