/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.tagvalidation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.regex.Matcher;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.StringEntry;
import org.omegat.core.events.IFontChangedEventListener;
import org.omegat.gui.HListener;
import org.omegat.gui.main.MainWindow;
import org.omegat.util.OStrings;
import org.omegat.util.PatternConsts;
import org.omegat.util.Preferences;
import org.openide.awt.Mnemonics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagValidationFrame
extends JFrame {
    private JEditorPane m_editorPane;
    private List<SourceTextEntry> stringList;

    public TagValidationFrame(MainWindow mainWindow) {
        this.setTitle(OStrings.getString("TF_NOTICE_BAD_TAGS"));
        this.initWindowLayout();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                TagValidationFrame.this.doCancel();
            }
        };
        this.getRootPane().getInputMap(2).put(keyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", abstractAction);
        JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)OStrings.getString("BUTTON_CLOSE"));
        jButton.addActionListener(abstractAction);
        this.m_editorPane = new JEditorPane();
        this.m_editorPane.setEditable(false);
        this.m_editorPane.addHyperlinkListener(new HListener(mainWindow, true));
        JScrollPane jScrollPane = new JScrollPane(this.m_editorPane);
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(jButton);
        box.add(Box.createHorizontalGlue());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.getContentPane().add((Component)box, "South");
        CoreEvents.registerFontChangedEventListener(new IFontChangedEventListener(){

            public void onFontChanged(Font font) {
                TagValidationFrame.this.setFont(font);
            }
        });
        this.setFont(Core.getMainWindow().getApplicationFont());
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.isVisible()) {
            this.update();
        }
    }

    private void initWindowLayout() {
        try {
            String string = Preferences.getPreference("tagv_window_x");
            String string2 = Preferences.getPreference("tagv_window_y");
            int n = Integer.parseInt(string);
            int n2 = Integer.parseInt(string2);
            this.setLocation(n, n2);
            String string3 = Preferences.getPreference("tagv_window_width");
            String string4 = Preferences.getPreference("tagv_window_height");
            int n3 = Integer.parseInt(string3);
            int n4 = Integer.parseInt(string4);
            this.setSize(n3, n4);
        }
        catch (NumberFormatException numberFormatException) {
            this.setSize(650, 700);
        }
    }

    private void saveWindowLayout() {
        Preferences.setPreference("tagv_window_width", this.getWidth());
        Preferences.setPreference("tagv_window_height", this.getHeight());
        Preferences.setPreference("tagv_window_x", this.getX());
        Preferences.setPreference("tagv_window_y", this.getY());
    }

    @Override
    public void processWindowEvent(WindowEvent windowEvent) {
        int n = windowEvent.getID();
        if (n == 201 || n == 202) {
            this.saveWindowLayout();
        }
        super.processWindowEvent(windowEvent);
    }

    private void doCancel() {
        this.dispose();
    }

    private String htmlize(String string) {
        String string2 = string;
        string2 = string2.replaceAll("\\<", "&lt;");
        string2 = string2.replaceAll("\\>", "&gt;");
        string2 = string2.replaceAll("\n", "<br>");
        return string2;
    }

    private String colorTags(String string, String string2) {
        Matcher matcher = PatternConsts.OMEGAT_HTML_TAG.matcher(string);
        string = matcher.replaceAll("<font color=\"" + string2 + "\"><b>$1</b></font>");
        Matcher matcher2 = PatternConsts.HTML_BR.matcher(string);
        string = matcher2.replaceAll("<font color=\"" + string2 + "\"><sup>L</sup>F<br></font>");
        Matcher matcher3 = PatternConsts.PRINTF_VARS.matcher(string);
        string = matcher3.replaceAll("<font color=\"" + string2 + "\"><b>$0</b></font>");
        return string;
    }

    public void displayStringList(List<SourceTextEntry> list) {
        this.stringList = list;
        this.update();
    }

    private void update() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>\n");
        stringBuffer.append("<head>\n");
        stringBuffer.append("<style>\n");
        stringBuffer.append("<style type=\"text/css\">\n");
        stringBuffer.append("    <!--\n");
        stringBuffer.append("    body {\n");
        stringBuffer.append("            font-family: " + this.getFont().getName() + ";\n");
        stringBuffer.append("            font-size: " + this.getFont().getSize() + "pt;\n");
        stringBuffer.append("    }\n");
        stringBuffer.append("    -->\n");
        stringBuffer.append("</style>\n");
        stringBuffer.append("</head>\n");
        stringBuffer.append("<body>\n");
        stringBuffer.append("<table BORDER COLS=3 WIDTH=\"100%\" NOSAVE>\n");
        for (SourceTextEntry sourceTextEntry : this.stringList) {
            StringEntry stringEntry = sourceTextEntry.getStrEntry();
            String string = stringEntry.getSrcText();
            String string2 = stringEntry.getTranslation();
            if (string.length() <= 0 || string2.length() <= 0) continue;
            int n = sourceTextEntry.entryNum() + 1;
            stringBuffer.append("<tr>");
            stringBuffer.append("<td>");
            stringBuffer.append("<a href=");
            stringBuffer.append("\"");
            stringBuffer.append(n);
            stringBuffer.append("\"");
            stringBuffer.append(">");
            stringBuffer.append(n);
            stringBuffer.append("</a>");
            stringBuffer.append("</td>");
            stringBuffer.append("<td>");
            stringBuffer.append(this.colorTags(this.htmlize(string), "blue"));
            stringBuffer.append("</td>");
            stringBuffer.append("<td>");
            stringBuffer.append(this.colorTags(this.htmlize(string2), "blue"));
            stringBuffer.append("</td>");
            stringBuffer.append("</tr>\n");
        }
        stringBuffer.append("</table>\n");
        stringBuffer.append("</body>\n");
        stringBuffer.append("</html>\n");
        this.m_editorPane.setContentType("text/html");
        this.m_editorPane.setText(stringBuffer.toString());
    }
}

