/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryMonitor
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(DirectoryMonitor.class.getName());
    private boolean stopped = false;
    protected final File dir;
    protected final Callback callback;
    private final Map<String, FileInfo> existFiles = new TreeMap<String, FileInfo>();
    protected static final long LOOKUP_PERIOD = 1000L;

    public DirectoryMonitor(File file, Callback callback) {
        this.dir = file;
        this.callback = callback;
    }

    public File getDir() {
        return this.dir;
    }

    public void fin() {
        this.stopped = true;
    }

    @Override
    public void run() {
        this.setName(this.getClass().getSimpleName());
        this.setPriority(1);
        while (!this.stopped) {
            Object object;
            File file;
            for (String string : new ArrayList<String>(this.existFiles.keySet())) {
                if (this.stopped) {
                    return;
                }
                file = new File(string);
                if (!file.exists()) {
                    LOGGER.finer("File '" + file + "' removed");
                    this.existFiles.remove(string);
                    this.callback.fileChanged(file);
                    continue;
                }
                object = new FileInfo(file);
                if (((FileInfo)object).equals(this.existFiles.get(string))) continue;
                LOGGER.finer("File '" + file + "' changed");
                this.existFiles.put(string, (FileInfo)object);
                this.callback.fileChanged(file);
            }
            ArrayList arrayList = new ArrayList();
            this.readDir(this.dir, arrayList);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                file = (File)iterator.next();
                if (this.stopped) {
                    return;
                }
                object = file.getPath();
                if (this.existFiles.keySet().contains(object)) continue;
                LOGGER.finer("File '" + file + "' added");
                this.existFiles.put((String)object, new FileInfo(file));
                this.callback.fileChanged(file);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                this.stopped = true;
            }
        }
    }

    protected void readDir(File file, List<File> list) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    this.readDir(file2, list);
                    continue;
                }
                list.add(file2);
            }
        }
    }

    public static interface Callback {
        public void fileChanged(File var1);
    }

    protected class FileInfo {
        public long lastModified;
        public long length;

        public FileInfo(File file) {
            this.lastModified = file.lastModified();
            this.length = file.length();
        }

        public boolean equals(Object object) {
            FileInfo fileInfo = (FileInfo)object;
            return this.lastModified == fileInfo.lastModified && this.length == fileInfo.length;
        }
    }
}

