/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades;

import java.awt.Toolkit;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.instrument.Instrumentation;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;
import jp.sourceforge.mergedoc.pleiades.PleiadesOption;
import jp.sourceforge.mergedoc.pleiades.aspect.Analyses;
import jp.sourceforge.mergedoc.pleiades.aspect.Asyncs;
import jp.sourceforge.mergedoc.pleiades.aspect.LauncherTransformer;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.log.PopupFileLogger;
import jp.sourceforge.mergedoc.pleiades.resource.Files;
import jp.sourceforge.mergedoc.pleiades.resource.PropertySet;

public class Pleiades {
    private static Logger log;
    public static final String PACKAGE_NAME;
    private static OS os;
    private static PleiadesOption pleiadesOption;
    private static File pleiadesConfigurationPath;
    private static File eclipseHome;
    private static Instrumentation instrumentation;

    static {
        PACKAGE_NAME = Pleiades.class.getPackage().getName();
    }

    public static void premain(String option, Instrumentation inst) throws Throwable {
        long start = System.nanoTime();
        try {
            instrumentation = inst;
            pleiadesOption = new PleiadesOption(option);
            Pleiades.init();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        try {
            if (os == OS.WINDOWS) {
                Asyncs.execute(new Runnable(){

                    public void run() {
                        try {
                            Pleiades.initSwingFont();
                        }
                        catch (Throwable e) {
                            log.debug("Swing \u306e LookAndFeel \u8a2d\u5b9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + e, new Object[0]);
                        }
                    }
                });
            } else if (os == OS.MAC) {
                pleiadesOption.setNoMnemonic(true);
            }
            Analyses.end(Pleiades.class, "premain", start);
            inst.addTransformer(new LauncherTransformer());
            log.info("Pleiades AOP \u7ffb\u8a33\u30b3\u30f3\u30c6\u30ca\u30fc\u3092\u958b\u59cb\u3057\u307e\u3057\u305f\u3002Pleiades \u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3:" + option, new Object[0]);
        }
        catch (Throwable e) {
            log.fatal(e, "Pleiades AOP \u7ffb\u8a33\u30b3\u30f3\u30c6\u30ca\u30fc\u306e\u8d77\u52d5\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\n\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3\u306b -clean \u3092\u6307\u5b9a\u3057\u3066\u8d77\u52d5\u3057\u3066\u304f\u3060\u3055\u3044\u3002", new Object[0]);
            System.exit(-1);
        }
    }

    private static void init() throws UnsupportedEncodingException {
        File baseDir;
        String base;
        Matcher mat;
        long start = System.nanoTime();
        String osName = System.getProperty("os.name", "").toLowerCase();
        os = osName.contains("mac") ? OS.MAC : (osName.contains("windows") ? OS.WINDOWS : OS.LINUX);
        File configIniFile = Pleiades.getConfigIniFile();
        File configPath = configIniFile.getParentFile();
        eclipseHome = configPath.getParentFile();
        String CONFIG_AREA_KEY = "osgi.configuration.area";
        PropertySet configIni = new PropertySet(configIniFile);
        String configArea = (String)configIni.get("osgi.configuration.area");
        if (configArea == null) {
            configArea = System.getProperty("osgi.configuration.area");
        }
        File userConfigPath = null;
        if (configArea != null && (mat = Pattern.compile("^@([\\w\\.]+)(.+)$").matcher(configArea)).find() && (base = System.getProperty(mat.group(1))) != null && (baseDir = new File(base)).exists()) {
            String childPath = mat.group(2);
            userConfigPath = new File(baseDir, childPath);
        }
        if (userConfigPath != null) {
            configPath = userConfigPath;
            pleiadesConfigurationPath = new File(configPath, PACKAGE_NAME);
        } else if (os == OS.WINDOWS) {
            pleiadesConfigurationPath = new File(configPath, PACKAGE_NAME);
        } else {
            File base2 = new File(System.getProperty("user.home"), ".eclipse/" + PACKAGE_NAME);
            String instPath = eclipseHome.getPath().replace("/", "-");
            pleiadesConfigurationPath = new File(base2, instPath);
        }
        pleiadesConfigurationPath.mkdirs();
        File logFile = new File(pleiadesConfigurationPath, "pleiades.log");
        Logger.init(PopupFileLogger.class, pleiadesOption.getLogLevel(), logFile);
        log = Logger.getLogger(Pleiades.class);
        log.info("Pleiades \u69cb\u6210\u4fdd\u7ba1\u30d1\u30b9: " + pleiadesConfigurationPath, new Object[0]);
        log.info("Eclipse \u30db\u30fc\u30e0: " + eclipseHome, new Object[0]);
        Analyses.end(Pleiades.class, "init", start);
    }

    private static File getConfigIniFile() {
        File pleiadesDir;
        String CONFIG_INI = "config.ini";
        String CONFIG_DIR_INI = "configuration/config.ini";
        File configIniFile = new File(System.getProperty("user.dir"), "configuration/config.ini");
        if (configIniFile.exists()) {
            return configIniFile;
        }
        File dir = pleiadesDir = Files.resourceRoot.getParentFile().getParentFile().getParentFile();
        while (dir != null) {
            configIniFile = new File(dir, "configuration/config.ini");
            if (configIniFile.exists()) {
                return configIniFile;
            }
            dir = dir.getParentFile();
        }
        dir = pleiadesDir;
        while (dir != null) {
            File[] fileArray = dir.listFiles(Files.createDirectoryFilter());
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File d = fileArray[n2];
                configIniFile = new File(d, "config.ini");
                if (configIniFile.exists()) {
                    return configIniFile;
                }
                ++n2;
            }
            dir = dir.getParentFile();
        }
        throw new IllegalStateException("config.ini \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
    }

    private static void initSwingFont() throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        long start = System.nanoTime();
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        FontUIResource propoFont = new FontUIResource("MS UI Gothic", 0, 12);
        FontUIResource fixedFont = new FontUIResource("MS Gothic", 0, 12);
        for (Object keyObj : UIManager.getLookAndFeelDefaults().keySet()) {
            String key = keyObj.toString();
            if (!key.endsWith("font") && !key.endsWith("Font")) continue;
            UIManager.put(key, propoFont);
        }
        UIManager.put("TextPane.font", fixedFont);
        UIManager.put("TextArea.font", fixedFont);
        Analyses.end(Pleiades.class, "initSwingFont<THREAD>", start);
    }

    public static Instrumentation getInstrumentation() {
        return instrumentation;
    }

    public static PleiadesOption getPleiadesOption() {
        return pleiadesOption;
    }

    public static File getResourceFile(String path) {
        return new File(pleiadesConfigurationPath, path);
    }

    public static File getEclipseHome() {
        return eclipseHome;
    }

    public static boolean isWindows() {
        return os == OS.WINDOWS;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum OS {
        LINUX,
        MAC,
        WINDOWS;

    }
}

