/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.JointPoint;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.DynamicTranslationDictionary;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.HelpHtmlParser;
import jp.sourceforge.mergedoc.pleiades.resource.Mnemonics;

public class Translations {
    private static final Logger log = Logger.getLogger(Translations.class);
    private static final DynamicTranslationDictionary dictionary = DynamicTranslationDictionary.getInstance();
    private static final Map<String, String> backupMap = new HashMap<String, String>();

    private Translations() {
    }

    public static String translate(String en, JointPoint jointPoint) {
        if (en == null) {
            return null;
        }
        return dictionary.lookup(en, jointPoint);
    }

    public static String[] translate(String[] ens, JointPoint jointPoint) {
        if (ens == null) {
            return null;
        }
        int i = 0;
        while (i < ens.length) {
            ens[i] = Translations.translate(ens[i], jointPoint);
            ++i;
        }
        return ens;
    }

    public static Object translate(Object en, JointPoint jointPoint) {
        if (en == null) {
            return null;
        }
        if (en instanceof String) {
            return Translations.translate((String)en, jointPoint);
        }
        if (en instanceof String[]) {
            return Translations.translate((String[])en, jointPoint);
        }
        if (en instanceof Object[]) {
            return Translations.translate((Object[])en, jointPoint);
        }
        return en;
    }

    public static Object[] translate(Object[] enObjs, JointPoint jointPoint) {
        if (enObjs instanceof String[]) {
            return Translations.translate((String[])enObjs, jointPoint);
        }
        return enObjs;
    }

    public static String translateMenu(String en, JointPoint jointPoint) {
        if (en == null) {
            return null;
        }
        String[] splitsAccelerator = en.split("\t");
        String enMenuText = splitsAccelerator[0];
        if (splitsAccelerator.length == 1) {
            return dictionary.lookup(enMenuText, jointPoint);
        }
        return String.valueOf(dictionary.lookup(enMenuText, jointPoint)) + "\t" + splitsAccelerator[1];
    }

    public static String translateIgnoreMnemonic(String en, JointPoint jointPoint) {
        if (en == null) {
            return null;
        }
        return dictionary.lookupIgnoreMnemonic(en, jointPoint);
    }

    public static String translateBackup(String en, JointPoint jointPoint) {
        if (en == null) {
            return null;
        }
        String ja = dictionary.lookup(en, jointPoint);
        backupMap.put(ja, en);
        return ja;
    }

    public static String translateBackupIgnoreMnemonic(String en, JointPoint jointPoint) {
        if (en == null) {
            return null;
        }
        String ja = dictionary.lookupIgnoreMnemonic(en, jointPoint);
        backupMap.put(ja, en);
        return ja;
    }

    public static String[] translateBackupIgnoreMnemonic(String[] ens, JointPoint jointPoint) {
        if (ens == null) {
            return null;
        }
        int i = 0;
        while (i < ens.length) {
            ens[i] = Translations.translateBackupIgnoreMnemonic(ens[i], jointPoint);
            ++i;
        }
        return ens;
    }

    public static String restore(String ja, JointPoint jointPoint) {
        if (ja == null) {
            return null;
        }
        String en = backupMap.get(ja);
        if (en == null) {
            return ja;
        }
        return en;
    }

    public static String translateSentence(String en, JointPoint jointPoint) {
        if (en == null) {
            return null;
        }
        if (en.contains(" ")) {
            return dictionary.lookup(en, jointPoint);
        }
        return en;
    }

    public static String translateWithoutJaMnemonic(String en, JointPoint jointPoint) {
        if (en == null) {
            return null;
        }
        en = Mnemonics.removeJaMnemonic(en);
        return dictionary.lookupIgnoreMnemonic(en, jointPoint);
    }

    /*
     * Unable to fully structure code
     */
    public static String translateKeepLength(String en, JointPoint jointPoint) {
        if (en == null) {
            return null;
        }
        ja = Translations.dictionary.lookup(en, jointPoint);
        if (ja.length() <= en.length()) ** GOTO lbl7
        return en;
lbl-1000:
        // 1 sources

        {
            ja = String.valueOf(ja) + " ";
lbl7:
            // 2 sources

            ** while (ja.length() < en.length())
        }
lbl8:
        // 1 sources

        return ja;
    }

    public static InputStream translateHelp(InputStream enIs, JointPoint jointPoint) {
        if (!log.isDebugEnabled()) {
            return enIs;
        }
        if (enIs == null) {
            return null;
        }
        HelpHtmlParser parser = new HelpHtmlParser(enIs);
        for (HelpHtmlParser.HtmlFragment f : parser) {
            String en = f.getText();
            String ja = dictionary.lookupHelp(en, jointPoint);
            f.setText(ja);
        }
        return parser.getInputStream();
    }

    public static void debug(Object obj) {
        StringBuilder sb = new StringBuilder();
        sb.append("Translations#debug ");
        if (obj != null) {
            sb.append(obj.getClass().getName());
        }
        sb.append("[");
        sb.append(obj);
        sb.append("]");
        log.info(sb.toString(), new Object[0]);
    }

    public static void debug(Object en, JointPoint jointPoint) {
        StringBuilder sb = new StringBuilder();
        sb.append("Translations#debug ");
        if (jointPoint != null) {
            sb.append("(");
            sb.append(jointPoint.getClassName());
            sb.append("#");
            sb.append(jointPoint.getMethodName());
            sb.append(") ");
        }
        if (en != null) {
            sb.append(en.getClass().getName());
        }
        sb.append("[");
        sb.append(en);
        sb.append("] -> [");
        sb.append(Translations.translate(en, jointPoint));
        sb.append("]");
        log.info(sb.toString(), new Object[0]);
    }

    public static void debug(Object en, JointPoint jointPoint, String key) {
        StringBuilder sb = new StringBuilder();
        sb.append("Translations#debug ");
        if (jointPoint != null) {
            sb.append("(");
            sb.append(jointPoint.getClassName());
            sb.append("#");
            sb.append(jointPoint.getMethodName());
            sb.append(") ");
        }
        if (en != null) {
            sb.append(en.getClass().getName());
        }
        sb.append("[");
        sb.append(en);
        sb.append("] -> [");
        sb.append(Translations.translate(en, jointPoint));
        sb.append("]");
        sb.append(" key=");
        sb.append(key);
        log.info(sb.toString(), new Object[0]);
    }

    public static void debug(String[] ens, JointPoint jointPoint) {
        StringBuilder sb = new StringBuilder();
        sb.append("Translations#debug ");
        if (jointPoint != null) {
            sb.append("(");
            sb.append(jointPoint.getClassName());
            sb.append("#");
            sb.append(jointPoint.getMethodName());
            sb.append(") ");
        }
        if (ens != null) {
            sb.append(ens.getClass().getName());
        }
        sb.append(Arrays.asList(ens));
        sb.append(" -> ");
        sb.append(Arrays.asList(Translations.translate(ens, jointPoint)));
        log.info(sb.toString(), new Object[0]);
    }

    public static void printStackTrace(Object obj, JointPoint jointPoint) {
        log.info(new Exception(), "Translator#debug " + (obj == null ? "" : obj.getClass().getName()) + "[" + obj + "] -> [" + Translations.translate(obj, jointPoint) + "]", new Object[0]);
    }
}

