/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.generator;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.mergedoc.pleiades.generator.AbstractValidator;
import jp.sourceforge.mergedoc.pleiades.generator.ValidationResult;
import jp.sourceforge.mergedoc.pleiades.resource.Mnemonics;
import jp.sourceforge.mergedoc.pleiades.resource.Property;
import jp.sourceforge.mergedoc.pleiades.resource.PropertySet;
import jp.sourceforge.mergedoc.pleiades.resource.TranslationString;

public class Validator
extends AbstractValidator {
    private final Map<String, AbstractValidator.ValidationContext> validatedMap = new HashMap<String, AbstractValidator.ValidationContext>();
    private final Set<String> regexThroughSet = new PropertySet("translation-regex-through.properties").keySet();

    public Validator(PropertySet ... existsProps) {
        super(existsProps);
    }

    public Validator(String logFileName, PropertySet ... existsProps) {
        super(logFileName, existsProps);
    }

    public PropertySet remove(PropertySet prop) {
        PropertySet outProp = new PropertySet();
        for (Property p : prop) {
            if (!this.validate(p).isSuccess()) continue;
            outProp.put(p);
        }
        this.logEndMessage("\u691c\u51fa\u3055\u308c\u305f\u30a8\u30e9\u30fc\u30fb\u8b66\u544a\u3092\u524a\u9664\u3057\u307e\u3057\u305f\u3002");
        return outProp;
    }

    public void validate(PropertySet prop) {
        for (Property p : prop) {
            this.validate(p);
        }
        this.logEndMessage("\u691c\u8a3c\u7d50\u679c");
    }

    public ValidationResult validate(Property p) {
        return this.validate(p, "");
    }

    public ValidationResult validate(Property p, String name) {
        int eqc;
        int jqc;
        AbstractValidator.ValidationContext validatedVc;
        String en = TranslationString.trim(p.key);
        String ja = TranslationString.trim(p.value);
        AbstractValidator.ValidationContext vc = this.createValidationContext(en, ja, name);
        if (vIgnoreSet.contains(en)) {
            return vc;
        }
        if (en.equals("") || ja.equals("")) {
            vc.warn("\u30a8\u30f3\u30c8\u30ea\u30fc\u304c\u7a7a\u3067\u3059\u3002");
            return vc;
        }
        if (ja.equals(en)) {
            vc.warn("\u7ffb\u8a33\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return vc;
        }
        if (this.isForbidden(en)) {
            vc.error("\u3053\u306e\u8a33\u306f\u7ffb\u8a33\u304c\u8a31\u53ef\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002\u3053\u306e\u30a8\u30f3\u30c8\u30ea\u30fc\u3092\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            return vc;
        }
        String jaExists = (String)this.existsProp.get(en);
        if (jaExists != null) {
            if (jaExists.equals(ja)) {
                vc.info("\u65e2\u5b58\u306e\u6821\u6b63\u6e08\u307f\u8a00\u8a9e\u30d1\u30c3\u30af\u8f9e\u66f8\u306b\u540c\u4e00\u306e\u8a33\u304c\u5b58\u5728\u3057\u307e\u3059\u3002");
            } else {
                vc.error("\u65e2: " + jaExists + "\n" + "\u65e2\u5b58\u306e\u6821\u6b63\u6e08\u307f\u8a00\u8a9e\u30d1\u30c3\u30af\u8f9e\u66f8\u306b\u7570\u306a\u308b\u8a33\u304c\u5b58\u5728\u3057\u307e\u3059\u3002" + "\u65e2\u5b58\u8a33\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            }
        }
        if ((validatedVc = this.validatedMap.get(en)) != null) {
            if (ja.equals(validatedVc.ja)) {
                if (name.equals(validatedVc.name)) {
                    vc.info("\u7ffb\u8a33\u30c8\u30ea\u30e0\u3059\u308b\u3068\u3001\u540c\u3058\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u30fb\u30d5\u30a1\u30a4\u30eb\u5185\u306b\u540c\u3058\u8a33\u304c\u5b58\u5728\u3057\u307e\u3059\u3002");
                } else {
                    vc.info("\u5225\u306e\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc " + validatedVc.name + " \u306b\u540c\u3058\u8a33\u304c\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059\u3002");
                }
            } else if (name.equals(validatedVc.name)) {
                vc.error("\u7570: " + Property.escapeValue(validatedVc.ja) + "\n" + "\u7ffb\u8a33\u30c8\u30ea\u30e0\u3059\u308b\u3068\u3001\u540c\u3058\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u30fb\u30d5\u30a1\u30a4\u30eb\u5185\u306b\u7570\u306a\u308b\u8a33\u304c\u5b58\u5728\u3057\u307e\u3059\u3002" + "\u8a33\u3092\u7d71\u4e00\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            } else {
                vc.error("\u7570: " + Property.escapeValue(validatedVc.ja) + "\n" + "\u5225\u306e\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u306b\u7570\u306a\u308b\u8a33\u304c\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059\u3002" + validatedVc.name);
            }
        }
        this.validatedMap.put(en, vc);
        this.validateSuffix(en, ja, vc);
        if (ja.startsWith("=") && !en.contains("=")) {
            vc.error("\u8a33\u6587\u306e\u5148\u982d\u306b\u4e0d\u8981\u306a\u300c=\u300d\u304c\u3042\u308a\u307e\u3059\u3002");
        }
        for (Pattern pat : ADJACENT_WORD_SPACE_PATTERN_LIST) {
            Matcher mat = pat.matcher(ja);
            while (mat.find()) {
                vc.error("\u82f1\u6570\u5b57\u306b\u96a3\u63a5\u3059\u308b\u5168\u89d2\u6587\u5b57\u306e\u9593\u306b\u534a\u89d2\u30b9\u30da\u30fc\u30b9\u304c\u5fc5\u8981\u3067\u3059\u3002\u2192" + mat.group());
            }
        }
        String iParam = this.getIllegalBindParameter(en, ja);
        if (iParam != null) {
            vc.error("\u539f\u6587\u306b\u542b\u307e\u308c\u308b " + iParam + " \u304c\u8a33\u6587\u306b\u3082\u5fc5\u8981\u3067\u3059\u3002");
        }
        int eCount = en.length() - en.replace("\n", "").length();
        int jCount = ja.length() - ja.replace("\n", "").length();
        if (eCount < 10 && eCount != jCount) {
            vc.error("\u6539\u884c\u6587\u5b57 \\n \u306e\u6570\u304c\u7570\u306a\u308a\u307e\u3059\u3002\u539f\u6587:" + eCount + " \u8a33\u6587:" + jCount);
        }
        if (ja.contains("''")) {
            jqc = (" " + ja + " ").split("'").length - 1;
            eqc = (" " + en + " ").split("'").length - 1;
            if (jqc % 2 == 1 && jqc != eqc) {
                vc.error("\u30b7\u30f3\u30b0\u30eb\u30fb\u30af\u30a9\u30fc\u30c8\u306e\u6570\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            }
        }
        if (ja.contains("\"\"")) {
            jqc = (" " + ja + " ").split("\"").length - 1;
            eqc = (" " + en + " ").split("\"").length - 1;
            if (jqc % 2 == 1 && jqc != eqc) {
                vc.error("\u30c0\u30d6\u30eb\u30fb\u30af\u30a9\u30fc\u30c8\u306e\u6570\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            }
        }
        for (Property vTerm : vTermProp) {
            String ng = vTerm.key;
            String ok = vTerm.value;
            if (!ja.matches("(?s).*?" + ng + ".*")) continue;
            if (ok.equals("")) {
                vc.error("\u300c" + ng + "\u300d\u306f\u4f7f\u7528\u7981\u6b62\u3067\u3059\u3002");
                continue;
            }
            vc.error("\u300c" + ng + "\u300d\u306f\u300c" + ok + "\u300d\u3067\u3042\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002");
        }
        Property iProp = this.getIllegalTranslationProperty(en, ja);
        if (iProp != null) {
            vc.error("\u300c" + iProp.key + "\u300d\u306f\u300c" + iProp.value + "\u300d\u3068\u5bfe\u5fdc\u3057\u3066\u3044\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002");
        }
        if (Mnemonics.containsUrlParameters(en)) {
            vc.error("& \u3092\u542b\u3080\u30d1\u30e9\u30e1\u30fc\u30bf\u30fc\u4ed8\u304d URL \u304c\u542b\u307e\u308c\u3066\u308b\u30a8\u30f3\u30c8\u30ea\u30fc\u306f\u8ffd\u52a0\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        if (en.matches("\\p{Punct}+")) {
            vc.error("\u539f\u6587\u304c\u8a18\u53f7\u306e\u307f\u3067\u69cb\u6210\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u4e0d\u6b63\u30a8\u30f3\u30c8\u30ea\u30fc?");
        }
        for (String t : this.regexThroughSet) {
            if (!en.matches(t)) continue;
            vc.error("\u7ffb\u8a33\u30b9\u30eb\u30fc\u6b63\u898f\u8868\u73fe\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u306b\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u3059\u3002" + t);
        }
        return vc;
    }

    protected void validateSuffix(String en, String ja, AbstractValidator.ValidationContext vc) {
        if (en.contains("...") && !ja.contains("...") && !ja.contains("\u3001\u3001\u3001") && !ja.contains("\u304b\u3089")) {
            vc.error("\u539f\u6587\u306b\u300c...\u300d\u304c\u542b\u307e\u308c\u308b\u5834\u5408\u306f\u3001\u8a33\u6587\u306b\u3082\u300c...\u300d\u304c\u5fc5\u8981\u3067\u3059\u3002");
        }
        if (!en.contains("...") && en.endsWith("..") && !ja.endsWith("..")) {
            vc.error("\u539f\u6587\u306e\u672b\u5c3e\u306b\u300c..\u300d\u304c\u3042\u308b\u5834\u5408\u306f\u3001\u8a33\u6587\u306e\u672b\u5c3e\u306b\u3082\u300c..\u300d\u304c\u5fc5\u8981\u3067\u3059\u3002");
        } else if (!en.endsWith("..") && en.endsWith(".") && !ja.endsWith("\u3002")) {
            if (en.contains(" ") && !en.contains(":") && !TranslationString.endsWithAbbreviations(en)) {
                vc.warn("\u539f\u6587\u672b\u5c3e\u306b\u3042\u308b\u300c.\u300d\u304c\u53e5\u70b9\u3092\u8868\u3059\u5834\u5408\u306f\u3001\u8a33\u6587\u306e\u672b\u5c3e\u306b\u3082\u300c\u3002\u300d\u304c\u5fc5\u8981\u3067\u3059\u3002");
            }
        } else if (en.endsWith(":") && !ja.endsWith(":")) {
            vc.error("\u539f\u6587\u306e\u672b\u5c3e\u306b\u300c:\u300d\u304c\u3042\u308b\u5834\u5408\u306f\u3001\u8a33\u6587\u306e\u672b\u5c3e\u306b\u3082\u300c:\u300d\u304c\u5fc5\u8981\u3067\u3059\u3002");
        }
    }
}

