/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.generator.nls;

import jp.sourceforge.mergedoc.pleiades.generator.AbstractValidator;
import jp.sourceforge.mergedoc.pleiades.generator.ValidationResult;
import jp.sourceforge.mergedoc.pleiades.generator.Validator;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.Property;
import jp.sourceforge.mergedoc.pleiades.resource.PropertySet;

public class J10nHelpValidator
extends Validator {
    private static final boolean isLogEscape = false;
    private String transNote;

    public J10nHelpValidator(String logFileName, PropertySet ... existsProps) {
        super(logFileName, existsProps);
    }

    protected Logger.Level getLogFileLogLevel() {
        return Logger.Level.ERROR;
    }

    public ValidationResult validate(Property p, String name) {
        this.transNote = "";
        String[] stringArray = new String[]{"\u25c6", "\u25b2"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String pattern = "(?s)(.*?)(" + s + "(.+?)" + s + ".+?\u3011)(.*)";
            while (p.value.matches(pattern)) {
                this.transNote = String.valueOf(this.transNote) + p.value.replaceFirst(pattern, "$2");
                p.value = p.value.replaceFirst(pattern, "$1$3$4");
            }
            ++n2;
        }
        String pattern = "(?s).*[\u300c>](.+?\u2605).*";
        while (p.value.matches(pattern)) {
            this.transNote = String.valueOf(this.transNote) + p.value.replaceFirst(pattern, "$1");
            p.value = p.value.replaceFirst("\u2605", "");
        }
        pattern = "(?s)(.*?)(\u3010.+?\u3011)(.*)";
        while (p.value.matches(pattern)) {
            this.transNote = String.valueOf(this.transNote) + p.value.replaceFirst(pattern, "$2");
            p.value = p.value.replaceFirst(pattern, "$1$3");
        }
        return super.validate(p, name);
    }

    protected void validateSuffix(String en, String ja, AbstractValidator.ValidationContext vc) {
    }

    protected Property getIllegalTranslationProperty(String en, String ja) {
        Property p = super.getIllegalTranslationProperty(en, ja);
        if (p != null && p.value.contains("\u30fb\u30d3\u30e5\u30fc") && ja.contains("\u300d\u30d3\u30e5\u30fc")) {
            return null;
        }
        return p;
    }

    protected AbstractValidator.ValidationContext createValidationContext(String en, String ja, String name) {
        return new J10nHelpValidationContext(en, ja, name);
    }

    protected class J10nHelpValidationContext
    extends AbstractValidator.ValidationContext {
        public J10nHelpValidationContext(String en, String ja, String name) {
            super(en, ja, name);
        }

        protected String formatMessage(String msg) {
            String e = this.en;
            String j = this.ja;
            StringBuilder m = new StringBuilder("\n");
            m.append("\u82f1: " + e + "\n");
            m.append("\u65e5: " + j + "\n");
            if (!J10nHelpValidator.this.transNote.equals("")) {
                m.append("\u8a33\u6ce8: " + J10nHelpValidator.this.transNote + "\n");
            }
            m.append("\u5185\u5bb9: " + msg + "\n");
            if (this.name != null && !this.name.equals("")) {
                m.insert(0, this.name);
            }
            String indent = "      ";
            return m.toString().replace("\n", "\n" + indent);
        }
    }
}

