/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.logmessage.task;

import java.io.IOException;

import blanco.logmessage.task.valueobject.BlancoLogMessageProcessInput;

/**
 * ob`NX [BlancoLogMessageBatchProcess]B
 *
 * <P>ob`̌ĂяoB</P>
 * <code>
 * java -classpath (NXpX) blanco.logmessage.task.BlancoLogMessageBatchProcess -help
 * </code>
 */
public class BlancoLogMessageBatchProcess {
    /**
     * IB
     */
    public static final int END_SUCCESS = 0;

    /**
     * ُ͈IBIjava.lang.IllegalArgumentExceptionꍇB
     */
    public static final int END_ILLEGAL_ARGUMENT_EXCEPTION = 7;

    /**
     * o͗OIBIjava.io.IOExceptionꍇB
     */
    public static final int END_IO_EXCEPTION = 8;

    /**
     * ُIBob`̏JnɎsꍇAѓIjava.lang.Error܂java.lang.RuntimeExceptionꍇB
     */
    public static final int END_ERROR = 9;

    /**
     * R}hCsꂽۂ̃Gg|CgłB
     *
     * @param args R\[pꂽB
     */
    public static final void main(final String[] args) {
        final BlancoLogMessageBatchProcess batchProcess = new BlancoLogMessageBatchProcess();

        // ob`̈B
        final BlancoLogMessageProcessInput input = new BlancoLogMessageProcessInput();

        boolean isNeedUsage = false;
        boolean isFieldMetadirProcessed = false;

        // R}hC̉͂Ȃ܂B
        for (int index = 0; index < args.length; index++) {
            String arg = args[index];
            if (arg.startsWith("-verbose=")) {
                input.setVerbose(Boolean.valueOf(arg.substring(9)).booleanValue());
            } else if (arg.startsWith("-metadir=")) {
                input.setMetadir(arg.substring(9));
                isFieldMetadirProcessed = true;
            } else if (arg.startsWith("-targetdir=")) {
                input.setTargetdir(arg.substring(11));
            } else if (arg.startsWith("-tmpdir=")) {
                input.setTmpdir(arg.substring(8));
            } else if (arg.startsWith("-encoding=")) {
                input.setEncoding(arg.substring(10));
            } else if (arg.startsWith("-targetlang=")) {
                input.setTargetlang(arg.substring(12));
            } else if (arg.startsWith("-targetLogger=")) {
                input.setTargetLogger(arg.substring(14));
            } else if (arg.equals("-?") || arg.equals("-help")) {
                usage();
                System.exit(END_SUCCESS);
            } else {
                System.out.println("BlancoLogMessageBatchProcess: ̓p[^[" + arg + "]͖܂B");
                isNeedUsage = true;
            }
        }

        if (isNeedUsage) {
            usage();
        }

        if( isFieldMetadirProcessed == false) {
            System.out.println("BlancoLogMessageBatchProcess: JnsB̓p[^[input]̕K{tB[hl[metadir]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }

        int retCode = batchProcess.execute(input);

        // IR[h߂܂B
        // ӁFSystem.exit()ĂяoĂ_ɒӂĂB
        System.exit(retCode);
    }

    /**
     * ̓Iȃob`eLq邽߂̃\bhłB
     *
     * ̃\bhɎۂ̏eLq܂B
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IOException o͗OꍇB
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public int process(final BlancoLogMessageProcessInput input) throws IOException, IllegalArgumentException {
        // ̓p[^`FbN܂B
        validateInput(input);

        // ̉ӏŃRpCG[ꍇABlancoLogMessageProcessC^tF[X blanco.logmessage.taskpbP[W BlancoLogMessageProcessImplNX쐬邱Ƃɂłꍇ܂B
        final BlancoLogMessageProcess process = new BlancoLogMessageProcessImpl();

        // ̖{̂s܂B
        final int retCode = process.execute(input);

        return retCode;
    }

    /**
     * NXCX^Xăob`sۂ̃Gg|CgłB
     *
     * ̃\bh͉L̎dl񋟂܂B
     * <ul>
     * <li>\bh̓̓p[^̓e`FbNB
     * <li>IllegalArgumentException, RuntimeException, ErrorȂǂ̗OcatchĖ߂lւƕϊB
     * </ul>
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public final int execute(final BlancoLogMessageProcessInput input) throws IllegalArgumentException {
        try {
            // ob`̖{̂s܂B
            int retCode = process(input);

            return retCode;
        } catch (IllegalArgumentException ex) {
            System.out.println("BlancoLogMessageBatchProcess: ͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_ILLEGAL_ARGUMENT_EXCEPTION;
        } catch (IOException ex) {
            System.out.println("BlancoLogMessageBatchProcess: o͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_IO_EXCEPTION;
        } catch (RuntimeException ex) {
            System.out.println("BlancoLogMessageBatchProcess: ^CO܂Bob`𒆒f܂B:" + ex.toString());
            ex.printStackTrace();
            // ُIB
            return END_ERROR;
        } catch (Error er) {
            System.out.println("BlancoLogMessageBatchProcess: ^CG[܂Bob`𒆒f܂B:" + er.toString());
            er.printStackTrace();
            // ُIB
            return END_ERROR;
        }
    }

    /**
     * ̃ob`NX̎g̐Wo͂Ɏ߂̃\bhłB
     */
    public static final void usage() {
        System.out.println("BlancoLogMessageBatchProcess: Usage:");
        System.out.println("  java blanco.logmessage.task.BlancoLogMessageBatchProcess -verbose=l1 -metadir=l2 -targetdir=l3 -tmpdir=l4 -encoding=l5 -targetlang=l6 -targetLogger=l7");
        System.out.println("    -verbose");
        System.out.println("      [verbose[hœ삳邩ǂB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[false]");
        System.out.println("    -metadir");
        System.out.println("      [^fBNgBxlst@C̊i[܂ xmlt@C̊i[w肵܂B]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -targetdir");
        System.out.println("      [o͐tH_w肵܂Bw̏ꍇɂ̓Jgblancop܂B]");
        System.out.println("      ^[]");
        System.out.println("      ftHgl[blanco]");
        System.out.println("    -tmpdir");
        System.out.println("      [e|fBNgw肵܂Bw̏ꍇɂ̓Jgtmpp܂B]");
        System.out.println("      ^[]");
        System.out.println("      ftHgl[tmp]");
        System.out.println("    -encoding");
        System.out.println("      [\[Xt@C̕GR[fBOw肵܂B]");
        System.out.println("      ^[]");
        System.out.println("    -targetlang");
        System.out.println("      [^[QbgƂȂvO~OꏈnBJava ̂ݑΉBΉ cs, js, vb,php,ruby,pythonB]");
        System.out.println("      ^[]");
        System.out.println("      ftHgl[java]");
        System.out.println("    -targetLogger");
        System.out.println("      [^[QbgƂȂ郍K[Borg.apache.log4j w\B]");
        System.out.println("      ^[]");
        System.out.println("      ftHgl[java.util.logging]");
        System.out.println("    -? , -help");
        System.out.println("      [g\܂B]");
    }

    /**
     * ̃ob`NX̓̓p[^̑Ó`FbN{邽߂̃\bhłB
     *
     * @param input ob`̓̓p[^B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public void validateInput(final BlancoLogMessageProcessInput input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException("BlancoBatchProcessBatchProcess: JnsB̓p[^[input]null^܂B");
        }
        if (input.getMetadir() == null) {
            throw new IllegalArgumentException("BlancoLogMessageBatchProcess: JnsB̓p[^[input]̕K{tB[hl[metadir]ɒlݒ肳Ă܂B");
        }
    }
}
