/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.omegat.util.task;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.omegat.core.data.LegacyTM;
import org.omegat.core.data.StringEntry;
import org.omegat.core.data.StringEntryWrapper;
import org.omegat.core.matching.FuzzyMatcherWrapper;
import org.omegat.core.matching.NearString;
import org.omegat.util.Language;
import org.omegat.util.TMXReader;

import blanco.commons.util.BlancoStringUtil;
import blanco.omegat.util.task.valueobject.BlancoOmegatTranslateXliffProcessInput;
import blanco.xliff.BlancoXliffUtil;
import blanco.xliff.valueobject.BlancoXliff;
import blanco.xliff.valueobject.BlancoXliffAltTrans;
import blanco.xliff.valueobject.BlancoXliffFile;
import blanco.xliff.valueobject.BlancoXliffTarget;
import blanco.xliff.valueobject.BlancoXliffTransUnit;

public class BlancoOmegatTranslateXliffProcessImpl implements
        BlancoOmegatTranslateXliffProcess {
    private BlancoOmegatTranslateXliffProcessInput fInput = null;

    public int execute(final BlancoOmegatTranslateXliffProcessInput input)
            throws IOException, IllegalArgumentException {
        fInput = input;

        // OmegaTWrapper.getCommandThread();

        final File dirTmx = new File(fInput.getTmxdir());
        if (dirTmx.exists() == false) {
            throw new IllegalArgumentException("w肳ꂽ tmxdir["
                    + dirTmx.getAbsolutePath() + "]݂͑܂B");
        }
        if (dirTmx.isDirectory() == false) {
            throw new IllegalArgumentException("w肳ꂽ tmxdir["
                    + dirTmx.getAbsolutePath() + "]̓fBNgł͂܂B");
        }

        // xliffdir, xlifffile rK{Őݒ肳Ă邱Ƃ`FbNB
        if (BlancoStringUtil.null2Blank(fInput.getXliffdir()).length() == 0) {
            if (BlancoStringUtil.null2Blank(fInput.getXlifffile()).length() == 0) {
                throw new IllegalArgumentException(
                        "xliffdir, xlifffilêꂩ͎w肷Kv܂B");
            }
            // xlifffile ̃P[X
            final File file = new File(fInput.getXlifffile());
            if (file.exists() == false) {
                throw new IllegalArgumentException("w肳ꂽ xlifffile["
                        + file.getAbsolutePath() + "]݂͑܂B");
            }
            if (file.isFile() == false) {
                throw new IllegalArgumentException("w肳ꂽ xlifffile["
                        + file.getAbsolutePath() + "]̓t@Cł͂܂B");
            }
        } else {
            if (BlancoStringUtil.null2Blank(fInput.getXlifffile()).length() > 0) {
                throw new IllegalArgumentException(
                        "xliffdir, xlifffilêꂩ̂ݎw肷Kv܂B");
            }
            // xliffdir ̃P[X
            final File dir = new File(fInput.getXliffdir());
            if (dir.exists() == false) {
                throw new IllegalArgumentException("w肳ꂽ xliffdir["
                        + dir.getAbsolutePath() + "]݂͑܂B");
            }
            if (dir.isDirectory() == false) {
                throw new IllegalArgumentException("w肳ꂽ xliffdir["
                        + dir.getAbsolutePath() + "]̓fBNgł͂܂B");
            }
        }

        final List<StringEntry> tmxEntryList = loadTmx(dirTmx);
        progress("TMGg: " + tmxEntryList.size());
        if (tmxEntryList.size() == 0) {
            throw new IllegalArgumentException("TM1Ȃ̂ŏsł܂B");
        }
        translate(tmxEntryList);

        return 0;
    }

    private List<StringEntry> loadTmx(final File dirTmx) throws IOException {
        final TMXReader reader = new TMXReader("UTF-8", new Language("en_US"),
                new Language("ja_JP"), false);

        final File[] fileTmxs = dirTmx.listFiles();
        if (fileTmxs == null) {
            return new ArrayList<StringEntry>();
        }
        for (int index = 0; index < fileTmxs.length; index++) {
            final File fileTmx = fileTmxs[index];
            if (fileTmx.isFile() == false) {
                continue;
            }

            reader.loadFile(fileTmx.getAbsolutePath(), false);
        }

        final int num = reader.numSegments();
        final List<StringEntry> tmxEntryList = new ArrayList<StringEntry>(num);

        for (int i = 0; i < num; i++) {
            String src = reader.getSourceSegment(i);
            String trans = reader.getTargetSegment(i);

            StringEntryWrapper se = new StringEntryWrapper(src);
            se.setTranslation(trans);
            tmxEntryList.add(se);
        }

        return tmxEntryList;
    }

    private void translate(final List<StringEntry> tmxEntryList)
            throws IOException {
        if (BlancoStringUtil.null2Blank(fInput.getXliffdir()).length() > 0) {
            final File dirXliff = new File(fInput.getXliffdir());
            final File[] xliffFiles = dirXliff.listFiles();
            if (xliffFiles == null) {
                return;
            }
            for (int index = 0; index < xliffFiles.length; index++) {
                if (xliffFiles[index].isFile() == false) {
                    continue;
                }
                if (xliffFiles[index].getName().endsWith(".xlf")) {
                    processXliff(xliffFiles[index], tmxEntryList);
                }
            }
        } else {
            final File fileXliff = new File(fInput.getXlifffile());
            processXliff(fileXliff, tmxEntryList);
        }
    }

    private void processXliff(final File fileTarget,
            final List<StringEntry> tmxEntryList) throws IOException {
        final File dirTmx = new File(fInput.getTmxdir());

        final FuzzyMatcherWrapper fuzzyMatcher = FuzzyMatcherWrapper
                .getInstance();

        final String bundleSymbolicName = fileTarget.getName().substring(0,
                fileTarget.getName().length() - ".xlf".length());
        final BlancoXliff xliffTarget = BlancoXliffUtil.getXliffInstance(
                fileTarget.getParentFile(), bundleSymbolicName);

        int xliffCount = 0;
        for (int indexFile = 0; indexFile < xliffTarget.getFileList().size(); indexFile++) {
            progress(bundleSymbolicName + ": file: " + indexFile + " / "
                    + xliffTarget.getFileList().size());
            final BlancoXliffFile file = (BlancoXliffFile) xliffTarget
                    .getFileList().get(indexFile);
            for (int indexTransUnit = 0; indexTransUnit < file.getBody()
                    .getTransUnitList().size(); indexTransUnit++) {
                if (++xliffCount % 10 == 0) {
                    progress(bundleSymbolicName + ": " + xliffCount);
                }

                final BlancoXliffTransUnit targetUnit = (BlancoXliffTransUnit) file
                        .getBody().getTransUnitList().get(indexTransUnit);
                if (targetUnit.getTranslate() == false) {
                    continue;
                }
                if (BlancoStringUtil.null2Blank(targetUnit.getSource())
                        .length() == 0) {
                    continue;
                }
                if (targetUnit.getTarget() != null
                        && BlancoStringUtil.null2Blank(
                                targetUnit.getTarget().getTarget()).length() > 0) {
                    if (fInput.getSkipiftargetexist()) {
                        continue;
                    }
                }

                //  trans-unit }[W܂B
                final StringEntry tuEntry = new StringEntry(targetUnit
                        .getSource());
                LegacyTM legacyTm = new LegacyTM(dirTmx.getName(), tmxEntryList);
                List<LegacyTM> tmList = new ArrayList<LegacyTM>();
                tmList.add(legacyTm);
                List<NearString> nearList = fuzzyMatcher.match(tuEntry, tmList);

                if (nearList.size() > 0) {
                    for (int indexMatch = 0; indexMatch < nearList.size(); indexMatch++) {
                        final NearString nearString = nearList.get(indexMatch);

                        boolean isFound = false;
                        for (int index = 0; index < targetUnit
                                .getAltTransList().size(); index++) {
                            final BlancoXliffAltTrans altTrans = (BlancoXliffAltTrans) targetUnit
                                    .getAltTransList().get(index);
                            if (altTrans.getSource().equals(
                                    nearString.str.getSrcText())) {
                                isFound = true;
                            }
                        }
                        if (isFound == false) {
                            final BlancoXliffAltTrans altTrans = new BlancoXliffAltTrans();
                            targetUnit.getAltTransList().add(altTrans);
                            altTrans.setToolId(fInput.getToolId());
                            altTrans.setMatchQuality(String
                                    .valueOf(nearString.score)
                                    + "%");
                            altTrans.setOrigin(fInput.getOrigin());
                            altTrans.setSource(nearString.str.getSrcText());
                            final BlancoXliffTarget target = new BlancoXliffTarget();
                            altTrans.setTarget(target);
                            target.setTarget(nearString.str.getTranslation());
                        }
                    }
                }
            }
        }

        // }[Wʂۑ܂B
        switch (BlancoXliffUtil.saveXliffInstance(xliffTarget, fileTarget
                .getParentFile(), bundleSymbolicName)) {
        case 1:
            // {IɁAɂ͓Ȃ݁B
            progress("xliff: omegat: create: " + bundleSymbolicName);
            break;
        case 2:
            progress("xliff: omegat: update: " + bundleSymbolicName);
            break;
        case 0:
            progress("xliff: omegat: skip  : " + bundleSymbolicName);
            break;
        }

        progress("XLIFFGg: " + xliffCount);
    }

    /**
     * {@inheritDoc}
     */
    public boolean progress(final String argProgressMessage) {
        if (fInput != null && fInput.getVerbose()) {
            System.out.println(argProgressMessage);
        }
        return false;
    }
}
