/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.xliff.util.task;

import java.io.IOException;

import blanco.xliff.util.task.valueobject.BlancoXliffUtilExtractStateProcessInput;

/**
 * ob`NX [BlancoXliffUtilExtractStateBatchProcess]B
 *
 * <P>ob`̌ĂяoB</P>
 * <code>
 * java -classpath (NXpX) blanco.xliff.util.task.BlancoXliffUtilExtractStateBatchProcess -help
 * </code>
 */
public class BlancoXliffUtilExtractStateBatchProcess {
    /**
     * IB
     */
    public static final int END_SUCCESS = 0;

    /**
     * ُ͈IBIjava.lang.IllegalArgumentExceptionꍇB
     */
    public static final int END_ILLEGAL_ARGUMENT_EXCEPTION = 7;

    /**
     * o͗OIBIjava.io.IOExceptionꍇB
     */
    public static final int END_IO_EXCEPTION = 8;

    /**
     * ُIBob`̏JnɎsꍇAѓIjava.lang.Error܂java.lang.RuntimeExceptionꍇB
     */
    public static final int END_ERROR = 9;

    /**
     * R}hCsꂽۂ̃Gg|CgłB
     *
     * @param args R\[pꂽB
     */
    public static final void main(final String[] args) {
        final BlancoXliffUtilExtractStateBatchProcess batchProcess = new BlancoXliffUtilExtractStateBatchProcess();

        // ob`̈B
        final BlancoXliffUtilExtractStateProcessInput input = new BlancoXliffUtilExtractStateProcessInput();

        boolean isNeedUsage = false;
        boolean isFieldTargetfileProcessed = false;
        boolean isFieldXliffdirProcessed = false;
        boolean isFieldStateProcessed = false;

        // R}hC̉͂Ȃ܂B
        for (int index = 0; index < args.length; index++) {
            String arg = args[index];
            if (arg.startsWith("-verbose=")) {
                input.setVerbose(Boolean.valueOf(arg.substring(9)).booleanValue());
            } else if (arg.startsWith("-targetfile=")) {
                input.setTargetfile(arg.substring(12));
                isFieldTargetfileProcessed = true;
            } else if (arg.startsWith("-xliffdir=")) {
                input.setXliffdir(arg.substring(10));
                isFieldXliffdirProcessed = true;
            } else if (arg.startsWith("-state=")) {
                input.setState(arg.substring(7));
                isFieldStateProcessed = true;
            } else if (arg.equals("-?") || arg.equals("-help")) {
                usage();
                System.exit(END_SUCCESS);
            } else {
                System.out.println("BlancoXliffUtilExtractStateBatchProcess: ̓p[^[" + arg + "]͖܂B");
                isNeedUsage = true;
            }
        }

        if (isNeedUsage) {
            usage();
        }

        if( isFieldTargetfileProcessed == false) {
            System.out.println("BlancoXliffUtilExtractStateBatchProcess: JnsB̓p[^[input]̕K{tB[hl[targetfile]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldXliffdirProcessed == false) {
            System.out.println("BlancoXliffUtilExtractStateBatchProcess: JnsB̓p[^[input]̕K{tB[hl[xliffdir]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldStateProcessed == false) {
            System.out.println("BlancoXliffUtilExtractStateBatchProcess: JnsB̓p[^[input]̕K{tB[hl[state]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }

        int retCode = batchProcess.execute(input);

        // IR[h߂܂B
        // ӁFSystem.exit()ĂяoĂ_ɒӂĂB
        System.exit(retCode);
    }

    /**
     * ̓Iȃob`eLq邽߂̃\bhłB
     *
     * ̃\bhɎۂ̏eLq܂B
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IOException o͗OꍇB
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public int process(final BlancoXliffUtilExtractStateProcessInput input) throws IOException, IllegalArgumentException {
        // ̓p[^`FbN܂B
        validateInput(input);

        // ̉ӏŃRpCG[ꍇABlancoXliffUtilExtractStateProcessC^tF[X blanco.xliff.util.taskpbP[W BlancoXliffUtilExtractStateProcessImplNX쐬邱Ƃɂłꍇ܂B
        final BlancoXliffUtilExtractStateProcess process = new BlancoXliffUtilExtractStateProcessImpl();

        // ̖{̂s܂B
        final int retCode = process.execute(input);

        return retCode;
    }

    /**
     * NXCX^Xăob`sۂ̃Gg|CgłB
     *
     * ̃\bh͉L̎dl񋟂܂B
     * <ul>
     * <li>\bh̓̓p[^̓e`FbNB
     * <li>IllegalArgumentException, RuntimeException, ErrorȂǂ̗OcatchĖ߂lւƕϊB
     * </ul>
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public final int execute(final BlancoXliffUtilExtractStateProcessInput input) throws IllegalArgumentException {
        try {
            // ob`̖{̂s܂B
            int retCode = process(input);

            return retCode;
        } catch (IllegalArgumentException ex) {
            System.out.println("BlancoXliffUtilExtractStateBatchProcess: ͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_ILLEGAL_ARGUMENT_EXCEPTION;
        } catch (IOException ex) {
            System.out.println("BlancoXliffUtilExtractStateBatchProcess: o͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_IO_EXCEPTION;
        } catch (RuntimeException ex) {
            System.out.println("BlancoXliffUtilExtractStateBatchProcess: ^CO܂Bob`𒆒f܂B:" + ex.toString());
            ex.printStackTrace();
            // ُIB
            return END_ERROR;
        } catch (Error er) {
            System.out.println("BlancoXliffUtilExtractStateBatchProcess: ^CG[܂Bob`𒆒f܂B:" + er.toString());
            er.printStackTrace();
            // ُIB
            return END_ERROR;
        }
    }

    /**
     * ̃ob`NX̎g̐Wo͂Ɏ߂̃\bhłB
     */
    public static final void usage() {
        System.out.println("BlancoXliffUtilExtractStateBatchProcess: Usage:");
        System.out.println("  java blanco.xliff.util.task.BlancoXliffUtilExtractStateBatchProcess -verbose=l1 -targetfile=l2 -xliffdir=l3 -state=l4");
        System.out.println("    -verbose");
        System.out.println("      [verbose[hœ삳邩ǂB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[false]");
        System.out.println("    -targetfile");
        System.out.println("      [o͑Ώۂ XLIFF (*.xlf) t@C]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -xliffdir");
        System.out.println("      [͑Ώۂ XLIFF (*.xlf) t@C܂܂fBNgB]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -state");
        System.out.println("      [trans-unit  state lB]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -? , -help");
        System.out.println("      [g\܂B]");
    }

    /**
     * ̃ob`NX̓̓p[^̑Ó`FbN{邽߂̃\bhłB
     *
     * @param input ob`̓̓p[^B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public void validateInput(final BlancoXliffUtilExtractStateProcessInput input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException("BlancoBatchProcessBatchProcess: JnsB̓p[^[input]null^܂B");
        }
        if (input.getTargetfile() == null) {
            throw new IllegalArgumentException("BlancoXliffUtilExtractStateBatchProcess: JnsB̓p[^[input]̕K{tB[hl[targetfile]ɒlݒ肳Ă܂B");
        }
        if (input.getXliffdir() == null) {
            throw new IllegalArgumentException("BlancoXliffUtilExtractStateBatchProcess: JnsB̓p[^[input]̕K{tB[hl[xliffdir]ɒlݒ肳Ă܂B");
        }
        if (input.getState() == null) {
            throw new IllegalArgumentException("BlancoXliffUtilExtractStateBatchProcess: JnsB̓p[^[input]̕K{tB[hl[state]ɒlݒ肳Ă܂B");
        }
    }
}
