/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.cat.build.stepcounter.record;

/**
 * blancoCsvファイル定義書から作成されたレコードクラス\nファイル定義[StepCounterSummary]のレコードクラス\n
 */
public class StepCounterSummaryCsvRecord {
    /**
     * 項目の説明: プラグイン名\n必須項目\n
     *
     * フィールド: [pluginName]。
     */
    private String fPluginName;

    /**
     * 項目の説明: ソース行数\n必須項目\n
     *
     * フィールド: [src]。
     */
    private int fSrc;

    /**
     * 項目の説明: blanco行数\n必須項目\n
     *
     * フィールド: [blanco]。
     */
    private int fBlanco;

    /**
     * 項目の説明: xml行数\n必須項目\n
     *
     * フィールド: [xml]。
     */
    private int fXml;

    /**
     * フィールド [pluginName] の値を設定します。
     *
     * フィールドの説明: [項目の説明: プラグイン名
     * 必須項目
     * ]。
     *
     * @param argPluginName フィールド[pluginName]に設定する値。
     */
    public void setPluginName(final String argPluginName) {
        fPluginName = argPluginName;
    }

    /**
     * フィールド [pluginName] の値を取得します。
     *
     * フィールドの説明: [項目の説明: プラグイン名
     * 必須項目
     * ]。
     *
     * @return フィールド[pluginName]から取得した値。
     */
    public String getPluginName() {
        return fPluginName;
    }

    /**
     * フィールド [src] の値を設定します。
     *
     * フィールドの説明: [項目の説明: ソース行数
     * 必須項目
     * ]。
     *
     * @param argSrc フィールド[src]に設定する値。
     */
    public void setSrc(final int argSrc) {
        fSrc = argSrc;
    }

    /**
     * フィールド [src] の値を取得します。
     *
     * フィールドの説明: [項目の説明: ソース行数
     * 必須項目
     * ]。
     *
     * @return フィールド[src]から取得した値。
     */
    public int getSrc() {
        return fSrc;
    }

    /**
     * フィールド [blanco] の値を設定します。
     *
     * フィールドの説明: [項目の説明: blanco行数
     * 必須項目
     * ]。
     *
     * @param argBlanco フィールド[blanco]に設定する値。
     */
    public void setBlanco(final int argBlanco) {
        fBlanco = argBlanco;
    }

    /**
     * フィールド [blanco] の値を取得します。
     *
     * フィールドの説明: [項目の説明: blanco行数
     * 必須項目
     * ]。
     *
     * @return フィールド[blanco]から取得した値。
     */
    public int getBlanco() {
        return fBlanco;
    }

    /**
     * フィールド [xml] の値を設定します。
     *
     * フィールドの説明: [項目の説明: xml行数
     * 必須項目
     * ]。
     *
     * @param argXml フィールド[xml]に設定する値。
     */
    public void setXml(final int argXml) {
        fXml = argXml;
    }

    /**
     * フィールド [xml] の値を取得します。
     *
     * フィールドの説明: [項目の説明: xml行数
     * 必須項目
     * ]。
     *
     * @return フィールド[xml]から取得した値。
     */
    public int getXml() {
        return fXml;
    }

    /**
     * このバリューオブジェクトの文字列表現を取得します。
     *
     * <P>使用上の注意</P>
     * <UL>
     * <LI>オブジェクトのシャロー範囲のみ文字列化の処理対象となります。
     * <LI>オブジェクトが循環参照している場合には、このメソッドは使わないでください。
     * </UL>
     *
     * @return バリューオブジェクトの文字列表現。
     */
    @Override
    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("benten.cat.build.stepcounter.record.StepCounterSummaryCsvRecord[");
        buf.append("pluginName=" + fPluginName);
        buf.append(",src=" + fSrc);
        buf.append(",blanco=" + fBlanco);
        buf.append(",xml=" + fXml);
        buf.append("]");
        return buf.toString();
    }
}
