import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import blanco.commons.util.BlancoStringUtil;

public class DigestDir {

    /**
     * @param args
     */
    public static void main(String[] args) {
        try {
            new DigestDir().process(new File(args[0]));
        } catch (IOException e) {
            e.printStackTrace();
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    /**
     * ディレクトリ処理。
     * 
     * @param fileDir
     * @throws IOException
     * @throws NoSuchAlgorithmException
     */
    public void process(final File fileDir) throws IOException,
            NoSuchAlgorithmException {
        final File[] files = fileDir.listFiles();
        for (int index = 0; index < files.length; index++) {
            if (files[index].isDirectory()) {
                process(files[index]);
            } else {
                System.out.println(BlancoStringUtil
                        .toHexString(digestMD5(files[index]))
                        + "    " + files[index].getPath());
            }
        }
    }

    /**
     * MD5 ダイジェスト。
     * 
     * @param file
     * @return
     * @throws NoSuchAlgorithmException
     * @throws IOException
     */
    public byte[] digestMD5(final File file) throws NoSuchAlgorithmException,
            IOException {
        final MessageDigest md5 = MessageDigest.getInstance("MD5");
        final DigestInputStream inStream = new DigestInputStream(
                new BufferedInputStream(new FileInputStream(file)), md5);
        try {
            byte[] buf = new byte[2048];
            for (;;) {
                final int length = inStream.read(buf);
                if (length < 0) {
                    break;
                }
            }
            return md5.digest();
        } finally {
            inStream.close();
        }
    }
}
