package benten.cat.build.stepcounter.task;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

import benten.cat.build.stepcounter.io.BlancoCsvIOException;
import benten.cat.build.stepcounter.io.StepCounterCsvReader;
import benten.cat.build.stepcounter.io.StepCounterSummaryCsvWriter;
import benten.cat.build.stepcounter.record.StepCounterCsvRecord;
import benten.cat.build.stepcounter.record.StepCounterSummaryCsvRecord;
import benten.cat.build.stepcounter.task.valueobject.StepCounterCsvProcessInput;

public class StepCounterCsvProcessImpl implements StepCounterCsvProcess {

    /**
     * {@inheritDoc}
     */
    public int execute(final StepCounterCsvProcessInput input)
            throws IOException, IllegalArgumentException {
        run(input);
        return 0;
    }

    private void run(StepCounterCsvProcessInput input) {
        BufferedWriter writer = null;
        StepCounterSummaryCsvWriter csvWriter = new StepCounterSummaryCsvWriter();

        try {
            writer = new BufferedWriter(new BufferedWriter(
                    new OutputStreamWriter(new FileOutputStream("result.csv"))));
            csvWriter.setWriter(writer);

            // benten.cat.data.feature
            csvWriter.writeRecord(getSummary(input, "benten.cat.data.feature"));
            // benten.cat.engine.feature
            csvWriter
                    .writeRecord(getSummary(input, "benten.cat.engine.feature"));
            // benten.cat.feature
            csvWriter.writeRecord(getSummary(input, "benten.cat.feature"));

            // benten.cat.ui
            csvWriter.writeRecord(getSummary(input, "benten.cat.ui"));
            // benten.cat.validation
            csvWriter.writeRecord(getSummary(input, "benten.cat.validation"));
            // benten.cat.tm.ui
            csvWriter.writeRecord(getSummary(input, "benten.cat.tm.ui"));
            // benten.cat.glossary.ui
            csvWriter.writeRecord(getSummary(input, "benten.cat.glossary.ui"));
            // benten.cat.tm.core
            csvWriter.writeRecord(getSummary(input, "benten.cat.tm.core"));
            // benten.cat.tm.data.tmx
            csvWriter.writeRecord(getSummary(input, "benten.cat.tm.data.tmx"));
            // benten.cat.tm.engine.omegat
            csvWriter.writeRecord(getSummary(input,
                    "benten.cat.tm.engine.omegat"));
            // benten.cat.glossary.core
            csvWriter
                    .writeRecord(getSummary(input, "benten.cat.glossary.core"));
            // benten.cat.glossary.data.tsv
            csvWriter.writeRecord(getSummary(input,
                    "benten.cat.glossary.data.tsv"));
            // benten.cat.glossary.engine.omegat
            csvWriter.writeRecord(getSummary(input,
                    "benten.cat.glossary.engine.omegat"));
            // benten.twa.tmx
            csvWriter.writeRecord(getSummary(input, "benten.twa.tmx"));
            // benten.twa.xliff
            csvWriter.writeRecord(getSummary(input, "benten.twa.xliff"));
            // benten.twa.cat
            csvWriter.writeRecord(getSummary(input, "benten.twa.cat"));
            // benten.twa
            csvWriter.writeRecord(getSummary(input, "benten.twa"));
            // benten.twa.ui
            csvWriter.writeRecord(getSummary(input, "benten.twa.ui"));
            // benten.twa.filter
            csvWriter.writeRecord(getSummary(input, "benten.twa.filter"));
            // benten.cat.stat
            csvWriter.writeRecord(getSummary(input, "benten.cat.stat"));
            // benten.core
            csvWriter.writeRecord(getSummary(input, "benten.core"));
            // benten.ui
            csvWriter.writeRecord(getSummary(input, "benten.ui"));

            csvWriter.flush();

        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (BlancoCsvIOException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                csvWriter.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private StepCounterSummaryCsvRecord getSummary(
            StepCounterCsvProcessInput input, String pluginName) {
        StepCounterSummaryCsvRecord result = new StepCounterSummaryCsvRecord();

        result.setPluginName(pluginName);
        result.setSrc(calcTotal(input.getTargetDir(), pluginName + "_src.csv"));
        result.setBlanco(calcTotal(input.getTargetDir(), pluginName
                + "_blanco.csv"));
        result.setXml(calcTotal(input.getTargetDir(), pluginName + "_xml.csv"));

        return result;
    }

    private int calcTotal(String target, String fileName) {
        int loc_total = 0;

        BufferedReader reader = null;
        StepCounterCsvReader csvReader = new StepCounterCsvReader();

        try {
            reader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(target + "/" + fileName)));
            csvReader.setReader(reader);

            for (;;) {
                StepCounterCsvRecord record = null;
                try {
                    record = csvReader.readRecord();
                } catch (BlancoCsvIOException e) {
                    e.printStackTrace();
                }
                if (record == null) {
                    break;
                }

                loc_total += record.getLoc();

                System.out.print(record.getName() + " ");
                System.out.println(record.getLoc());
            }

        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        System.out.println("loc_total=" + loc_total);
        return loc_total;
    }

    /**
     * {@inheritDoc}
     */
    public boolean progress(final String argProgressMessage) {
        System.out.println(argProgressMessage);
        return false;
    }
}
