/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.glossary.engine.omegat;

import java.io.File;
import java.io.IOException;

import junit.framework.TestCase;
import benten.core.io.Files;

public class DefaultGlossaryEngineTest extends TestCase {

	public void testSearch() throws IOException {

		final DefaultGlossaryEngine target = new DefaultGlossaryEngine();
		try {
			target.loadTsv(null);
			fail();
		} catch (final NullPointerException e) {
			assertTrue(true);
		}
		try {
			target.search(null);
			fail();
		} catch (final NullPointerException e) {
			assertTrue(true);
		}

		final File tsvFile = File.createTempFile("benten", ".tsv");
		for (final File file : tsvFile.getParentFile().listFiles()) {
			if (file != tsvFile && file.getName().endsWith(".tsv")) {
				file.delete();
			}
		}
		tsvFile.deleteOnExit();
		Files.writeStringToFile(tsvFile, "aaa\tあああ\tコメント\r\n" + "bbb\tいいい\t\r\n", "UTF-8");
		target.loadTsv(tsvFile.getParentFile());

		assertEquals(0, target.search("a").size());
		assertEquals(1, target.search("aaa").size());
		assertEquals("aaa", target.search("aaa").get(0).getSource());
		assertEquals("あああ", target.search("aaa").get(0).getTarget());
		assertEquals("コメント", target.search("aaa").get(0).getNote());

		assertEquals(1, target.search("bbb").size());
		assertEquals("bbb", target.search("bbb").get(0).getSource());
		assertEquals("いいい", target.search("bbb").get(0).getTarget());
		assertEquals("", target.search("bbb").get(0).getNote());

		target.unload();

		assertEquals(0, target.search("a").size());
		assertEquals(0, target.search("aaa").size());
		assertEquals(0, target.search("bbb").size());

		target.loadTsv(tsvFile.getParentFile());

		assertEquals(0, target.search("a").size());
		assertEquals(1, target.search("aaa").size());
	}
}
